/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.ActiveSection;
import com.ibm.jvm.format.ProcessorSection;
import com.ibm.jvm.format.ServiceSection;
import com.ibm.jvm.format.StartupSection;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.TraceRecordExternal;
import com.ibm.jvm.format.TraceRecordInternal;
import com.ibm.jvm.format.TraceSection;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;

public final class TraceFileHeader
implements com.ibm.jvm.trace.TraceFileHeader {
    private String eyecatcher_string;
    private long length;
    private int version;
    private int modification;
    private int bufferSize;
    private int endianSignature;
    private int traceStart;
    private int serviceStart;
    private int startupStart;
    private int activeStart;
    private int processorStart;
    private final int BIG_ENDIAN_SIG = 305419896;
    private final int LITTLE_ENDIAN_SIG = 2018915346;
    private TraceFile traceFile;
    private static boolean UTEfile = false;
    private static boolean validHeader = false;
    protected TraceSection traceSection;
    private ServiceSection serviceSection;
    private StartupSection startupSection;
    private ActiveSection activeSection;
    private ProcessorSection processorSection;
    protected static final int INTERNAL = 0;
    protected static final int EXTERNAL = 1;

    protected TraceFileHeader(TraceFile traceFile) throws IOException {
        this.traceFile = traceFile;
        try {
            this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
            if (this.eyecatcher_string.substring(0, 4).equals("UTTH")) {
                UTEfile = true;
            }
            int n = traceFile.readI();
            this.version = traceFile.readI();
            this.modification = traceFile.readI();
            this.bufferSize = traceFile.readI();
            this.endianSignature = traceFile.readI();
            switch (this.endianSignature) {
                case 305419896: {
                    Util.Debug.println("Endian is BIG");
                    traceFile.setBigEndian(true);
                    Util.setBigEndian(true);
                    this.length = n;
                    break;
                }
                case 2018915346: {
                    Util.Debug.println("Endian is LITTLE");
                    traceFile.setBigEndian(false);
                    Util.setBigEndian(false);
                    this.length = Util.convertEndian(n);
                    this.version = Util.convertEndian(this.version);
                    this.modification = Util.convertEndian(this.modification);
                    this.bufferSize = Util.convertEndian(this.bufferSize);
                    break;
                }
                default: {
                    TraceFormat.outStream.println("TraceFileHeader has invalid endian signature");
                    TraceFormat.outStream.println("Please check that the input file is a binary trace file");
                    return;
                }
            }
            Util.Debug.println("TraceFileHeader: eyecatcher:       " + this.eyecatcher_string);
            Util.Debug.println("TraceFileHeader: length:           " + this.length);
            Util.Debug.println("TraceFileHeader: version:          " + this.version);
            Util.Debug.println("TraceFileHeader: modification:     " + this.modification);
            Util.Debug.println("TraceFileHeader: bufferSize:       " + this.bufferSize);
            TraceFormat.verMod = (float)this.version + (float)this.modification / 10.0f;
            Util.Debug.println("TraceFileHeader: verMod:           " + TraceFormat.verMod);
            this.traceStart = traceFile.readI();
            this.serviceStart = traceFile.readI();
            this.startupStart = traceFile.readI();
            this.activeStart = traceFile.readI();
            this.processorStart = traceFile.readI();
            this.traceSection = new TraceSection(traceFile, this.traceStart);
            this.serviceSection = new ServiceSection(traceFile, this.serviceStart);
            this.startupSection = new StartupSection(traceFile, this.startupStart);
            this.activeSection = new ActiveSection(traceFile, this.activeStart);
            this.processorSection = new ProcessorSection(traceFile, this.processorStart);
            validHeader = true;
        }
        catch (EOFException eOFException) {
            if (traceFile.length() == 0L) {
                TraceFormat.outStream.println("Trace file " + traceFile + " is empty");
            } else {
                TraceFormat.outStream.println("TraceFileHeader in " + traceFile + " is truncated or corrupt - cannot complete formatting");
            }
            throw eOFException;
        }
    }

    protected final void processTraceBufferHeaders() throws IOException {
        int n = 0;
        for (long i = this.length; i < this.traceFile.length(); i += (long)this.bufferSize) {
            ++n;
            if (this.traceSection.getTraceType() == 0) {
                new TraceRecordInternal(this.traceFile, i);
                continue;
            }
            new TraceRecordExternal(this.traceFile, i);
        }
        TraceFormat.outStream.println("Found " + n + " Trace Buffers in file " + this.traceFile.toString());
        if (TraceFormat.invalidBuffers > 0) {
            TraceFormat.outStream.println("*** WARNING *** found " + TraceFormat.invalidBuffers + " invalid Trace Buffers");
            TraceFormat.outStream.println("attempting to format the remainder");
        }
        Util.Debug.println("TraceFileHeader: number of buffers = " + n);
        TraceFormat.expectedRecords = n;
    }

    protected final void summarize(BufferedWriter bufferedWriter) throws IOException {
        if (!validHeader) {
            return;
        }
        this.serviceSection.summary(bufferedWriter);
        this.startupSection.summary(bufferedWriter);
        this.activeSection.summary(bufferedWriter);
        this.processorSection.summary(bufferedWriter);
    }

    protected final long getLength() {
        return this.length;
    }

    protected final int getBufferSize() {
        return this.bufferSize;
    }

    protected final String formatFileName() {
        return this.serviceSection.formatFileName();
    }

    protected final String getVMLevel() {
        return this.serviceSection.getVMLevel();
    }

    protected final String getNextFormatFileName(String string) {
        return this.serviceSection.getNextFormatFileName(string);
    }

    protected static final boolean isUTE() {
        return UTEfile;
    }

    public final long getTraceDataStart() {
        return this.length;
    }

    @Override
    public String getVMVersion() {
        return this.serviceSection.getServiceLevel();
    }

    @Override
    public String[] getVMStartUpParameters() {
        return this.startupSection.getStartUpOptions();
    }

    @Override
    public String[] getTraceParameters() {
        return null;
    }

    @Override
    public String[] getSysProcessorInfo() {
        return null;
    }

    @Override
    public long getJVMStartedMillis() {
        return 0L;
    }

    @Override
    public long getLastBufferWriteMillis() {
        return 0L;
    }

    @Override
    public long getFirstTracePointMillis() {
        return 0L;
    }

    @Override
    public long getLastTracePointMillis() {
        return 0L;
    }
}

