/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolAddressOrderedList;
import java.util.NoSuchElementException;

class GCFreeListHeapIteratorAddressOrderedList
extends GCFreeListHeapIterator {
    protected GCHeapLinkedFreeHeader _currentFreeEntry = null;
    protected GCMemoryPoolAddressOrderedList _memoryPool = null;

    public GCFreeListHeapIteratorAddressOrderedList(GCMemoryPoolAddressOrderedList gCMemoryPoolAddressOrderedList) throws CorruptDataException {
        this._memoryPool = gCMemoryPoolAddressOrderedList;
        this._currentFreeEntry = gCMemoryPoolAddressOrderedList.getFirstFreeEntry();
        if (this._currentFreeEntry.getHeader().isNull()) {
            this._currentFreeEntry = null;
        }
    }

    private void advanceFreeListEntry() {
        try {
            this._currentFreeEntry = this._currentFreeEntry.getNext();
            if (this._currentFreeEntry.getHeader().isNull()) {
                this._currentFreeEntry = null;
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Freelist corruption detected", corruptDataException, false);
            this._currentFreeEntry = null;
        }
    }

    @Override
    public int getFreeListNumber() {
        return 0;
    }

    @Override
    public boolean hasNext() {
        return null != this._currentFreeEntry;
    }

    @Override
    public GCHeapLinkedFreeHeader next() throws NoSuchElementException {
        if (this.hasNext()) {
            GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader = this._currentFreeEntry;
            this.advanceFreeListEntry();
            return gCHeapLinkedFreeHeader;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public String toString() {
        GCFreeListHeapIteratorAddressOrderedList gCFreeListHeapIteratorAddressOrderedList = null;
        try {
            gCFreeListHeapIteratorAddressOrderedList = new GCFreeListHeapIteratorAddressOrderedList(this._memoryPool);
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Corruption detected", corruptDataException, false);
            return corruptDataException.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        while (gCFreeListHeapIteratorAddressOrderedList.hasNext()) {
            stringBuilder.append(gCFreeListHeapIteratorAddressOrderedList.next() + string);
        }
        return stringBuilder.toString();
    }
}

