/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackmap.LocalMap;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class LocalMapCommand
extends Command {
    public LocalMapCommand() {
        this.addCommand("localmap", "<pc>", "calculate the local slot map for the specified PC");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            if (stringArray.length != 1) {
                CommandUtils.dbgPrint(printStream, "bad or missing PC\n");
                return;
            }
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
            U8Pointer u8Pointer = U8Pointer.cast(l);
            CommandUtils.dbgPrint(printStream, "Searching for PC=%d in VM=%s...\n", u8Pointer.longValue(), j9JavaVMPointer.getHexAddress());
            J9MethodPointer j9MethodPointer = J9JavaVMHelper.getMethodFromPC(j9JavaVMPointer, u8Pointer);
            if (j9MethodPointer.notNull()) {
                long l2;
                int[] nArray = new int[2048];
                CommandUtils.dbgPrint(printStream, "Found method %s !j9method %s\n", J9MethodHelper.getName(j9MethodPointer), j9MethodPointer.getHexAddress());
                UDATA uDATA = new UDATA(u8Pointer.sub(U8Pointer.cast(j9MethodPointer.bytecodes())));
                CommandUtils.dbgPrint(printStream, "Relative PC = %d\n", uDATA.longValue());
                J9ClassPointer j9ClassPointer = ConstantPoolHelpers.J9_CLASS_FROM_METHOD(j9MethodPointer);
                CommandUtils.dbgPrint(printStream, "Method index is %d\n", l2);
                J9ROMMethodPointer j9ROMMethodPointer = this.J9ROMCLASS_ROMMETHODS(j9ClassPointer.romClass());
                for (l2 = new UDATA(j9MethodPointer.sub(j9ClassPointer.ramMethods())).longValue(); l2 != 0L; --l2) {
                    j9ROMMethodPointer = ROMHelp.nextROMMethod(j9ROMMethodPointer);
                }
                CommandUtils.dbgPrint(printStream, "Using ROM method %s\n", j9ROMMethodPointer.getHexAddress());
                U16 u16 = j9ROMMethodPointer.tempCount();
                U8 u8 = j9ROMMethodPointer.argCount();
                long l3 = u16.add(u8).longValue();
                if (l3 > 0L) {
                    int n = LocalMap.j9localmap_LocalBitsForPC(j9ROMMethodPointer, uDATA, nArray);
                    if (n != 0) {
                        CommandUtils.dbgPrint(printStream, "Local map failed, error code = %d\n", n);
                    } else {
                        int n2 = nArray[(int)((l3 + 31L) / 32L)];
                        long l4 = 0L;
                        CommandUtils.dbgPrint(printStream, "Local map (%d slots mapped): local %d --> ", l3, l3 - 1L);
                        long l5 = l3 % 32L;
                        if (l5 != 0L) {
                            l4 = n2 << (int)(32L - l5);
                            --n2;
                        }
                        while (l3 != 0L) {
                            if (l5 == 0L) {
                                l4 = n2;
                                --n2;
                                l5 = 32L;
                            }
                            CommandUtils.dbgPrint(printStream, "%d", (l4 & 1L) != 0L ? 1 : 0);
                            l4 <<= 1;
                            --l5;
                            --l3;
                        }
                        CommandUtils.dbgPrint(printStream, " <-- local 0\n");
                    }
                } else {
                    CommandUtils.dbgPrint(printStream, "No locals to map\n");
                }
            } else {
                CommandUtils.dbgPrint(printStream, "Not found\n");
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private J9ROMMethodPointer J9ROMCLASS_ROMMETHODS(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        return j9ROMClassPointer.romMethods();
    }
}

