/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import java.io.PrintStream;

public class WalkJ9PoolCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public WalkJ9PoolCommand() {
        this.addCommand("walkj9pool", "<address>", "Walks the elements of J9Pool");
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("walkj9pool <address> - Walks the elements of J9Pool");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (0 == stringArray.length || 1 < stringArray.length) {
            this.printUsage(printStream);
        }
        long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
        printStream.append("J9Pool at 0x" + CommandUtils.longToBigInteger(l).toString(16) + "\n{\n");
        this.walkJ9Pool(l, printStream);
        printStream.append("}\n");
    }

    private void walkJ9Pool(long l, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9PoolPointer j9PoolPointer = J9PoolPointer.cast(l);
            Pool<VoidPointer> pool = Pool.fromJ9Pool(j9PoolPointer, VoidPointer.class);
            SlotIterator<VoidPointer> slotIterator = pool.iterator();
            int n = 0;
            while (slotIterator.hasNext()) {
                VoidPointer voidPointer = (VoidPointer)slotIterator.next();
                printStream.println(String.format("\t[%d]\t=\t%s", n++, voidPointer.getHexAddress()));
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException("Either address is not a valid pool address or pool itself is corrupted.");
        }
    }
}

