/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.extract;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.jvm.j9.dump.extract.JPackCoreFatalException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.stream.ImageInputStream;

public class Main {
    private static final String J9_LIB_NAME = "j9jextract";
    private static final int ZIP_BUFFER_SIZE = 32768;
    private static int JPACKCORE_SUCCESS = 0;
    private static int JPACKCORE_SYNTAX_ERROR = 1;
    private static int JPACKCORE_FILE_ERROR = 2;
    private static int JPACKCORE_NOJVM_ERROR = 3;
    private static int JPACKCORE_ADDRESS_ERROR = 4;
    private static int JPACKCORE_VERSION_ERROR = 5;
    private static int JPACKCORE_INTERNAL_ERROR = 6;
    private final DummyBuilder _builder;
    private final List<String> _diagnostics = new ArrayList<String>();
    private final ICoreFileReader _dump;
    private final String _dumpName;
    private final boolean _excludeCoreFile;
    private final boolean _throwExceptions;
    private final boolean _verbose;
    private final String _zipFileName;

    public static void main(String[] stringArray) {
        Main main = new Main(stringArray);
        main.runZip();
        if (main._dump != null) {
            try {
                main._dump.releaseResources();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void ensure(boolean bl, String string) {
        if (!bl) {
            this.usageMessage(string, JPACKCORE_SYNTAX_ERROR);
        }
    }

    private void usageMessage(String string, int n) {
        this.report("Usage: jpackcore [options] dump_name [output_filename]");
        this.report("  output filename defaults to dump_name.zip");
        this.report("  options:");
        this.report("    -e                  throw exceptions instead of calling System.exit()");
        this.report("    -f executable_name  override executable name");
        this.report("    -help               print this usage message");
        this.report("    -p prefix           prefix for all paths (absolute or relative)");
        this.report("    -r                  relax version checking");
        this.report("    -v                  enable verbose output");
        this.report("    -x                  exclude dump_name from output file");
        this.report("    --                  mark end of options");
        this.errorMessage(string, n);
    }

    private void errorMessage(String string, int n) {
        if (this._throwExceptions) {
            throw new JPackCoreFatalException(string, n);
        }
        if (string != null) {
            this.report(string);
        }
        System.exit(n);
    }

    private void errorMessage(String string, int n, Throwable throwable) {
        throwable.printStackTrace();
        if (this._throwExceptions) {
            throw new JPackCoreFatalException(string, n);
        }
        if (string != null) {
            this.report(string);
        }
        System.exit(n);
    }

    private Main(String[] stringArray) {
        Object object;
        Object object2;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        File file = null;
        if (stringArray.length == 0) {
            this.usageMessage(null, JPACKCORE_SUCCESS);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = stringArray[i];
            if (!bl3 && ((String)object2).startsWith("-")) {
                if ("--".equals(object2)) {
                    bl3 = true;
                    continue;
                }
                if ("-help".equals(object2)) {
                    this.usageMessage(null, JPACKCORE_SUCCESS);
                    continue;
                }
                if ("-f".equals(object2)) {
                    this.ensure(++i < stringArray.length && !stringArray[i].startsWith("-"), "Syntax error: -f option specified with no filename following");
                    object2 = stringArray[i];
                    object = new File((String)object2);
                    this.ensure(((File)object).exists() && ((File)object).canRead(), "File specified using -f option (\"" + (String)object2 + "\") not found.");
                    System.setProperty("com.ibm.dtfj.corereaders.executable", (String)object2);
                    continue;
                }
                if ("-p".equals(object2)) {
                    this.ensure(++i < stringArray.length && !stringArray[i].startsWith("-"), "Syntax error: -p option specified but no virtual root directory given");
                    object2 = stringArray[i];
                    object = new File((String)object2);
                    this.ensure(((File)object).exists() && ((File)object).canRead() && ((File)object).isDirectory(), "Virtual directory specified using -p option (\"" + (String)object2 + "\") does not exist as a readable directory.");
                    file = new File((String)object2);
                    continue;
                }
                if (((String)object2).equals("-v")) {
                    bl5 = true;
                    continue;
                }
                if (((String)object2).equals("-e")) {
                    bl4 = true;
                    continue;
                }
                if (((String)object2).equals("-r")) {
                    bl = true;
                    continue;
                }
                if (((String)object2).equals("-x")) {
                    bl2 = true;
                    continue;
                }
                this.usageMessage("Unrecognized option: " + (String)object2, JPACKCORE_SYNTAX_ERROR);
                continue;
            }
            if (string == null) {
                string = object2;
                continue;
            }
            if (string2 == null) {
                string2 = object2;
                continue;
            }
            this.usageMessage("Too many file arguments: " + (String)object2, JPACKCORE_SYNTAX_ERROR);
        }
        if (string == null) {
            this.usageMessage("No dump file specified", JPACKCORE_SYNTAX_ERROR);
        }
        this._dumpName = string;
        this._verbose = bl5;
        this._throwExceptions = bl4;
        this._excludeCoreFile = bl2;
        this._zipFileName = null != string2 ? string2 : string.concat(".zip");
        try {
            System.loadLibrary(J9_LIB_NAME);
        }
        catch (SecurityException securityException) {
            this.errorMessage("Error. Security permissions don't allow required native library to be loaded.", JPACKCORE_INTERNAL_ERROR);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.errorMessage("Error. Native library j9jextract cannot be found. Please check your path.", JPACKCORE_INTERNAL_ERROR);
        }
        catch (Exception exception) {
            this.errorMessage("Error. Unexpected exception occurred loading: j9jextract", JPACKCORE_INTERNAL_ERROR, exception);
        }
        this.report("Loading dump file...");
        File file2 = new File(string);
        object2 = null;
        try {
            object2 = new ClosingFileReader(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!file2.exists()) {
                this.errorMessage("Error. Could not find dump file: " + string, JPACKCORE_FILE_ERROR);
            } else if (!file2.canRead()) {
                this.errorMessage("Error. Unable to read dump file (check permission): " + string, JPACKCORE_FILE_ERROR);
            } else {
                this.errorMessage("Error. Unexpected FileNotFoundException occurred opening: " + string, JPACKCORE_FILE_ERROR, fileNotFoundException);
            }
        }
        catch (IOException iOException) {
            this.errorMessage(iOException.getMessage(), JPACKCORE_FILE_ERROR);
        }
        object = null;
        try {
            object = DumpFactory.createDumpForCore((ImageInputStream)object2, this._verbose);
        }
        catch (Exception exception) {
            this.errorMessage("Error. Unexpected Exception occurred opening: " + string, JPACKCORE_FILE_ERROR, exception);
        }
        if (null == object) {
            this.errorMessage("Error. Dump type not recognised, file: " + string, JPACKCORE_FILE_ERROR);
            try {
                ((ClosingFileReader)object2).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (object.isTruncated()) {
            this.report("Warning: dump file is truncated. Extracted information may be incomplete.");
        }
        long l = 0L;
        try {
            l = this.getEnvironmentPointer(object.getAddressSpace(), bl);
        }
        catch (Throwable throwable) {
            this.errorMessage("Error. Unable to locate executable for " + string, JPACKCORE_INTERNAL_ERROR, throwable);
        }
        this._builder = new DummyBuilder(file, l);
        this._dump = object;
        this._dump.extract(this._builder);
        this.report("Read memory image from " + this._dumpName);
    }

    private void runZip() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add(this._dumpName);
        Object object = this._dump.getAdditionalFileNames();
        while (object.hasNext()) {
            linkedHashSet.add((String)object.next());
        }
        if (this._excludeCoreFile) {
            linkedHashSet.remove(this._dumpName);
        }
        try {
            String string;
            String string2;
            String string3;
            object = System.getProperty("java.home") + File.separator + "lib" + File.separator;
            String string4 = (String)object + "TraceFormat.dat";
            if (new File(string4).exists()) {
                linkedHashSet.add(string4);
            }
            if (new File(string3 = (String)object + "J9TraceFormat.dat").exists()) {
                linkedHashSet.add(string3);
            }
            if (new File(string2 = (String)object + "OMRTraceFormat.dat").exists()) {
                linkedHashSet.add(string2);
            }
            if ("AIX".equalsIgnoreCase(string = System.getProperty("os.name"))) {
                linkedHashSet.add("libdbx_j9.so");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this._excludeCoreFile ? Collections.singleton(this._dumpName) : Collections.emptySet();
        try {
            this.createZipFromFileNames(linkedHashSet, (Collection<String>)object, this._builder);
        }
        catch (Exception exception) {
            this.errorMessage(exception.getMessage(), JPACKCORE_INTERNAL_ERROR, exception);
        }
        this.report("jpackcore complete.");
    }

    private void report(String string) {
        System.err.println(string);
        this._diagnostics.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZipFromFileNames(Collection<String> collection, Collection<String> collection2, Builder builder) throws Exception {
        this.report("Creating archive file: " + this._zipFileName);
        try {
            Cloneable cloneable;
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this._zipFileName));
            if (!collection2.isEmpty()) {
                this.report("Adding \"excluded-files.txt\"");
                cloneable = new ZipEntry("excluded-files.txt");
                ((ZipEntry)cloneable).setTime(System.currentTimeMillis());
                zipOutputStream.putNextEntry((ZipEntry)cloneable);
                try {
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)zipOutputStream, StandardCharsets.UTF_8));
                    printWriter.println("Files omitted from archive");
                    printWriter.println("==========================");
                    for (String string : collection2) {
                        printWriter.println(string);
                    }
                    printWriter.flush();
                }
                finally {
                    zipOutputStream.closeEntry();
                }
            }
            byte[] byArray = new byte[32768];
            cloneable = new HashSet();
            for (String string : collection) {
                try {
                    ClosingFileReader closingFileReader = builder.openFile(string);
                    Object object = null;
                    try {
                        boolean bl = closingFileReader.isMVSFile();
                        String string2 = closingFileReader.getAbsolutePath();
                        if (bl || string2.equals(new File(string).getAbsolutePath())) {
                            this.report("Adding \"" + string + "\"");
                        } else {
                            this.report("Adding \"" + string + "\" (found at \"" + string2 + "\")");
                        }
                        if (bl) {
                            zipOutputStream.putNextEntry(new ZipEntry(string));
                            cloneable.add(string);
                            Main.copy(closingFileReader, (OutputStream)zipOutputStream, byArray);
                            continue;
                        }
                        if (cloneable.contains(string2)) continue;
                        InputStream inputStream = closingFileReader.streamFromFile();
                        ZipEntry zipEntry = new ZipEntry(string2);
                        cloneable.add(string2);
                        zipEntry.setTime(new File(string2).lastModified());
                        zipOutputStream.putNextEntry(zipEntry);
                        Main.copy(inputStream, (OutputStream)zipOutputStream, byArray);
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (closingFileReader == null) continue;
                        if (object != null) {
                            try {
                                closingFileReader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        closingFileReader.close();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.report("Warning:  Could not find file \"" + string + "\" for inclusion in archive");
                }
                catch (IOException iOException) {
                    throw new Exception("Failure adding file " + string + " to archive", iOException);
                }
                finally {
                    zipOutputStream.closeEntry();
                }
            }
            this.report("Adding \"execution-log.txt\"");
            ZipEntry zipEntry = new ZipEntry("execution-log.txt");
            zipEntry.setTime(System.currentTimeMillis());
            zipOutputStream.putNextEntry(zipEntry);
            try {
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)zipOutputStream, StandardCharsets.UTF_8));
                printWriter.println("Execution log");
                printWriter.println("=============");
                for (String string : this._diagnostics) {
                    printWriter.println(string);
                }
                printWriter.flush();
            }
            finally {
                zipOutputStream.closeEntry();
            }
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                throw new Exception("Failure closing archive file (" + this._zipFileName + "): " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Exception("Could not find archive file to output to: " + fileNotFoundException.getMessage());
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    private static void copy(ClosingFileReader closingFileReader, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        while ((n = closingFileReader.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    private native long getEnvironmentPointer(IAbstractAddressSpace var1, boolean var2) throws Exception;

    private static final class DummyBuilder
    implements Builder {
        private final File _virtualRootDirectory;
        private final List<File> _successfulSearchPaths;
        private final long _environmentPointer;

        public DummyBuilder(File file, long l) {
            this._virtualRootDirectory = file;
            String string = System.getProperty("java.home");
            this._successfulSearchPaths = new ArrayList<File>();
            this._successfulSearchPaths.add(new File(string, "bin"));
            this._environmentPointer = l;
        }

        @Override
        public Object buildProcess(Object object, String string, String string2, Properties properties, Object object2, Iterator iterator, Object object3, Iterator iterator2, int n) {
            return new Object();
        }

        @Override
        public Object buildRegister(String string, Number number) {
            return new Register(string, number.longValue());
        }

        @Override
        public Object buildStackSection(Object object, long l, long l2) {
            return new Object();
        }

        @Override
        public Object buildThread(String string, Iterator iterator, Iterator iterator2, Iterator iterator3, Properties properties, int n) {
            return new Object();
        }

        @Override
        public Object buildModuleSection(Object object, String string, long l, long l2) {
            return new Object();
        }

        @Override
        public Object buildModule(String string, Properties properties, Iterator iterator, Iterator iterator2, long l) {
            return new Object();
        }

        @Override
        public long getEnvironmentAddress() {
            return this._environmentPointer;
        }

        @Override
        public long getValueOfNamedRegister(List list, String string) {
            for (Register register : list) {
                if (!string.equals(register.name)) continue;
                return register.value;
            }
            return -1L;
        }

        @Override
        public Object buildStackFrame(Object object, long l, long l2) {
            return new Object();
        }

        @Override
        public ClosingFileReader openFile(String string) throws IOException {
            File file = new File(string);
            if (null != this._virtualRootDirectory && file.isAbsolute()) {
                file = DummyBuilder.sysFileRelative(this._virtualRootDirectory, file);
            } else {
                if (file.exists()) {
                    File file2;
                    ClosingFileReader closingFileReader = new ClosingFileReader(file);
                    File file3 = file.getParentFile();
                    if (null != file3 && !this._successfulSearchPaths.contains(file2 = file3.getAbsoluteFile())) {
                        this._successfulSearchPaths.add(file2);
                    }
                    return closingFileReader;
                }
                if (!file.isAbsolute()) {
                    Iterator<File> iterator = this._successfulSearchPaths.iterator();
                    String string2 = file.getName();
                    while (iterator.hasNext()) {
                        File file4 = iterator.next();
                        File file5 = new File(file4, string2);
                        if (!file5.exists()) continue;
                        return new ClosingFileReader(file5);
                    }
                }
            }
            return new ClosingFileReader(file);
        }

        private static File sysFileRelative(File file, File file2) {
            File file3 = file2;
            while (null != file3.getParentFile()) {
                file3 = file3.getParentFile();
            }
            File file4 = file2;
            if (file2.isAbsolute()) {
                String string = file2.getAbsolutePath().substring(file3.getAbsolutePath().length());
                file4 = new File(file, string);
            }
            return file4;
        }

        @Override
        public Object buildSymbol(Object object, String string, long l) {
            return new Object();
        }

        @Override
        public void setExecutableUnavailable(String string) {
        }

        @Override
        public Object buildAddressSpace(String string, int n) {
            return new Object();
        }

        @Override
        public void setOSType(String string) {
        }

        @Override
        public void setCPUType(String string) {
        }

        @Override
        public void setCPUSubType(String string) {
        }

        @Override
        public void setCreationTime(long l) {
        }

        @Override
        public Object buildCorruptData(Object object, String string, long l) {
            return new Object();
        }

        private static final class Register {
            final String name;
            final long value;

            Register(String string, long l) {
                this.name = string;
                this.value = l;
            }
        }
    }
}

