/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.jar.Pack200;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.misc.JarIndex;
import sun.tools.jar.CommandLine;
import sun.tools.jar.JarException;

public class Main {
    String program;
    PrintStream out;
    PrintStream err;
    String fname;
    String mname;
    String ename;
    String zname = "";
    String[] files;
    String rootjar = null;
    Map<String, File> entryMap = new HashMap<String, File>();
    Set<File> entries = new LinkedHashSet<File>();
    Set<String> paths = new HashSet<String>();
    boolean cflag;
    boolean uflag;
    boolean xflag;
    boolean tflag;
    boolean vflag;
    boolean flag0;
    boolean Mflag;
    boolean iflag;
    boolean nflag;
    boolean pflag;
    boolean kflag;
    static final String MANIFEST_DIR = "META-INF/";
    static final String VERSION = "1.0";
    private static ResourceBundle rsrc;
    private static final boolean useExtractionTime;
    private boolean ok;
    private byte[] copyBuf = new byte[8192];
    private HashSet<String> jarPaths = new HashSet();

    private String getMsg(String string) {
        try {
            return rsrc.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Error in message file");
        }
    }

    private String formatMsg(String string, String string2) {
        String string3 = this.getMsg(string);
        String[] stringArray = new String[]{string2};
        return MessageFormat.format(string3, stringArray);
    }

    private String formatMsg2(String string, String string2, String string3) {
        String string4 = this.getMsg(string);
        String[] stringArray = new String[]{string2, string3};
        return MessageFormat.format(string4, stringArray);
    }

    public Main(PrintStream printStream, PrintStream printStream2, String string) {
        this.out = printStream;
        this.err = printStream2;
        this.program = string;
    }

    private static File createTempFileInSameDirectoryAs(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File(".");
        }
        return File.createTempFile("jartmp", null, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean run(String[] stringArray) {
        block89: {
            this.ok = true;
            if (!this.parseArgs(stringArray)) {
                return false;
            }
            try {
                if ((this.cflag || this.uflag) && this.fname != null) {
                    this.zname = this.fname.replace(File.separatorChar, '/');
                    if (this.zname.startsWith("./")) {
                        this.zname = this.zname.substring(2);
                    }
                }
                if (this.cflag) {
                    String string;
                    FileOutputStream fileOutputStream;
                    Manifest manifest = null;
                    FileInputStream fileInputStream = null;
                    if (!this.Mflag) {
                        if (this.mname != null) {
                            fileInputStream = new FileInputStream(this.mname);
                            manifest = new Manifest(new BufferedInputStream(fileInputStream));
                        } else {
                            manifest = new Manifest();
                        }
                        this.addVersion(manifest);
                        this.addCreatedBy(manifest);
                        if (this.isAmbiguousMainClass(manifest)) {
                            if (fileInputStream != null) {
                                ((InputStream)fileInputStream).close();
                            }
                            return false;
                        }
                        if (this.ename != null) {
                            this.addMainClass(manifest, this.ename);
                        }
                    }
                    this.expand(null, this.files, false);
                    if (this.fname != null) {
                        fileOutputStream = new FileOutputStream(this.fname);
                    } else {
                        fileOutputStream = new FileOutputStream(FileDescriptor.out);
                        if (this.vflag) {
                            this.vflag = false;
                        }
                    }
                    File file = null;
                    FileOutputStream fileOutputStream2 = fileOutputStream;
                    String string2 = string = this.fname == null ? "tmpjar" : this.fname.substring(this.fname.indexOf(File.separatorChar) + 1);
                    if (this.nflag) {
                        file = this.createTemporaryFile(string, ".jar");
                        fileOutputStream = new FileOutputStream(file);
                    }
                    this.create(new BufferedOutputStream(fileOutputStream, 4096), manifest);
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                    ((OutputStream)fileOutputStream).close();
                    if (!this.nflag) break block89;
                    ZipFile zipFile = null;
                    File file2 = null;
                    ZipOutputStream zipOutputStream = null;
                    try {
                        Pack200.Packer packer = Pack200.newPacker();
                        SortedMap<String, String> sortedMap = packer.properties();
                        sortedMap.put("pack.effort", "1");
                        zipFile = new JarFile(file.getCanonicalPath());
                        file2 = this.createTemporaryFile(string, ".pack");
                        fileOutputStream = new FileOutputStream(file2);
                        packer.pack((JarFile)zipFile, (OutputStream)fileOutputStream);
                        zipOutputStream = new JarOutputStream(fileOutputStream2);
                        Pack200.Unpacker unpacker = Pack200.newUnpacker();
                        unpacker.unpack(file2, (JarOutputStream)zipOutputStream);
                        break block89;
                    }
                    catch (IOException iOException) {
                        this.fatalError(iOException);
                        break block89;
                    }
                    finally {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        if (fileOutputStream != null) {
                            ((OutputStream)fileOutputStream).close();
                        }
                        if (zipOutputStream != null) {
                            zipOutputStream.close();
                        }
                        if (file != null && file.exists()) {
                            file.delete();
                        }
                        if (file2 != null && file2.exists()) {
                            file2.delete();
                        }
                    }
                }
                if (this.uflag) {
                    FileOutputStream fileOutputStream;
                    FileInputStream fileInputStream;
                    File file = null;
                    File file3 = null;
                    if (this.fname != null) {
                        file = new File(this.fname);
                        file3 = Main.createTempFileInSameDirectoryAs(file);
                        fileInputStream = new FileInputStream(file);
                        fileOutputStream = new FileOutputStream(file3);
                    } else {
                        fileInputStream = new FileInputStream(FileDescriptor.in);
                        fileOutputStream = new FileOutputStream(FileDescriptor.out);
                        this.vflag = false;
                    }
                    FileInputStream fileInputStream2 = !this.Mflag && this.mname != null ? new FileInputStream(this.mname) : null;
                    this.expand(null, this.files, true);
                    boolean bl = this.update(fileInputStream, new BufferedOutputStream(fileOutputStream), fileInputStream2, null);
                    if (this.ok) {
                        this.ok = bl;
                    }
                    fileInputStream.close();
                    fileOutputStream.close();
                    if (fileInputStream2 != null) {
                        ((InputStream)fileInputStream2).close();
                    }
                    if (this.ok && this.fname != null) {
                        file.delete();
                        if (!file3.renameTo(file)) {
                            file3.delete();
                            throw new IOException(this.getMsg("error.write.file"));
                        }
                        file3.delete();
                    }
                    break block89;
                }
                if (this.tflag) {
                    this.replaceFSC(this.files);
                    if (this.fname != null) {
                        this.list(this.fname, this.files);
                        break block89;
                    }
                    try (FileInputStream fileInputStream = new FileInputStream(FileDescriptor.in);
                         BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                        this.list(bufferedInputStream, this.files);
                        break block89;
                    }
                }
                if (this.xflag) {
                    this.replaceFSC(this.files);
                    if (this.fname != null) {
                        this.extract(this.fname, this.files);
                        break block89;
                    }
                    try (FileInputStream fileInputStream = new FileInputStream(FileDescriptor.in);
                         BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                        this.extract(bufferedInputStream, this.files);
                        break block89;
                    }
                }
                if (this.iflag) {
                    this.genIndex(this.rootjar, this.files);
                }
            }
            catch (IOException iOException) {
                this.fatalError(iOException);
                this.ok = false;
            }
            catch (Error error) {
                error.printStackTrace();
                this.ok = false;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.ok = false;
            }
        }
        this.out.flush();
        this.err.flush();
        return this.ok;
    }

    boolean parseArgs(String[] stringArray) {
        int n;
        int n2;
        try {
            stringArray = CommandLine.parse(stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fatalError(this.formatMsg("error.cant.open", fileNotFoundException.getMessage()));
            return false;
        }
        catch (IOException iOException) {
            this.fatalError(iOException);
            return false;
        }
        int n3 = 1;
        try {
            String string = stringArray[0];
            if (string.startsWith("-")) {
                string = string.substring(1);
            }
            block23: for (n2 = 0; n2 < string.length(); ++n2) {
                switch (string.charAt(n2)) {
                    case 'c': {
                        if (this.xflag || this.tflag || this.uflag || this.iflag) {
                            this.usageError();
                            return false;
                        }
                        this.cflag = true;
                        continue block23;
                    }
                    case 'u': {
                        if (this.cflag || this.xflag || this.tflag || this.iflag) {
                            this.usageError();
                            return false;
                        }
                        this.uflag = true;
                        continue block23;
                    }
                    case 'x': {
                        if (this.cflag || this.uflag || this.tflag || this.iflag) {
                            this.usageError();
                            return false;
                        }
                        this.xflag = true;
                        continue block23;
                    }
                    case 't': {
                        if (this.cflag || this.uflag || this.xflag || this.iflag) {
                            this.usageError();
                            return false;
                        }
                        this.tflag = true;
                        continue block23;
                    }
                    case 'M': {
                        this.Mflag = true;
                        continue block23;
                    }
                    case 'v': {
                        this.vflag = true;
                        continue block23;
                    }
                    case 'f': {
                        this.fname = stringArray[n3++];
                        continue block23;
                    }
                    case 'm': {
                        this.mname = stringArray[n3++];
                        continue block23;
                    }
                    case '0': {
                        this.flag0 = true;
                        continue block23;
                    }
                    case 'k': {
                        this.kflag = true;
                        continue block23;
                    }
                    case 'i': {
                        if (this.cflag || this.uflag || this.xflag || this.tflag) {
                            this.usageError();
                            return false;
                        }
                        this.rootjar = stringArray[n3++];
                        this.iflag = true;
                        continue block23;
                    }
                    case 'n': {
                        this.nflag = true;
                        continue block23;
                    }
                    case 'e': {
                        this.ename = stringArray[n3++];
                        continue block23;
                    }
                    case 'P': {
                        this.pflag = true;
                        continue block23;
                    }
                    default: {
                        this.error(this.formatMsg("error.illegal.option", String.valueOf(string.charAt(n2))));
                        this.usageError();
                        return false;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.usageError();
            return false;
        }
        if (!(this.cflag || this.tflag || this.xflag || this.uflag || this.iflag)) {
            this.error(this.getMsg("error.bad.option"));
            this.usageError();
            return false;
        }
        if (this.kflag && !this.xflag) {
            this.warn(this.formatMsg("warn.option.is.ignored", "k"));
        }
        if ((n = stringArray.length - n3) > 0) {
            n2 = 0;
            String[] stringArray2 = new String[n];
            try {
                for (int i = n3; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("-C")) {
                        String string;
                        string = (string = stringArray[++i]).endsWith(File.separator) ? string : string + File.separator;
                        string = string.replace(File.separatorChar, '/');
                        while (string.indexOf("//") > -1) {
                            string = string.replace("//", "/");
                        }
                        this.paths.add(string.replace(File.separatorChar, '/'));
                        stringArray2[n2++] = string + stringArray[++i];
                        continue;
                    }
                    stringArray2[n2++] = stringArray[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.usageError();
                return false;
            }
            this.files = new String[n2];
            System.arraycopy((Object)stringArray2, 0, (Object)this.files, 0, n2);
        } else {
            if (this.cflag && this.mname == null) {
                this.error(this.getMsg("error.bad.cflag"));
                this.usageError();
                return false;
            }
            if (this.uflag) {
                if (this.mname != null || this.ename != null) {
                    return true;
                }
                this.error(this.getMsg("error.bad.uflag"));
                this.usageError();
                return false;
            }
        }
        return true;
    }

    void expand(File file, String[] stringArray, boolean bl) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = file == null ? new File(stringArray[i]) : new File(file, stringArray[i]);
            if (file2.isFile()) {
                if (!this.entries.add(file2) || !bl) continue;
                this.entryMap.put(this.entryName(file2.getPath()), file2);
                continue;
            }
            if (file2.isDirectory()) {
                if (!this.entries.add(file2)) continue;
                if (bl) {
                    String string = file2.getPath();
                    string = string.endsWith(File.separator) ? string : string + File.separator;
                    this.entryMap.put(this.entryName(string), file2);
                }
                this.expand(file2, file2.list(), bl);
                continue;
            }
            this.error(this.formatMsg("error.nosuch.fileordir", String.valueOf(file2)));
            this.ok = false;
        }
    }

    void create(OutputStream outputStream, Manifest manifest) throws IOException {
        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
        if (this.flag0) {
            jarOutputStream.setMethod(0);
        }
        if (manifest != null) {
            if (this.vflag) {
                this.output(this.getMsg("out.added.manifest"));
            }
            Object object = new ZipEntry(MANIFEST_DIR);
            ((ZipEntry)object).setTime(System.currentTimeMillis());
            ((ZipEntry)object).setSize(0L);
            ((ZipEntry)object).setCrc(0L);
            ((ZipOutputStream)jarOutputStream).putNextEntry((ZipEntry)object);
            object = new ZipEntry("META-INF/MANIFEST.MF");
            ((ZipEntry)object).setTime(System.currentTimeMillis());
            if (this.flag0) {
                this.crc32Manifest((ZipEntry)object, manifest);
            }
            ((ZipOutputStream)jarOutputStream).putNextEntry((ZipEntry)object);
            manifest.write(jarOutputStream);
            jarOutputStream.closeEntry();
        }
        for (File file : this.entries) {
            this.addFile(jarOutputStream, file);
        }
        jarOutputStream.close();
    }

    private char toUpperCaseASCII(char c) {
        return c < 'a' || c > 'z' ? c : (char)(c + 65 - 97);
    }

    private boolean equalsIgnoreCase(String string, String string2) {
        assert (string2.toUpperCase(Locale.ENGLISH).equals(string2));
        int n = string.length();
        if (n != string2.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i)) || this.toUpperCaseASCII(c2) == c) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean update(InputStream inputStream, OutputStream outputStream, InputStream inputStream2, JarIndex jarIndex) throws IOException {
        boolean bl = true;
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);
             JarOutputStream jarOutputStream = new JarOutputStream(outputStream);){
            Object object;
            if (jarIndex != null) {
                this.addIndex(jarIndex, jarOutputStream);
            }
            ZipEntry zipEntry = null;
            boolean bl2 = false;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object object2;
                object = zipEntry.getName();
                boolean bl3 = this.equalsIgnoreCase((String)object, "META-INF/MANIFEST.MF");
                if (jarIndex != null && this.equalsIgnoreCase((String)object, "META-INF/INDEX.LIST") || this.Mflag && bl3) continue;
                if (bl3 && (inputStream2 != null || this.ename != null)) {
                    bl2 = true;
                    if (inputStream2 != null) {
                        object2 = new FileInputStream(this.mname);
                        Throwable throwable = null;
                        try {
                            if (this.isAmbiguousMainClass(new Manifest((InputStream)object2))) {
                                boolean bl4 = false;
                                return bl4;
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (object2 != null) {
                                if (throwable != null) {
                                    try {
                                        ((FileInputStream)object2).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    ((FileInputStream)object2).close();
                                }
                            }
                        }
                    }
                    object2 = new Manifest(zipInputStream);
                    if (inputStream2 != null) {
                        ((Manifest)object2).read(inputStream2);
                    }
                    if (this.updateManifest((Manifest)object2, jarOutputStream)) continue;
                    boolean bl5 = false;
                    return bl5;
                }
                if (!this.entryMap.containsKey(object)) {
                    object2 = new ZipEntry((String)object);
                    ((ZipEntry)object2).setMethod(zipEntry.getMethod());
                    ((ZipEntry)object2).setTime(zipEntry.getTime());
                    ((ZipEntry)object2).setComment(zipEntry.getComment());
                    ((ZipEntry)object2).setExtra(zipEntry.getExtra());
                    if (zipEntry.getMethod() == 0) {
                        ((ZipEntry)object2).setSize(zipEntry.getSize());
                        ((ZipEntry)object2).setCrc(zipEntry.getCrc());
                    }
                    ((ZipOutputStream)jarOutputStream).putNextEntry((ZipEntry)object2);
                    this.copy((InputStream)zipInputStream, (OutputStream)jarOutputStream);
                    continue;
                }
                object2 = this.entryMap.get(object);
                this.addFile(jarOutputStream, (File)object2);
                this.entryMap.remove(object);
                this.entries.remove(object2);
            }
            for (File file : this.entries) {
                this.addFile(jarOutputStream, file);
            }
            if (bl2) return bl;
            if (inputStream2 != null) {
                object = new Manifest(inputStream2);
                bl = !this.isAmbiguousMainClass((Manifest)object);
                if (!bl) return bl;
                if (this.updateManifest((Manifest)object, jarOutputStream)) return bl;
                bl = false;
                return bl;
            }
            if (this.ename == null) return bl;
            if (this.updateManifest(new Manifest(), jarOutputStream)) return bl;
            bl = false;
            return bl;
        }
    }

    private void addIndex(JarIndex jarIndex, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry("META-INF/INDEX.LIST");
        zipEntry.setTime(System.currentTimeMillis());
        if (this.flag0) {
            CRC32OutputStream cRC32OutputStream = new CRC32OutputStream();
            jarIndex.write(cRC32OutputStream);
            cRC32OutputStream.updateEntry(zipEntry);
        }
        zipOutputStream.putNextEntry(zipEntry);
        jarIndex.write(zipOutputStream);
        zipOutputStream.closeEntry();
    }

    private boolean updateManifest(Manifest manifest, ZipOutputStream zipOutputStream) throws IOException {
        this.addVersion(manifest);
        this.addCreatedBy(manifest);
        if (this.ename != null) {
            this.addMainClass(manifest, this.ename);
        }
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        zipEntry.setTime(System.currentTimeMillis());
        if (this.flag0) {
            this.crc32Manifest(zipEntry, manifest);
        }
        zipOutputStream.putNextEntry(zipEntry);
        manifest.write(zipOutputStream);
        if (this.vflag) {
            this.output(this.getMsg("out.update.manifest"));
        }
        return true;
    }

    private static final boolean isWinDriveLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private String safeName(String string) {
        if (!this.pflag) {
            int n = string.length();
            int n2 = string.lastIndexOf("../");
            n2 = n2 == -1 ? 0 : (n2 += 3);
            if (File.separatorChar == '\\') {
                while (n2 < n) {
                    int n3 = n2;
                    if (n2 + 1 < n && string.charAt(n2 + 1) == ':' && Main.isWinDriveLetter(string.charAt(n2))) {
                        n2 += 2;
                    }
                    while (n2 < n && string.charAt(n2) == '/') {
                        ++n2;
                    }
                    if (n2 != n3) continue;
                    break;
                }
            } else {
                while (n2 < n && string.charAt(n2) == '/') {
                    ++n2;
                }
            }
            if (n2 != 0) {
                string = string.substring(n2);
            }
        }
        return string;
    }

    private String entryName(String string) {
        string = string.replace(File.separatorChar, '/');
        String string2 = "";
        for (String string3 : this.paths) {
            if (!string.startsWith(string3) || string3.length() <= string2.length()) continue;
            string2 = string3;
        }
        string = string.substring(string2.length());
        if ((string = this.safeName(string)).startsWith("./")) {
            string = string.substring(2);
        }
        return string;
    }

    private void addVersion(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, VERSION);
        }
    }

    private void addCreatedBy(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue(new Attributes.Name("Created-By")) == null) {
            String string = System.getProperty("java.vendor");
            String string2 = System.getProperty("java.version");
            attributes.put(new Attributes.Name("Created-By"), string2 + " (" + string + ")");
        }
    }

    private void addMainClass(Manifest manifest, String string) {
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MAIN_CLASS, string);
    }

    private boolean isAmbiguousMainClass(Manifest manifest) {
        Attributes attributes;
        if (this.ename != null && (attributes = manifest.getMainAttributes()).get(Attributes.Name.MAIN_CLASS) != null) {
            this.error(this.getMsg("error.bad.eflag"));
            this.usageError();
            return true;
        }
        return false;
    }

    void addFile(ZipOutputStream zipOutputStream, File file) throws IOException {
        long l;
        String string = file.getPath();
        boolean bl = file.isDirectory();
        if (bl) {
            String string2 = string = string.endsWith(File.separator) ? string : string + File.separator;
        }
        if ((string = this.entryName(string)).equals("") || string.equals(".") || string.equals(this.zname)) {
            return;
        }
        if ((string.equals(MANIFEST_DIR) || string.equals("META-INF/MANIFEST.MF")) && !this.Mflag) {
            if (this.vflag) {
                this.output(this.formatMsg("out.ignore.entry", string));
            }
            return;
        }
        long l2 = l = bl ? 0L : file.length();
        if (this.vflag) {
            this.out.print(this.formatMsg("out.adding", string));
        }
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(file.lastModified());
        if (l == 0L) {
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
        } else if (this.flag0) {
            this.crc32File(zipEntry, file);
        }
        zipOutputStream.putNextEntry(zipEntry);
        if (!bl) {
            this.copy(file, (OutputStream)zipOutputStream);
        }
        zipOutputStream.closeEntry();
        if (this.vflag) {
            l = zipEntry.getSize();
            long l3 = zipEntry.getCompressedSize();
            this.out.print(this.formatMsg2("out.size", String.valueOf(l), String.valueOf(l3)));
            if (zipEntry.getMethod() == 8) {
                long l4 = 0L;
                if (l != 0L) {
                    l4 = (l - l3) * 100L / l;
                }
                this.output(this.formatMsg("out.deflated", String.valueOf(l4)));
            } else {
                this.output(this.getMsg("out.stored"));
            }
        }
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        while ((n = inputStream.read(this.copyBuf)) != -1) {
            outputStream.write(this.copyBuf, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File file, OutputStream outputStream) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.copy((InputStream)fileInputStream, outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.copy(inputStream, (OutputStream)fileOutputStream);
        }
    }

    private void crc32Manifest(ZipEntry zipEntry, Manifest manifest) throws IOException {
        CRC32OutputStream cRC32OutputStream = new CRC32OutputStream();
        manifest.write(cRC32OutputStream);
        cRC32OutputStream.updateEntry(zipEntry);
    }

    private void crc32File(ZipEntry zipEntry, File file) throws IOException {
        CRC32OutputStream cRC32OutputStream = new CRC32OutputStream();
        this.copy(file, (OutputStream)cRC32OutputStream);
        if (cRC32OutputStream.n != file.length()) {
            throw new JarException(this.formatMsg("error.incorrect.length", file.getPath()));
        }
        cRC32OutputStream.updateEntry(zipEntry);
    }

    void replaceFSC(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].replace(File.separatorChar, '/');
            }
        }
    }

    Set<ZipEntry> newDirSet() {
        return new HashSet<ZipEntry>(){

            @Override
            public boolean add(ZipEntry zipEntry) {
                return zipEntry == null || useExtractionTime ? false : super.add(zipEntry);
            }
        };
    }

    void updateLastModifiedTime(Set<ZipEntry> set) throws IOException {
        for (ZipEntry zipEntry : set) {
            String string;
            long l = zipEntry.getTime();
            if (l == -1L || (string = this.safeName(zipEntry.getName().replace(File.separatorChar, '/'))).length() == 0) continue;
            File file = new File(string.replace('/', File.separatorChar));
            file.setLastModified(l);
        }
    }

    void extract(InputStream inputStream, String[] stringArray) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        Set<ZipEntry> set = this.newDirSet();
        block0: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (stringArray == null) {
                set.add(this.extractFile(zipInputStream, zipEntry));
                continue;
            }
            String string = zipEntry.getName();
            for (String string2 : stringArray) {
                if (!string.startsWith(string2)) continue;
                set.add(this.extractFile(zipInputStream, zipEntry));
                continue block0;
            }
        }
        this.updateLastModifiedTime(set);
    }

    void extract(String string, String[] stringArray) throws IOException {
        Set<ZipEntry> set;
        try (ZipFile zipFile = new ZipFile(string);){
            set = this.newDirSet();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            block9: while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (stringArray == null) {
                    set.add(this.extractFile(zipFile.getInputStream(zipEntry), zipEntry));
                    continue;
                }
                String string2 = zipEntry.getName();
                for (String string3 : stringArray) {
                    if (!string2.startsWith(string3)) continue;
                    set.add(this.extractFile(zipFile.getInputStream(zipEntry), zipEntry));
                    continue block9;
                }
            }
        }
        this.updateLastModifiedTime(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZipEntry extractFile(InputStream inputStream, ZipEntry zipEntry) throws IOException {
        long l;
        ZipEntry zipEntry2 = null;
        String string = this.safeName(zipEntry.getName().replace(File.separatorChar, '/'));
        if (string.length() == 0) {
            return zipEntry2;
        }
        File file = new File(string.replace('/', File.separatorChar));
        if (zipEntry.isDirectory()) {
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IOException(this.formatMsg("error.create.dir", file.getPath()));
                }
            } else {
                if (!file.mkdirs()) {
                    throw new IOException(this.formatMsg("error.create.dir", file.getPath()));
                }
                zipEntry2 = zipEntry;
            }
            if (this.vflag) {
                this.output(this.formatMsg("out.create", string));
            }
        } else {
            File file2;
            if (file.exists() && this.kflag) {
                if (this.vflag) {
                    this.output(this.formatMsg("out.kept", string));
                }
                return zipEntry2;
            }
            if (!(file.getParent() == null || ((file2 = new File(file.getParent())).exists() || file2.mkdirs()) && file2.isDirectory())) {
                throw new IOException(this.formatMsg("error.create.dir", file2.getPath()));
            }
            try {
                this.copy(inputStream, file);
            }
            finally {
                if (inputStream instanceof ZipInputStream) {
                    ((ZipInputStream)inputStream).closeEntry();
                } else {
                    inputStream.close();
                }
            }
            if (this.vflag) {
                if (zipEntry.getMethod() == 8) {
                    this.output(this.formatMsg("out.inflated", string));
                } else {
                    this.output(this.formatMsg("out.extracted", string));
                }
            }
        }
        if (!useExtractionTime && (l = zipEntry.getTime()) != -1L) {
            file.setLastModified(l);
        }
        return zipEntry2;
    }

    void list(InputStream inputStream, String[] stringArray) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            zipInputStream.closeEntry();
            this.printEntry(zipEntry, stringArray);
        }
    }

    void list(String string, String[] stringArray) throws IOException {
        try (ZipFile zipFile = new ZipFile(string);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                this.printEntry(enumeration.nextElement(), stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpIndex(String string, JarIndex jarIndex) throws IOException {
        block5: {
            File file = new File(string);
            Path path = file.toPath();
            Path path2 = Main.createTempFileInSameDirectoryAs(file).toPath();
            try {
                if (!this.update(Files.newInputStream(path, new OpenOption[0]), Files.newOutputStream(path2, new OpenOption[0]), null, jarIndex)) break block5;
                try {
                    Files.move(path2, path, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    throw new IOException(this.getMsg("error.write.file"), iOException);
                }
            }
            finally {
                Files.deleteIfExists(path2);
            }
        }
    }

    List<String> getJarPath(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.jarPaths.add(string);
        String string2 = string.substring(0, Math.max(0, string.lastIndexOf(47) + 1));
        try (JarFile jarFile = new JarFile(string.replace('/', File.separatorChar));){
            String string3;
            Attributes attributes;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (string3 = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (string4.endsWith("/") || this.jarPaths.contains(string4 = string2.concat(string4))) continue;
                    arrayList.addAll(this.getJarPath(string4));
                }
            }
        }
        return arrayList;
    }

    void genIndex(String string, String[] stringArray) throws IOException {
        List<String> list = this.getJarPath(string);
        int n = list.size();
        if (n == 1 && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                list.addAll(this.getJarPath(stringArray[i]));
            }
            n = list.size();
        }
        String[] stringArray2 = list.toArray(new String[n]);
        JarIndex jarIndex = new JarIndex(stringArray2);
        this.dumpIndex(string, jarIndex);
    }

    void printEntry(ZipEntry zipEntry, String[] stringArray) throws IOException {
        if (stringArray == null) {
            this.printEntry(zipEntry);
        } else {
            String string = zipEntry.getName();
            for (String string2 : stringArray) {
                if (!string.startsWith(string2)) continue;
                this.printEntry(zipEntry);
                return;
            }
        }
    }

    void printEntry(ZipEntry zipEntry) throws IOException {
        if (this.vflag) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = Long.toString(zipEntry.getSize());
            for (int i = 6 - string.length(); i > 0; --i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string).append(' ').append(new Date(zipEntry.getTime()).toString());
            stringBuilder.append(' ').append(zipEntry.getName());
            this.output(stringBuilder.toString());
        } else {
            this.output(zipEntry.getName());
        }
    }

    void usageError() {
        this.error(this.getMsg("usage"));
    }

    void fatalError(Exception exception) {
        exception.printStackTrace();
    }

    void fatalError(String string) {
        this.error(this.program + ": " + string);
    }

    protected void output(String string) {
        this.out.println(string);
    }

    protected void error(String string) {
        this.err.println(string);
    }

    void warn(String string) {
        this.err.println(string);
    }

    public static void main(String[] stringArray) {
        Main main = new Main(System.out, System.err, "jar");
        System.exit(main.run(stringArray) ? 0 : 1);
    }

    private File createTemporaryFile(String string, String string2) {
        File file = null;
        try {
            file = File.createTempFile(string, string2);
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        if (file == null) {
            if (this.fname != null) {
                try {
                    File file2 = new File(this.fname).getAbsoluteFile().getParentFile();
                    file = File.createTempFile(this.fname, ".tmp" + string2, file2);
                }
                catch (IOException iOException) {
                    this.fatalError(iOException);
                }
            } else {
                this.fatalError(new IOException(this.getMsg("error.create.tempfile")));
            }
        }
        return file;
    }

    static {
        useExtractionTime = Boolean.getBoolean("sun.tools.jar.useExtractionTime");
        try {
            rsrc = ResourceBundle.getBundle("sun.tools.jar.resources.jar");
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for jar is missing");
        }
    }

    private static class CRC32OutputStream
    extends OutputStream {
        final CRC32 crc = new CRC32();
        long n = 0L;

        CRC32OutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            this.crc.update(n);
            ++this.n;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.crc.update(byArray, n, n2);
            this.n += (long)n2;
        }

        public void updateEntry(ZipEntry zipEntry) {
            zipEntry.setMethod(0);
            zipEntry.setSize(this.n);
            zipEntry.setCrc(this.crc.getValue());
        }
    }
}

