/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import java.io.PrintStream;
import java.util.List;

public class J9MethodStructureFormatter
extends BaseStructureFormatter {
    @Override
    public FormatWalkResult postFormat(String string, long l, PrintStream printStream, Context context, List<IFieldFormatter> list, String[] stringArray) {
        J9MethodPointer j9MethodPointer;
        if (string.equalsIgnoreCase("j9method") && !(j9MethodPointer = J9MethodPointer.cast(l)).isNull()) {
            J9MethodStructureFormatter.writeMethodName(j9MethodPointer, printStream);
            J9MethodStructureFormatter.writeJ9ROMClassAddress(j9MethodPointer, printStream);
            J9MethodStructureFormatter.writeNextMethodAddress(j9MethodPointer, printStream);
        }
        return FormatWalkResult.KEEP_WALKING;
    }

    private static void writeJ9ROMClassAddress(J9MethodPointer j9MethodPointer, PrintStream printStream) {
        printStream.print("ROM Method: ");
        try {
            J9ROMMethodPointer j9ROMMethodPointer = J9MethodHelper.romMethod(j9MethodPointer);
            printStream.print("!j9rommethod ");
            printStream.print(j9ROMMethodPointer.getHexAddress());
        }
        catch (CorruptDataException corruptDataException) {
            printStream.print("<FAULT>");
        }
        finally {
            printStream.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMethodName(J9MethodPointer j9MethodPointer, PrintStream printStream) {
        printStream.print("Signature: ");
        try {
            J9ROMMethodPointer j9ROMMethodPointer = J9MethodHelper.romMethod(j9MethodPointer);
            J9ClassPointer j9ClassPointer = ConstantPoolHelpers.J9_CLASS_FROM_METHOD(j9MethodPointer);
            printStream.print(J9ClassHelper.getName(j9ClassPointer));
            printStream.print(".");
            printStream.print(J9ROMMethodHelper.getName(j9ROMMethodPointer));
            printStream.print(J9ROMMethodHelper.getSignature(j9ROMMethodPointer));
            printStream.print(" !bytecodes ");
            printStream.print(j9MethodPointer.getHexAddress());
        }
        catch (CorruptDataException corruptDataException) {
            printStream.print("<FAULT>");
        }
        finally {
            printStream.println();
        }
    }

    private static void writeNextMethodAddress(J9MethodPointer j9MethodPointer, PrintStream printStream) {
        printStream.print("Next Method: !j9method ");
        try {
            printStream.print(J9MethodHelper.nextMethod(j9MethodPointer).getHexAddress());
        }
        catch (CorruptDataException corruptDataException) {
            printStream.print("<FAULT>");
        }
        finally {
            printStream.println();
        }
    }
}

