/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.SharedAbstractHelperFactory;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassHelper;
import com.ibm.oti.shared.SharedClassHelperFactory;
import com.ibm.oti.shared.SharedClassTokenHelper;
import com.ibm.oti.shared.SharedClassTokenHelperImpl;
import com.ibm.oti.shared.SharedClassURLClasspathHelper;
import com.ibm.oti.shared.SharedClassURLClasspathHelperImpl;
import com.ibm.oti.shared.SharedClassURLHelper;
import com.ibm.oti.shared.SharedClassURLHelperImpl;
import com.ibm.oti.shared.SharedHelper;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.net.URL;
import java.util.WeakHashMap;

final class SharedClassHelperFactoryImpl
extends SharedAbstractHelperFactory
implements SharedClassHelperFactory {
    private static final WeakHashMap<ClassLoader, SharedHelper> helpers = new WeakHashMap();
    private static SharedClassFilter globalSharingFilter;
    private static final String GLOBAL_SHARING_FILTER = "com.ibm.oti.shared.SharedClassGlobalFilterClass";

    SharedClassHelperFactoryImpl() {
    }

    private static SharedClassFilter getGlobalSharingFilter() {
        if (globalSharingFilter == null) {
            try {
                String string = VM.internalGetProperties().getProperty(GLOBAL_SHARING_FILTER);
                if (null != string) {
                    Class<?> clazz = Class.forName(string);
                    globalSharingFilter = (SharedClassFilter)SharedClassFilter.class.cast(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return globalSharingFilter;
    }

    @Override
    public SharedClassHelper findHelperForClassLoader(ClassLoader classLoader) {
        return (SharedClassHelper)helpers.get(classLoader);
    }

    @Override
    public SharedClassTokenHelper getTokenHelper(ClassLoader classLoader, SharedClassFilter sharedClassFilter) throws HelperAlreadyDefinedException {
        SharedClassTokenHelper sharedClassTokenHelper = this.getTokenHelper(classLoader);
        if (sharedClassTokenHelper != null) {
            sharedClassTokenHelper.setSharingFilter(sharedClassFilter);
        }
        return sharedClassTokenHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedClassTokenHelper getTokenHelper(ClassLoader classLoader) throws HelperAlreadyDefinedException {
        if (classLoader == null) {
            return null;
        }
        WeakHashMap<ClassLoader, SharedHelper> weakHashMap = helpers;
        synchronized (weakHashMap) {
            SharedClassHelper sharedClassHelper = this.findHelperForClassLoader(classLoader);
            if (sharedClassHelper != null) {
                if (sharedClassHelper instanceof SharedClassTokenHelper) {
                    return (SharedClassTokenHelper)sharedClassHelper;
                }
                throw new HelperAlreadyDefinedException(Msg.getString("K059d"));
            }
            boolean bl = SharedClassHelperFactoryImpl.canFind(classLoader);
            boolean bl2 = SharedClassHelperFactoryImpl.canStore(classLoader);
            if (bl || bl2) {
                SharedClassTokenHelperImpl sharedClassTokenHelperImpl = new SharedClassTokenHelperImpl(classLoader, SharedClassHelperFactoryImpl.getNewID(), bl, bl2);
                SharedClassFilter sharedClassFilter = SharedClassHelperFactoryImpl.getGlobalSharingFilter();
                if (sharedClassFilter != null) {
                    sharedClassTokenHelperImpl.setSharingFilter(sharedClassFilter);
                }
                helpers.put(classLoader, sharedClassTokenHelperImpl);
                return sharedClassTokenHelperImpl;
            }
            return null;
        }
    }

    @Override
    public SharedClassURLHelper getURLHelper(ClassLoader classLoader, SharedClassFilter sharedClassFilter) throws HelperAlreadyDefinedException {
        SharedClassURLHelper sharedClassURLHelper = this.getURLHelper(classLoader);
        if (sharedClassURLHelper != null) {
            sharedClassURLHelper.setSharingFilter(sharedClassFilter);
        }
        return sharedClassURLHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedClassURLHelper getURLHelper(ClassLoader classLoader) throws HelperAlreadyDefinedException {
        if (classLoader == null) {
            return null;
        }
        WeakHashMap<ClassLoader, SharedHelper> weakHashMap = helpers;
        synchronized (weakHashMap) {
            SharedClassHelper sharedClassHelper = this.findHelperForClassLoader(classLoader);
            if (sharedClassHelper != null) {
                if (sharedClassHelper instanceof SharedClassURLHelper) {
                    return (SharedClassURLHelper)sharedClassHelper;
                }
                throw new HelperAlreadyDefinedException(Msg.getString("K059d"));
            }
            boolean bl = SharedClassHelperFactoryImpl.canFind(classLoader);
            boolean bl2 = SharedClassHelperFactoryImpl.canStore(classLoader);
            if (bl || bl2) {
                SharedClassURLHelperImpl sharedClassURLHelperImpl = new SharedClassURLHelperImpl(classLoader, SharedClassHelperFactoryImpl.getNewID(), bl, bl2);
                SharedClassFilter sharedClassFilter = SharedClassHelperFactoryImpl.getGlobalSharingFilter();
                if (sharedClassFilter != null) {
                    sharedClassURLHelperImpl.setSharingFilter(sharedClassFilter);
                }
                helpers.put(classLoader, sharedClassURLHelperImpl);
                return sharedClassURLHelperImpl;
            }
            return null;
        }
    }

    @Override
    public SharedClassURLClasspathHelper getURLClasspathHelper(ClassLoader classLoader, URL[] uRLArray, SharedClassFilter sharedClassFilter) throws HelperAlreadyDefinedException {
        SharedClassURLClasspathHelper sharedClassURLClasspathHelper = this.getURLClasspathHelper(classLoader, uRLArray);
        if (sharedClassURLClasspathHelper != null) {
            sharedClassURLClasspathHelper.setSharingFilter(sharedClassFilter);
        }
        return sharedClassURLClasspathHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedClassURLClasspathHelper getURLClasspathHelper(ClassLoader classLoader, URL[] uRLArray) throws HelperAlreadyDefinedException {
        if (classLoader == null || uRLArray == null) {
            return null;
        }
        WeakHashMap<ClassLoader, SharedHelper> weakHashMap = helpers;
        synchronized (weakHashMap) {
            SharedClassHelper sharedClassHelper = this.findHelperForClassLoader(classLoader);
            boolean bl = true;
            if (sharedClassHelper != null) {
                if (sharedClassHelper instanceof SharedClassURLClasspathHelper) {
                    SharedClassURLClasspathHelperImpl sharedClassURLClasspathHelperImpl = (SharedClassURLClasspathHelperImpl)sharedClassHelper;
                    URL[] uRLArray2 = sharedClassURLClasspathHelperImpl.getClasspath();
                    for (int i = 0; i < uRLArray.length; ++i) {
                        if (uRLArray[i].equals(uRLArray2[i])) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        return sharedClassURLClasspathHelperImpl;
                    }
                    throw new HelperAlreadyDefinedException(Msg.getString("K059e"));
                }
                throw new HelperAlreadyDefinedException(Msg.getString("K059d"));
            }
            boolean bl2 = SharedClassHelperFactoryImpl.canFind(classLoader);
            boolean bl3 = SharedClassHelperFactoryImpl.canStore(classLoader);
            if (bl2 || bl3) {
                SharedClassURLClasspathHelperImpl sharedClassURLClasspathHelperImpl = new SharedClassURLClasspathHelperImpl(classLoader, uRLArray, SharedClassHelperFactoryImpl.getNewID(), bl2, bl3);
                SharedClassFilter sharedClassFilter = SharedClassHelperFactoryImpl.getGlobalSharingFilter();
                if (sharedClassFilter != null) {
                    sharedClassURLClasspathHelperImpl.setSharingFilter(sharedClassFilter);
                }
                helpers.put(classLoader, sharedClassURLClasspathHelperImpl);
                return sharedClassURLClasspathHelperImpl;
            }
            return null;
        }
    }
}

