/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.util.Arrays;

public class GrowableIntArray {
    int[] array;
    int size;
    int cellSize;

    public GrowableIntArray(int n, int n2) {
        this.array = new int[n2];
        this.size = 0;
        this.cellSize = n;
    }

    private int getNextCellIndex() {
        int n = this.size;
        this.size += this.cellSize;
        if (this.size >= this.array.length) {
            this.growArray();
        }
        return n;
    }

    public int[] getArray() {
        return this.array;
    }

    public int[] getSizedArray() {
        return Arrays.copyOf(this.array, this.getSize());
    }

    public final int getNextIndex() {
        return this.getNextCellIndex() / this.cellSize;
    }

    protected final int getCellIndex(int n) {
        return this.cellSize * n;
    }

    public final int getInt(int n) {
        return this.array[n];
    }

    public final void addInt(int n) {
        int n2 = this.getNextIndex();
        this.array[n2] = n;
    }

    public final int getSize() {
        return this.size / this.cellSize;
    }

    public void clear() {
        this.size = 0;
    }

    protected void growArray() {
        int n = Math.max(this.array.length * 2, 10);
        int[] nArray = this.array;
        this.array = new int[n];
        System.arraycopy((Object)nArray, 0, (Object)this.array, 0, nArray.length);
    }
}

