/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.JITLook;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class JitMetadataFromPcCommand
extends Command {
    public JitMetadataFromPcCommand() {
        this.addCommand("jitmetadatafrompc", "<pc>", "Show jit method metadata for PC");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            UDATA uDATA = new UDATA(Long.decode(stringArray[0]));
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9JITExceptionTablePointer j9JITExceptionTablePointer = JITLook.jit_artifact_search(j9JavaVMPointer.jitConfig().translationArtifacts(), uDATA);
            if (!j9JITExceptionTablePointer.isNull()) {
                this.dbgext_j9jitexceptiontable(printStream, j9JITExceptionTablePointer);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    void dbgext_j9jitexceptiontable(PrintStream printStream, J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
        CommandUtils.dbgPrint(printStream, "J9JITExceptionTable at %s {\n", j9JITExceptionTablePointer.getHexAddress());
        CommandUtils.dbgPrint(printStream, "    struct J9UTF8* className = !j9utf8 %s   // %s\n", j9JITExceptionTablePointer.className().getHexAddress(), j9JITExceptionTablePointer.className().isNull() ? "NULL" : J9UTF8Helper.stringValue(j9JITExceptionTablePointer.className()));
        CommandUtils.dbgPrint(printStream, "    struct J9UTF8* methodName = !j9utf8 %s   // %s\n", j9JITExceptionTablePointer.methodName().getHexAddress(), j9JITExceptionTablePointer.methodName().isNull() ? "NULL" : J9UTF8Helper.stringValue(j9JITExceptionTablePointer.methodName()));
        CommandUtils.dbgPrint(printStream, "    struct J9UTF8* methodSignature = !j9utf8 %s   // %s\n", j9JITExceptionTablePointer.methodSignature().getHexAddress(), j9JITExceptionTablePointer.methodSignature().isNull() ? "NULL" : J9UTF8Helper.stringValue(j9JITExceptionTablePointer.methodSignature()));
        CommandUtils.dbgPrint(printStream, "    struct J9ConstantPool* constantPool = !j9constantpool %s \n", j9JITExceptionTablePointer.constantPool().getHexAddress());
        CommandUtils.dbgPrint(printStream, "    struct J9Method* ramMethod = !j9method %s   // %s\n", j9JITExceptionTablePointer.ramMethod().getHexAddress(), J9MethodHelper.getName(j9JITExceptionTablePointer.ramMethod()));
        CommandUtils.dbgPrint(printStream, "    UDATA parm.startPC = %s;\n", j9JITExceptionTablePointer.startPC().getHexValue());
        CommandUtils.dbgPrint(printStream, "    UDATA parm.endWarmPC = %s;\n", j9JITExceptionTablePointer.endWarmPC().getHexValue());
        CommandUtils.dbgPrint(printStream, "    UDATA parm.startColdPC = %s;\n", j9JITExceptionTablePointer.startColdPC().getHexValue());
        CommandUtils.dbgPrint(printStream, "    UDATA parm.endPC = %s;\n", j9JITExceptionTablePointer.endPC().getHexValue());
        CommandUtils.dbgPrint(printStream, "    UDATA parm.totalFrameSize = %s;\n", j9JITExceptionTablePointer.totalFrameSize().getHexValue());
        CommandUtils.dbgPrint(printStream, "    I_16 parm.slots = %s;\n", j9JITExceptionTablePointer.slots().getHexValue());
        CommandUtils.dbgPrint(printStream, "    I_16 parm.scalarTempSlots = %s;\n", j9JITExceptionTablePointer.scalarTempSlots().getHexValue());
        CommandUtils.dbgPrint(printStream, "    I_16 parm.objectTempSlots = %s;\n", j9JITExceptionTablePointer.objectTempSlots().getHexValue());
        CommandUtils.dbgPrint(printStream, "    U_16 parm.prologuePushes = %s;\n", j9JITExceptionTablePointer.prologuePushes().getHexValue());
        CommandUtils.dbgPrint(printStream, "    I_16 parm.tempOffset = %s;\n", j9JITExceptionTablePointer.tempOffset().getHexValue());
        CommandUtils.dbgPrint(printStream, "    U_16 parm.numExcptionRanges = %s;\n", j9JITExceptionTablePointer.numExcptionRanges().getHexValue());
        CommandUtils.dbgPrint(printStream, "    I_32 parm.size = %s;\n", j9JITExceptionTablePointer.size().getHexValue());
        CommandUtils.dbgPrint(printStream, "    UDATA parm.registerSaveDescription = %s;\n", j9JITExceptionTablePointer.registerSaveDescription().getHexValue());
        CommandUtils.dbgPrint(printStream, "    void* gcStackAtlas = !void %s \n", j9JITExceptionTablePointer.gcStackAtlas().getHexAddress());
        CommandUtils.dbgPrint(printStream, "    void* inlinedCalls = !void %s \n", j9JITExceptionTablePointer.inlinedCalls().getHexAddress());
        CommandUtils.dbgPrint(printStream, "    void* bodyInfo = !void %s \n", j9JITExceptionTablePointer.bodyInfo().getHexAddress());
        CommandUtils.dbgPrint(printStream, "    struct J9JITExceptionTable* nextMethod = !j9jitexceptiontable %s \n", j9JITExceptionTablePointer.nextMethod().getHexAddress());
        CommandUtils.dbgPrint(printStream, "    struct J9JITExceptionTable* prevMethod = !j9jitexceptiontable %s \n", j9JITExceptionTablePointer.prevMethod().getHexAddress());
        CommandUtils.dbgPrint(printStream, "    void* debugSlot1 = !void %s \n", j9JITExceptionTablePointer.debugSlot1().getHexAddress());
        CommandUtils.dbgPrint(printStream, "    void* debugSlot2 = !void %s \n", j9JITExceptionTablePointer.debugSlot2().getHexAddress());
        CommandUtils.dbgPrint(printStream, "    void* osrInfo = !void %s \n", j9JITExceptionTablePointer.osrInfo().getHexAddress());
        CommandUtils.dbgPrint(printStream, "    void* runtimeAssumptionList = !void %s \n", j9JITExceptionTablePointer.runtimeAssumptionList().getHexAddress());
        CommandUtils.dbgPrint(printStream, "    I_32 parm.hotness = %s;\n", j9JITExceptionTablePointer.hotness().getHexValue());
        CommandUtils.dbgPrint(printStream, "    UDATA parm.codeCacheAlloc = %s;\n", j9JITExceptionTablePointer.codeCacheAlloc().getHexValue());
        CommandUtils.dbgPrint(printStream, "    void* gpuCode = !void %s \n", j9JITExceptionTablePointer.gpuCode().getHexAddress());
        CommandUtils.dbgPrint(printStream, "    void* riData = !void %s \n", j9JITExceptionTablePointer.riData().getHexAddress());
        CommandUtils.dbgPrint(printStream, "}\n");
    }
}

