/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.types;

import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.IScalar;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;

public class IDATA
extends IScalar {
    public static final int SIZEOF;
    public static final long MASK;
    public static final IDATA MIN;
    public static final IDATA MAX;

    public IDATA(long l) {
        super(l & MASK);
    }

    public IDATA(Scalar scalar) {
        super(scalar);
    }

    public IDATA add(U8 u8) {
        return this.add(new IDATA(u8));
    }

    public IDATA add(U16 u16) {
        return this.add(new IDATA(u16));
    }

    public IDATA add(U32 u32) {
        return this.add(new IDATA(u32));
    }

    public boolean eq(U32 u32) {
        return this.eq(new IDATA(u32));
    }

    public UDATA add(UDATA uDATA) {
        return new UDATA(this).add(uDATA);
    }

    public boolean eq(UDATA uDATA) {
        return new UDATA(this).eq(uDATA);
    }

    public IDATA add(IScalar iScalar) {
        return this.add(new IDATA(iScalar));
    }

    public IDATA add(IDATA iDATA) {
        return new IDATA(this.data + iDATA.data);
    }

    public I64 add(I64 i64) {
        return new I64(this).add(i64);
    }

    public IDATA sub(U8 u8) {
        return this.sub(new IDATA(u8));
    }

    public IDATA sub(U16 u16) {
        return this.sub(new IDATA(u16));
    }

    public IDATA sub(U32 u32) {
        return this.sub(new IDATA(u32));
    }

    public UDATA sub(UDATA uDATA) {
        return new UDATA(this).sub(uDATA);
    }

    public IDATA sub(IScalar iScalar) {
        return this.sub(new IDATA(iScalar));
    }

    public IDATA sub(IDATA iDATA) {
        return new IDATA(this.data - iDATA.data);
    }

    public IDATA sub(long l) {
        return new IDATA(this.data - l);
    }

    public I64 sub(I64 i64) {
        return new I64(this).sub(i64);
    }

    @Override
    public int intValue() {
        int n = (int)this.data;
        if (SIZEOF == 8 && this.data != (long)n) {
            throw new InvalidDataTypeException("IDATA is 64 bits wide: conversion to int would lose data");
        }
        return n;
    }

    @Override
    public long longValue() {
        if (SIZEOF == 4) {
            return (int)this.data;
        }
        return this.data;
    }

    public IDATA bitOr(int n) {
        return new IDATA(this.data | (long)n);
    }

    public IDATA bitOr(U8 u8) {
        return this.bitOr(new IDATA(u8));
    }

    public IDATA bitOr(U16 u16) {
        return this.bitOr(new IDATA(u16));
    }

    public IDATA bitOr(U32 u32) {
        return this.bitOr(new IDATA(u32));
    }

    public UDATA bitOr(UDATA uDATA) {
        return new UDATA(this).bitOr(uDATA);
    }

    public IDATA bitOr(IScalar iScalar) {
        return this.bitOr(new IDATA(iScalar));
    }

    public IDATA bitOr(IDATA iDATA) {
        return new IDATA(this.data | iDATA.data);
    }

    public I64 bitOr(I64 i64) {
        return new I64(this).bitOr(i64);
    }

    public IDATA bitXor(int n) {
        return new IDATA(this.data ^ (long)n);
    }

    public IDATA bitXor(long l) {
        return new IDATA(this.data ^ l);
    }

    public IDATA bitXor(Scalar scalar) {
        return this.bitXor(new IDATA(scalar));
    }

    public IDATA bitXor(IDATA iDATA) {
        return new IDATA(this.data ^ iDATA.data);
    }

    public UDATA bitXor(UDATA uDATA) {
        return new UDATA(this).bitXor(uDATA);
    }

    public I64 bitXor(I64 i64) {
        return new I64(this).bitXor(i64);
    }

    public U64 bitXor(U64 u64) {
        return new U64(this).bitXor(u64);
    }

    public IDATA bitAnd(int n) {
        return new IDATA(this.data & (long)n);
    }

    public IDATA bitAnd(U8 u8) {
        return this.bitAnd(new IDATA(u8));
    }

    public IDATA bitAnd(U16 u16) {
        return this.bitAnd(new IDATA(u16));
    }

    public IDATA bitAnd(U32 u32) {
        return this.bitAnd(new IDATA(u32));
    }

    public UDATA bitAnd(UDATA uDATA) {
        return new UDATA(this).bitAnd(uDATA);
    }

    public IDATA bitAnd(IScalar iScalar) {
        return this.bitAnd(new IDATA(iScalar));
    }

    public IDATA bitAnd(IDATA iDATA) {
        return new IDATA(this.data & iDATA.data);
    }

    public I64 bitAnd(I64 i64) {
        return new I64(this).bitAnd(i64);
    }

    public IDATA leftShift(int n) {
        return new IDATA(this.data << n);
    }

    public IDATA rightShift(int n) {
        return new IDATA(this.longValue() >> n);
    }

    public IDATA bitNot() {
        return new IDATA(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public IDATA mult(int n) {
        return new IDATA(this.data * (long)n);
    }

    public IDATA mod(int n) {
        return this.mod((long)n);
    }

    public IDATA mod(long l) {
        return new IDATA(this.longValue() % l);
    }

    public IDATA mod(Scalar scalar) {
        return this.mod(scalar.longValue());
    }

    public IDATA div(long l) {
        return new IDATA(this.longValue() / l);
    }

    public IDATA div(Scalar scalar) {
        return this.div(scalar.longValue());
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public static IDATA cast(AbstractPointer abstractPointer) {
        if (abstractPointer != null) {
            return new IDATA(abstractPointer.getAddress());
        }
        return new IDATA(0L);
    }

    static {
        if (J9BuildFlags.J9VM_ENV_DATA64) {
            SIZEOF = 8;
            MASK = -1L;
            MIN = new IDATA(Long.MIN_VALUE);
            MAX = new IDATA(Long.MAX_VALUE);
        } else {
            SIZEOF = 4;
            MASK = 0xFFFFFFFFL;
            MIN = new IDATA(0x80000000L);
            MAX = new IDATA(Integer.MAX_VALUE);
        }
    }
}

