/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

abstract class ChangeListenerMap<L extends EventListener> {
    private Map<String, L[]> map;

    ChangeListenerMap() {
    }

    protected abstract L[] newArray(int var1);

    protected abstract L newProxy(String var1, L var2);

    public final synchronized void add(String string, L l) {
        EventListener[] eventListenerArray;
        if (this.map == null) {
            this.map = new HashMap<String, L[]>();
        }
        int n = (eventListenerArray = (EventListener[])this.map.get(string)) != null ? eventListenerArray.length : 0;
        EventListener[] eventListenerArray2 = this.newArray(n + 1);
        eventListenerArray2[n] = l;
        if (eventListenerArray != null) {
            System.arraycopy((Object)eventListenerArray, 0, (Object)eventListenerArray2, 0, n);
        }
        this.map.put(string, eventListenerArray2);
    }

    public final synchronized void remove(String string, L l) {
        EventListener[] eventListenerArray;
        if (this.map != null && (eventListenerArray = (EventListener[])this.map.get(string)) != null) {
            for (int i = 0; i < eventListenerArray.length; ++i) {
                if (!l.equals(eventListenerArray[i])) continue;
                int n = eventListenerArray.length - 1;
                if (n > 0) {
                    EventListener[] eventListenerArray2 = this.newArray(n);
                    System.arraycopy((Object)eventListenerArray, 0, (Object)eventListenerArray2, 0, i);
                    System.arraycopy((Object)eventListenerArray, i + 1, (Object)eventListenerArray2, i, n - i);
                    this.map.put(string, eventListenerArray2);
                    break;
                }
                this.map.remove(string);
                if (!this.map.isEmpty()) break;
                this.map = null;
                break;
            }
        }
    }

    public final synchronized L[] get(String string) {
        return this.map != null ? (EventListener[])this.map.get(string) : null;
    }

    public final void set(String string, L[] LArray) {
        if (LArray != null) {
            if (this.map == null) {
                this.map = new HashMap<String, L[]>();
            }
            this.map.put(string, LArray);
        } else if (this.map != null) {
            this.map.remove(string);
            if (this.map.isEmpty()) {
                this.map = null;
            }
        }
    }

    public final synchronized L[] getListeners() {
        if (this.map == null) {
            return this.newArray(0);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        EventListener[] eventListenerArray = (EventListener[])this.map.get(null);
        if (eventListenerArray != null) {
            for (EventListener eventListenerArray2 : eventListenerArray) {
                arrayList.add(eventListenerArray2);
            }
        }
        for (Map.Entry entry : this.map.entrySet()) {
            String string = (String)entry.getKey();
            if (string == null) continue;
            for (EventListener eventListener : (EventListener[])entry.getValue()) {
                arrayList.add(this.newProxy(string, eventListener));
            }
        }
        return arrayList.toArray(this.newArray(arrayList.size()));
    }

    public final L[] getListeners(String string) {
        EventListener[] eventListenerArray;
        if (string != null && (eventListenerArray = this.get(string)) != null) {
            return (EventListener[])eventListenerArray.clone();
        }
        return this.newArray(0);
    }

    public final synchronized boolean hasListeners(String string) {
        if (this.map == null) {
            return false;
        }
        EventListener[] eventListenerArray = (EventListener[])this.map.get(null);
        return eventListenerArray != null || string != null && null != this.map.get(string);
    }

    public final Set<Map.Entry<String, L[]>> getEntries() {
        return this.map != null ? this.map.entrySet() : Collections.emptySet();
    }

    public abstract L extract(L var1);
}

