/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.image.javacore.JCImageThread;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JCJavaThread
implements JavaThread {
    private final ImagePointer fThreadID;
    private final CorruptData fCorruptData;
    private final JCJavaRuntime fRuntime;
    private Vector fStackFrames;
    private Vector fStackSections;
    private ImagePointer fJNIEnv;
    private JCImageThread fImageThread;
    private JavaObject fJavaObject;
    private JavaObject blockingJavaObject;
    private String fName;
    private int fPriority;
    private int fState;

    public JCJavaThread(JCJavaRuntime jCJavaRuntime, ImagePointer imagePointer) throws JCInvalidArgumentsException {
        if (jCJavaRuntime == null) {
            throw new JCInvalidArgumentsException("A Java thread must be associated with a valid Java runtime");
        }
        this.fRuntime = jCJavaRuntime;
        this.fThreadID = this.checkPointer(imagePointer);
        this.fCorruptData = new JCCorruptData(this.fThreadID);
        this.init(null, -1, -1, null);
        this.fRuntime.addJavaThread(this);
    }

    public JCJavaThread(JCJavaRuntime jCJavaRuntime, ImagePointer imagePointer, String string) throws JCInvalidArgumentsException {
        if (jCJavaRuntime == null) {
            throw new JCInvalidArgumentsException("A Java thread must be associated with a valid Java runtime");
        }
        this.fRuntime = jCJavaRuntime;
        this.fThreadID = this.checkPointer(imagePointer);
        this.fCorruptData = new JCCorruptData(this.fThreadID);
        this.init(string, -1, -1, null);
        this.fRuntime.addJavaThread(this);
    }

    private ImagePointer checkPointer(ImagePointer imagePointer) throws JCInvalidArgumentsException {
        if (imagePointer == null) {
            throw new JCInvalidArgumentsException("A java thread must have a non null ID");
        }
        return imagePointer;
    }

    private void init(String string, int n, int n2, JavaObject javaObject) {
        this.fStackFrames = new Vector();
        this.fStackSections = new Vector();
        this.fName = string;
        this.fPriority = n;
        this.fState = n2;
        this.fJavaObject = javaObject;
    }

    @Override
    public ImageThread getImageThread() throws CorruptDataException, DataUnavailable {
        if (this.fImageThread == null) {
            throw new DataUnavailable("No image thread found for this java thread");
        }
        return this.fImageThread;
    }

    @Override
    public ImagePointer getJNIEnv() throws CorruptDataException {
        if (this.fJNIEnv == null) {
            throw new CorruptDataException(this.fCorruptData);
        }
        return this.fJNIEnv;
    }

    @Override
    public String getName() throws CorruptDataException {
        if (this.fName == null) {
            this.fName = "vmthread @" + this.fThreadID.getAddress();
        }
        return this.fName;
    }

    @Override
    public JavaObject getObject() throws CorruptDataException {
        if (this.fJavaObject == null) {
            throw new CorruptDataException(this.fCorruptData);
        }
        return this.fJavaObject;
    }

    @Override
    public int getPriority() throws CorruptDataException {
        if (this.fPriority == -1) {
            throw new CorruptDataException(this.fCorruptData);
        }
        return this.fPriority;
    }

    @Override
    public Iterator getStackFrames() {
        return this.fStackFrames.iterator();
    }

    public void addStackFrame(JavaStackFrame javaStackFrame) {
        if (javaStackFrame != null) {
            this.fStackFrames.add(javaStackFrame);
        }
    }

    @Override
    public Iterator getStackSections() {
        return this.fStackSections.iterator();
    }

    @Override
    public int getState() throws CorruptDataException {
        if (this.fState == -1) {
            throw new CorruptDataException(this.fCorruptData);
        }
        return this.fState;
    }

    public void setImageThread(JCImageThread jCImageThread) {
        this.fImageThread = jCImageThread;
    }

    public JCImageThread internalGetImageThread() {
        return this.fImageThread;
    }

    public void setName(String string) {
        this.fName = string;
    }

    public void setPriority(int n) {
        this.fPriority = n;
    }

    public void setState(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("R")) {
            this.fState = 5;
        } else if (string.equals("CW")) {
            this.fState = 385;
        } else if (string.equals("P")) {
            this.fState = 641;
        } else if (string.equals("B")) {
            this.fState = 1153;
        } else if (string.equals("MW")) {
            this.fState = 1153;
        }
    }

    public ImagePointer getThreadID() {
        return this.fThreadID;
    }

    public ImagePointer setJNIEnv(ImagePointer imagePointer) {
        this.fJNIEnv = imagePointer;
        return this.fJNIEnv;
    }

    public void setObject(JavaObject javaObject) {
        this.fJavaObject = javaObject;
    }

    public void setBlockingObject(JavaObject javaObject) {
        this.blockingJavaObject = javaObject;
    }

    @Override
    public JavaObject getBlockingObject() throws CorruptDataException, DataUnavailable {
        return this.blockingJavaObject;
    }
}

