/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.StructureHeader;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;

public class J9DDRClassLoader
extends SecureClassLoader {
    private final HashMap<String, Class<?>> cache = new HashMap();
    private final boolean generatePointers;
    private final StructureReader reader;
    private final String pointerPackageDotName;
    private final String structurePackageDotName;
    private final String streamPackageDotName;
    private IVMData vmData;

    private static boolean shouldGeneratePointerClasses(StructureReader structureReader) {
        long l;
        if (structureReader.getPackageVersion() < 29L) {
            return false;
        }
        long l2 = structureReader.getConstantValue("DDRAlgorithmVersions", "J9DDR_GENERATE_VERSION", 0L);
        return l2 >= (l = Long.getLong("openj9.dtfj.version-threshold", 1L).longValue());
    }

    private static String withTrailingDot(String string) {
        if (string.endsWith(".")) {
            return string;
        }
        return string + '.';
    }

    public J9DDRClassLoader(StructureReader structureReader, ClassLoader classLoader) {
        super(classLoader);
        this.reader = Objects.requireNonNull(structureReader);
        this.generatePointers = J9DDRClassLoader.shouldGeneratePointerClasses(structureReader);
        this.pointerPackageDotName = J9DDRClassLoader.withTrailingDot(structureReader.getPackageName(StructureReader.PackageNameType.POINTER_PACKAGE_DOT_NAME));
        this.structurePackageDotName = J9DDRClassLoader.withTrailingDot(structureReader.getPackageName(StructureReader.PackageNameType.STRUCTURE_PACKAGE_DOT_NAME));
        this.streamPackageDotName = J9DDRClassLoader.withTrailingDot(structureReader.getPackageName(StructureReader.PackageNameType.PACKAGE_DOT_BASE_NAME));
        this.vmData = null;
    }

    public StructureHeader getHeader() {
        return this.reader.getHeader();
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.cache.get(string);
        if (clazz == null) {
            boolean bl;
            byte[] byArray;
            if (string.startsWith(this.structurePackageDotName)) {
                byArray = this.getStructureClass(string);
                bl = true;
            } else if (this.generatePointers && string.startsWith(this.pointerPackageDotName)) {
                byArray = this.getPointerClass(string);
                bl = true;
            } else {
                byArray = this.loadClassBytes(string);
                bl = false;
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            if (bl) {
                this.cache.put(string, clazz);
            }
        }
        return clazz;
    }

    private byte[] loadClassBytes(String string) throws ClassNotFoundException {
        String string2 = '/' + string.replace('.', '/') + ".class";
        InputStream inputStream = J9DDRClassLoader.class.getResourceAsStream(string2);
        if (inputStream == null) {
            throw new ClassNotFoundException("Couldn't duplicate class " + string + ". Couldn't load resource " + string2 + ", parent classloader " + this.getParent());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("IOException reading resource " + string2 + " for class " + string, iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void definePackage(String string) {
        String string2;
        int n = string.lastIndexOf(46);
        if (n != -1 && this.getPackage(string2 = string.substring(0, n)) == null) {
            this.definePackage(string2, "J9DDR", "0.1", "IBM", "J9DDR", "0.1", "IBM", null);
        }
    }

    public Class<?> loadClassRelativeToStream(String string, boolean bl) throws ClassNotFoundException {
        return this.loadClass(this.streamPackageDotName + string, bl);
    }

    @Override
    public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (string.startsWith(this.streamPackageDotName)) {
            Class<?> clazz = this.findLoadedClass(string);
            if (null == clazz) {
                clazz = this.findClass(string);
                this.definePackage(string);
                if (bl) {
                    this.resolveClass(clazz);
                }
            }
            return clazz;
        }
        if (string.startsWith(this.reader.getBasePackage())) {
            throw new ClassNotFoundException("Cannot load " + string + ". J9DDRClassLoader is configured to load " + this.streamPackageDotName + " DDR classes only.");
        }
        return this.getParent().loadClass(string);
    }

    private byte[] getPointerClass(String string) throws ClassNotFoundException {
        try {
            return this.reader.getPointerClassBytes(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(string);
        }
    }

    private byte[] getStructureClass(String string) throws ClassNotFoundException {
        try {
            return this.reader.getStructureClassBytes(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(string);
        }
    }

    public Collection<StructureReader.StructureDescriptor> getStructures() {
        return Collections.unmodifiableCollection(this.reader.getStructures());
    }

    public IVMData getIVMData(IProcess iProcess, long l) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.vmData == null) {
            Class<?> clazz = this.loadClassRelativeToStream("j9.VMData", false);
            this.vmData = (IVMData)clazz.newInstance();
        }
        return this.vmData;
    }

    public String toString() {
        return "J9DDRClassloader for " + this.streamPackageDotName;
    }

    public StructureReader getReader() {
        return this.reader;
    }
}

