/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.corereaders.ClosingFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.aix.AIXDumpReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.stream.ImageInputStream;

class AIX32DumpReader
extends AIXDumpReader {
    private static final int CONTEXT_OFFSET_IN_THREAD = 200;
    private static final int IAR_OFFSET_IN_CONTEXT = 24;
    private static final int GPR_OFFSET_IN_CONTEXT = 208;
    private static final int GPR_COUNT = 32;
    private static final String VMID = "j9vmap32";

    public AIX32DumpReader(File file, ClosingFileReader closingFileReader) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        this.coreFile = file;
        this.setReader(closingFileReader);
        this.readCore();
    }

    public AIX32DumpReader(ImageInputStream imageInputStream) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        this.coreFile = null;
        this.setReader(imageInputStream);
        this.readCore();
    }

    public String getVMID() {
        return VMID;
    }

    @Override
    public boolean is64Bit() {
        return false;
    }

    @Override
    protected int readLoaderInfoFlags() throws IOException {
        return 0;
    }

    @Override
    protected long userInfoOffset() {
        return 1008L;
    }

    @Override
    protected int pointerSize() {
        return 32;
    }

    @Override
    protected long readAddress() throws IOException {
        return 0xFFFFFFFFL & (long)this.readInt();
    }

    @Override
    protected Map<String, Number> readRegisters(long l) throws IOException {
        TreeMap<String, Number> treeMap = new TreeMap<String, Number>();
        this.seek(l + 200L + 24L);
        treeMap.put("iar", this.readInt());
        treeMap.put("msr", this.readInt());
        treeMap.put("cr", this.readInt());
        treeMap.put("lr", this.readInt());
        treeMap.put("ctr", this.readInt());
        treeMap.put("xer", this.readInt());
        treeMap.put("mq", this.readInt());
        treeMap.put("tid", this.readInt());
        treeMap.put("fpscr", this.readInt());
        this.seek(l + 200L + 208L);
        for (int i = 0; i < 32; ++i) {
            treeMap.put("gpr" + i, this.readInt());
        }
        return treeMap;
    }

    @Override
    protected long threadSize(long l) {
        return 792L;
    }

    @Override
    protected long getStackPointerFrom(Map<String, Number> map) {
        return (long)map.get("gpr1").intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> map) {
        return (long)map.get("iar").intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> map) {
        return (long)map.get("lr").intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected int sizeofTopOfStack() {
        return 144;
    }
}

