/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import java.io.PrintStream;

public class HashCodeCommand
extends Command {
    public HashCodeCommand() {
        this.addCommand("hashcode", "<address>", "prints out the Object.hashcode() for an object");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length != 1) {
            throw new DDRInteractiveCommandException("This debug extension needs a single address argument: !hashcode <object addr>");
        }
        long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
        J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(l);
        try {
            J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
            if (!J9ClassHelper.hasValidEyeCatcher(j9ClassPointer)) {
                throw new DDRInteractiveCommandException("object class is not valid (eyecatcher is not 0x99669966)");
            }
            if (ValueTypeHelper.getValueTypeHelper().isJ9ClassAValueType(j9ClassPointer)) {
                throw new DDRInteractiveCommandException("cannot calculate the hashcode of a value type object");
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException("memory fault de-referencing address argument", corruptDataException);
        }
        try {
            printStream.println(ObjectModel.getObjectHashCode(j9ObjectPointer).getHexValue());
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException("error calculating hashcode", corruptDataException);
        }
    }
}

