/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.structureformat.base;

import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.structureformat.base.ScalarFormatter;
import com.ibm.j9ddr.vm29.types.Scalar;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.logging.Level;

public class U64ScalarFormatter
extends ScalarFormatter {
    public U64ScalarFormatter(int n, Class<? extends AbstractPointer> clazz) {
        super(n, clazz);
    }

    @Override
    protected void formatShortScalar(Scalar scalar, PrintStream printStream) {
        String string = scalar.getHexValue();
        printStream.print(string);
        printStream.print(" (");
        try {
            if (string.toLowerCase().startsWith("0x")) {
                string = string.substring(2);
            }
            BigInteger bigInteger = new BigInteger(string, 16);
            printStream.print(bigInteger.toString());
        }
        catch (Exception exception) {
            printStream.print("Error - see log");
            logger.log(Level.FINE, "Error displaying U64 as decimal", exception);
        }
        printStream.print(")");
    }
}

