/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.helpers;

public class StateToString {
    private static int JVMTI_THREAD_STATE_ALIVE = 1;
    private static int JVMTI_THREAD_STATE_TERMINATED = 2;
    private static int JVMTI_THREAD_STATE_RUNNABLE = 4;
    private static int JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static int JVMTI_THREAD_STATE_WAITING = 128;
    private static int JVMTI_THREAD_STATE_WAITING_INDEFINITELY = 16;
    private static int JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT = 32;
    private static int JVMTI_THREAD_STATE_SLEEPING = 64;
    private static int JVMTI_THREAD_STATE_IN_OBJECT_WAIT = 256;
    private static int JVMTI_THREAD_STATE_PARKED = 512;
    private static int JVMTI_THREAD_STATE_SUSPENDED = 0x100000;
    private static int JVMTI_THREAD_STATE_INTERRUPTED = 0x200000;
    private static int JVMTI_THREAD_STATE_IN_NATIVE = 0x400000;
    private static int JVMTI_THREAD_STATE_VENDOR_1 = 0x10000000;
    private static int JVMTI_THREAD_STATE_VENDOR_2 = 0x20000000;
    private static int JVMTI_THREAD_STATE_VENDOR_3 = 0x40000000;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_MASK = JVMTI_THREAD_STATE_TERMINATED | JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_RUNNABLE | JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER | JVMTI_THREAD_STATE_WAITING | JVMTI_THREAD_STATE_WAITING_INDEFINITELY | JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_NEW = 0;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_TERMINATED = JVMTI_THREAD_STATE_TERMINATED;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_RUNNABLE = JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_RUNNABLE;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_BLOCKED = JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_WAITING = JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_WAITING | JVMTI_THREAD_STATE_WAITING_INDEFINITELY;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_TIMED_WAITING = JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_WAITING | JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT;

    public static String getJVMTIStateString(int n) {
        String string = "";
        if (0 == n) {
            return "<new or terminated> ";
        }
        if ((n & JVMTI_THREAD_STATE_ALIVE) == JVMTI_THREAD_STATE_ALIVE) {
            string = string + "ALIVE ";
        }
        if ((n & JVMTI_THREAD_STATE_TERMINATED) == JVMTI_THREAD_STATE_TERMINATED) {
            string = string + "TERMINATED ";
        }
        if ((n & JVMTI_THREAD_STATE_RUNNABLE) == JVMTI_THREAD_STATE_RUNNABLE) {
            string = string + "RUNNABLE ";
        }
        if ((n & JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER) == JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER) {
            string = string + "BLOCKED_ON_MONITOR_ENTER ";
        }
        if ((n & JVMTI_THREAD_STATE_WAITING) == JVMTI_THREAD_STATE_WAITING) {
            string = string + "WAITING ";
        }
        if ((n & JVMTI_THREAD_STATE_WAITING_INDEFINITELY) == JVMTI_THREAD_STATE_WAITING_INDEFINITELY) {
            string = string + "WAITING_INDEFINITELY ";
        }
        if ((n & JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT) == JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT) {
            string = string + "WAITING_WITH_TIMEOUT ";
        }
        if ((n & JVMTI_THREAD_STATE_SLEEPING) == JVMTI_THREAD_STATE_SLEEPING) {
            string = string + "SLEEPING ";
        }
        if ((n & JVMTI_THREAD_STATE_IN_OBJECT_WAIT) == JVMTI_THREAD_STATE_IN_OBJECT_WAIT) {
            string = string + "IN_OBJECT_WAIT ";
        }
        if ((n & JVMTI_THREAD_STATE_PARKED) == JVMTI_THREAD_STATE_PARKED) {
            string = string + "PARKED ";
        }
        if ((n & JVMTI_THREAD_STATE_SUSPENDED) == JVMTI_THREAD_STATE_SUSPENDED) {
            string = string + "SUSPENDED ";
        }
        if ((n & JVMTI_THREAD_STATE_INTERRUPTED) == JVMTI_THREAD_STATE_INTERRUPTED) {
            string = string + "INTERRUPTED ";
        }
        if ((n & JVMTI_THREAD_STATE_IN_NATIVE) == JVMTI_THREAD_STATE_IN_NATIVE) {
            string = string + "IN_NATIVE ";
        }
        if ((n & JVMTI_THREAD_STATE_VENDOR_1) == JVMTI_THREAD_STATE_VENDOR_1) {
            string = string + "VENDOR_1 ";
        }
        if ((n & JVMTI_THREAD_STATE_VENDOR_2) == JVMTI_THREAD_STATE_VENDOR_2) {
            string = string + "VENDOR_2 ";
        }
        if ((n & JVMTI_THREAD_STATE_VENDOR_3) == JVMTI_THREAD_STATE_VENDOR_3) {
            string = string + "VENDOR_3 ";
        }
        if (string.equals("")) {
            string = "<no matching state> ";
        }
        return string;
    }

    public static String getThreadStateString(int n) {
        String string = "";
        if ((n &= JVMTI_JAVA_LANG_THREAD_STATE_MASK) == JVMTI_JAVA_LANG_THREAD_STATE_NEW) {
            return "NEW ";
        }
        if ((n & JVMTI_JAVA_LANG_THREAD_STATE_TERMINATED) == JVMTI_JAVA_LANG_THREAD_STATE_TERMINATED) {
            string = string + "TERMINATED ";
        }
        if ((n & JVMTI_JAVA_LANG_THREAD_STATE_RUNNABLE) == JVMTI_JAVA_LANG_THREAD_STATE_RUNNABLE) {
            string = string + "RUNNABLE ";
        }
        if ((n & JVMTI_JAVA_LANG_THREAD_STATE_BLOCKED) == JVMTI_JAVA_LANG_THREAD_STATE_BLOCKED) {
            string = string + "BLOCKED ";
        }
        if ((n & JVMTI_JAVA_LANG_THREAD_STATE_WAITING) == JVMTI_JAVA_LANG_THREAD_STATE_WAITING) {
            string = string + "WAITING ";
        }
        if ((n & JVMTI_JAVA_LANG_THREAD_STATE_TIMED_WAITING) == JVMTI_JAVA_LANG_THREAD_STATE_TIMED_WAITING) {
            string = string + "TIMED_WAITING ";
        }
        if (string.equals("")) {
            string = "<no matching state> ";
        }
        return string;
    }
}

