/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class Aix64Dump
extends NewAixDump {
    private static final long THRDENTRY64_V1_SIZE = 424L;
    private static final long THRDENTRY64_V2_SIZE = 512L;
    private static final long THRDCTX64_V1 = 1000L;
    private static final long THRDCTX64_V2 = 1088L;
    private static final int GPR_COUNT = 32;
    private boolean hasVersionBeenDetermined = false;
    private long sizeofThreadCtx64 = 1000L;
    private long sizeofThreadEntry64 = 424L;

    protected Aix64Dump(DumpReader dumpReader) throws IOException {
        super(dumpReader);
        this.readCore();
    }

    @Override
    protected int readLoaderInfoFlags() throws IOException {
        return this.coreReadInt();
    }

    @Override
    protected long userInfoOffset() {
        return 1216L;
    }

    @Override
    protected int pointerSize() {
        return 64;
    }

    @Override
    protected Map readRegisters(long l) throws IOException {
        if (!this.hasVersionBeenDetermined) {
            this.calculateThreadStructureSizes(l);
        }
        this.coreSeek(l + this.sizeofThreadEntry64);
        TreeMap<String, Number> treeMap = new TreeMap<String, Number>();
        for (int i = 0; i < 32; ++i) {
            treeMap.put("gpr" + i, this.coreReadLong());
        }
        treeMap.put("msr", this.coreReadLong());
        treeMap.put("iar", this.coreReadLong());
        treeMap.put("lr", this.coreReadLong());
        treeMap.put("ctr", this.coreReadLong());
        treeMap.put("cr", this.coreReadInt());
        treeMap.put("xer", this.coreReadInt());
        treeMap.put("fpscr", this.coreReadInt());
        return treeMap;
    }

    public void calculateThreadStructureSizes(long l) {
        long l2;
        try {
            this.coreSeek(l + 424L + 8L);
            l2 = this.coreReadLong();
        }
        catch (IOException iOException) {
            return;
        }
        if (null == this.memoryRangeFor(l2)) {
            this.sizeofThreadEntry64 = 512L;
            this.sizeofThreadCtx64 = 1088L;
        } else {
            this.sizeofThreadEntry64 = 424L;
            this.sizeofThreadCtx64 = 1000L;
        }
        this.hasVersionBeenDetermined = true;
    }

    @Override
    protected long threadSize(long l) {
        if (!this.hasVersionBeenDetermined) {
            this.calculateThreadStructureSizes(l);
        }
        return this.sizeofThreadCtx64;
    }

    @Override
    protected long getStackPointerFrom(Map map) {
        return (Long)map.get("gpr1");
    }

    @Override
    protected long getInstructionPointerFrom(Map map) {
        return (Long)map.get("iar");
    }

    @Override
    protected long getLinkRegisterFrom(Map map) {
        return (Long)map.get("lr");
    }

    @Override
    protected int sizeofTopOfStack() {
        return 304;
    }
}

