/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NoSuchFieldException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.logging.Logger;

public class CommandUtils {
    private static final Logger logger = Logger.getLogger("com.ibm.j9ddr.tools.ddrinteractive");
    public static final BigInteger UDATA_MAX_64BIT = new BigInteger("18446744073709551615");
    public static final BigInteger UDATA_MAX_32BIT = new BigInteger("4294967295");
    public static final int RADIX_BINARY = 2;
    public static final int RADIX_DECIMAL = 10;
    public static final int RADIX_HEXADECIMAL = 16;
    public static final String HEX_SUFFIX = "0x";

    public static long parsePointer(String string, boolean bl) throws DDRInteractiveCommandException {
        BigInteger bigInteger = CommandUtils.parseNumber(string);
        if (-1 == bigInteger.signum()) {
            throw new DDRInteractiveCommandException(string + " is not a valid address: Address can not be a negative number");
        }
        if (bl) {
            if (bigInteger.compareTo(UDATA_MAX_64BIT) == 1) {
                throw new DDRInteractiveCommandException(string + " is larger than the max available memory address: 0xFFFFFFFFFFFFFFFF (" + UDATA_MAX_64BIT + ")");
            }
        } else if (bigInteger.compareTo(UDATA_MAX_32BIT) == 1) {
            throw new DDRInteractiveCommandException(string + " is larger than the max available memory address: 0xFFFFFFFF (" + UDATA_MAX_32BIT + ")");
        }
        return bigInteger.longValue();
    }

    public static BigInteger longToBigInteger(long l) {
        BigInteger bigInteger = new BigInteger(Long.toBinaryString(l), 2);
        return bigInteger;
    }

    public static BigInteger parseNumber(String string) throws DDRInteractiveCommandException {
        BigInteger bigInteger = null;
        if (null == string) {
            throw new DDRInteractiveCommandException("Parsed value is null");
        }
        if (0 == (string = string.trim()).length()) {
            throw new DDRInteractiveCommandException("Parsed value is empty. (zero length string)");
        }
        try {
            bigInteger = string.startsWith(HEX_SUFFIX) ? new BigInteger(string.substring(HEX_SUFFIX.length()), 16) : new BigInteger(string, 10);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DDRInteractiveCommandException(string + " is not a valid decimal or hexadecimal number.");
        }
        return bigInteger;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static long followPointerFromStructure(Context context, String string, long l, String string2) throws MemoryFault, DDRInteractiveCommandException {
        if (l == 0L) {
            throw new DDRInteractiveCommandException(new NullPointerException("Null " + string + " found."));
        }
        StructureReader.StructureDescriptor structureDescriptor = StructureCommandUtil.getStructureDescriptor(string, context);
        for (StructureReader.FieldDescriptor fieldDescriptor : structureDescriptor.getFields()) {
            if (!fieldDescriptor.isPresent() || !fieldDescriptor.getDeclaredName().equals(string2)) continue;
            long l2 = fieldDescriptor.getOffset();
            long l3 = l + l2;
            long l4 = context.process.getPointerAt(l3);
            return l4;
        }
        return 0L;
    }

    public static long getOffsetForField(StructureReader.StructureDescriptor structureDescriptor, String string) throws NoSuchFieldException {
        for (StructureReader.FieldDescriptor fieldDescriptor : structureDescriptor.getFields()) {
            if (!fieldDescriptor.isPresent() || !fieldDescriptor.getDeclaredName().equals(string)) continue;
            return fieldDescriptor.getOffset();
        }
        throw new NoSuchFieldException(structureDescriptor.getName() + " does not contain a field named " + string);
    }

    public static String getCStringAtAddress(IProcess iProcess, long l) throws CorruptDataException {
        return CommandUtils.getCStringAtAddress(iProcess, l, Long.MAX_VALUE);
    }

    public static boolean fieldExists(Class<?> clazz, String string) {
        try {
            clazz.getField(string);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (java.lang.NoSuchFieldException noSuchFieldException) {
            return false;
        }
        return true;
    }

    public static String getCStringAtAddress(IProcess iProcess, long l, long l2) throws CorruptDataException {
        int n = 0;
        while (0 != iProcess.getByteAt(l + (long)n) && (long)n < l2) {
            ++n;
        }
        byte[] byArray = new byte[n];
        iProcess.getBytesAt(l, byArray);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static void dbgError(PrintStream printStream, String string) {
        CommandUtils.dbgPrint(printStream, string);
    }

    public static void dbgPrint(PrintStream printStream, String string) {
        printStream.append(string);
    }

    public static void dbgPrint(PrintStream printStream, String string, Object ... objectArray) {
        CommandUtils.dbgPrint(printStream, String.format(string, objectArray));
    }

    public static byte[] longToByteArray(long l, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(l >>> i * 8);
        }
        return byArray;
    }
}

