/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VTableHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9VTableHeader;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class J9VTablesCommand
extends Command {
    public J9VTablesCommand() {
        this.addCommand("j9vtables", "<ramclass>", "dump interpreter and jit vtables for given ram class.");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            long l;
            long l2;
            UDATAPointer uDATAPointer;
            UDATA uDATA;
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            UDATAPointer uDATAPointer2 = UDATAPointer.NULL;
            long l3 = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
            J9ClassPointer j9ClassPointer = J9ClassPointer.cast(l3);
            if (AlgorithmVersion.getVersionOf("ALG_VM_VTABLE_VERSION").getAlgorithmVersion() >= 1) {
                J9VTableHeaderPointer j9VTableHeaderPointer = J9ClassHelper.vTableHeader(j9ClassPointer);
                try {
                    uDATA = j9VTableHeaderPointer.size();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new CorruptDataException(noSuchFieldException);
                }
                uDATAPointer = J9ClassHelper.vTable(j9VTableHeaderPointer);
                l2 = (uDATA.longValue() - 1L) * (long)UDATA.SIZEOF + J9VTableHeader.SIZEOF;
                l = 0L;
            } else {
                uDATAPointer = J9ClassHelper.oldVTable(j9ClassPointer);
                uDATA = uDATAPointer.at(0L).add(1L);
                l2 = uDATA.longValue() * (long)UDATA.SIZEOF;
                l = 2L;
            }
            if (J9BuildFlags.J9VM_INTERP_NATIVE_SUPPORT && !j9JavaVMPointer.jitConfig().isNull()) {
                uDATAPointer2 = UDATAPointer.cast(U8Pointer.cast(j9ClassPointer).sub(l2));
            }
            CommandUtils.dbgPrint(printStream, String.format("VTable for j9class %s  (size=%d - 1 for skipped resolve method)\n", j9ClassPointer.getHexAddress(), uDATA.longValue()));
            CommandUtils.dbgPrint(printStream, String.format("\tInterpreted%s\n", !uDATAPointer2.isNull() ? "\t\tJitted\n" : ""));
            for (long i = l; i < uDATA.longValue(); ++i) {
                String string2 = J9MethodHelper.getName(J9MethodPointer.cast(uDATAPointer.at(i)));
                String string3 = U8Pointer.cast(uDATAPointer.at(i)).getHexAddress();
                if (!uDATAPointer2.isNull()) {
                    String string4 = U8Pointer.cast(uDATAPointer2.at(uDATA.sub(i))).getHexAddress();
                    CommandUtils.dbgPrint(printStream, String.format(" %d\t!j9method %s\t%s\t%s\n", i, string3, string4, string2));
                    continue;
                }
                CommandUtils.dbgPrint(printStream, String.format(" %d\t!j9method %s\t%s\t\n", i, string3, string2));
            }
            return;
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

