/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCReleasingImage;
import com.ibm.dtfj.javacore.parser.j9.JavaCoreResourceReleaser;
import com.ibm.dtfj.utils.ManagedImage;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCImage
implements JCReleasingImage,
ManagedImage {
    private Vector fAddressSpaces = new Vector();
    private String fosType = null;
    private String fosSubType = null;
    private String fcpuType = null;
    private String fcpuSubType = null;
    private int fcpuCount;
    private boolean fcpuCountSet = false;
    private long fBytesMem;
    private boolean fBytesMemSet = false;
    private long fCreationTime;
    private boolean fCreationTimeSet = false;
    private long fCreationTimeNanos;
    private boolean fCreationTimeNanosSet = false;
    private String fHostName = null;
    private List fIPAddresses = new Vector();
    private List _closables = new Vector();
    private URI source = null;
    private ManagedImageSource imageSource = null;

    public void setSource(URI uRI) {
        this.source = uRI;
    }

    @Override
    public URI getSource() {
        try {
            if (this.source == null) {
                return new URI("jc:" + this.fHostName + ":" + this.fCreationTime);
            }
            return this.source;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public void addAddressSpace(ImageAddressSpace imageAddressSpace) {
        if (imageAddressSpace != null) {
            this.fAddressSpaces.add(imageAddressSpace);
        }
    }

    @Override
    public Iterator getAddressSpaces() {
        return this.fAddressSpaces.iterator();
    }

    @Override
    public long getCreationTime() throws DataUnavailable {
        if (!this.fCreationTimeSet) {
            throw new DataUnavailable("Creation time not available");
        }
        return this.fCreationTime;
    }

    @Override
    public String getHostName() throws DataUnavailable, CorruptDataException {
        if (this.fHostName == null) {
            throw new DataUnavailable("Host name not available");
        }
        return this.fHostName;
    }

    @Override
    public Iterator getIPAddresses() throws DataUnavailable {
        return this.fIPAddresses.iterator();
    }

    @Override
    public long getInstalledMemory() throws DataUnavailable {
        if (!this.fBytesMemSet) {
            throw new DataUnavailable("Installed memory not available");
        }
        return this.fBytesMem;
    }

    @Override
    public int getProcessorCount() throws DataUnavailable {
        if (!this.fcpuCountSet) {
            throw new DataUnavailable("Processor count not available");
        }
        return this.fcpuCount;
    }

    @Override
    public String getProcessorSubType() throws DataUnavailable, CorruptDataException {
        if (this.fcpuSubType == null) {
            throw new DataUnavailable("Processor subtype not available");
        }
        return this.fcpuSubType;
    }

    @Override
    public String getProcessorType() throws DataUnavailable, CorruptDataException {
        if (this.fcpuType == null) {
            throw new DataUnavailable("Processor type not available");
        }
        return this.fcpuType;
    }

    @Override
    public String getSystemSubType() throws DataUnavailable, CorruptDataException {
        if (this.fosSubType == null) {
            throw new DataUnavailable("System subtype not available");
        }
        return this.fosSubType;
    }

    @Override
    public String getSystemType() throws DataUnavailable, CorruptDataException {
        if (this.fosType == null) {
            throw new DataUnavailable("System type not available");
        }
        return this.fosType;
    }

    public void setAddressSpaces(Vector vector) {
        this.fAddressSpaces = vector;
    }

    public void setBytesMem(long l) {
        this.fBytesMem = l;
        this.fBytesMemSet = true;
    }

    public void setcpuCount(int n) {
        this.fcpuCount = n;
        this.fcpuCountSet = true;
    }

    public void setcpuSubType(String string) {
        this.fcpuSubType = string;
    }

    public void setcpuType(String string) {
        this.fcpuType = string;
    }

    public void setCreationTime(long l) {
        this.fCreationTime = l;
        this.fCreationTimeSet = true;
    }

    public void setCreationTimeNanos(long l) {
        this.fCreationTimeNanos = l;
        this.fCreationTimeNanosSet = true;
    }

    public void setHostName(String string) {
        this.fHostName = string;
    }

    public void addIPAddresses(InetAddress inetAddress) {
        this.fIPAddresses.add(inetAddress);
    }

    public void setOSSubType(String string) {
        this.fosSubType = string;
    }

    public void setOSType(String string) {
        this.fosType = string;
    }

    @Override
    public void close() {
        for (Object e : this._closables) {
            if (!(e instanceof JavaCoreResourceReleaser)) continue;
            try {
                ((JavaCoreResourceReleaser)e).releaseResources();
            }
            catch (IOException iOException) {
                Logger.getLogger("com.ibm.dtfj.log").log(Level.WARNING, iOException.getMessage(), iOException);
            }
        }
        if (this.imageSource != null && this.imageSource.getExtractedTo() != null) {
            this.imageSource.getExtractedTo().delete();
        }
    }

    @Override
    public void addReleasable(JavaCoreResourceReleaser javaCoreResourceReleaser) {
        this._closables.add(javaCoreResourceReleaser);
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public ManagedImageSource getImageSource() {
        return this.imageSource;
    }

    @Override
    public void setImageSource(ManagedImageSource managedImageSource) {
        this.imageSource = managedImageSource;
    }

    @Override
    public long getCreationTimeNanos() throws DataUnavailable, CorruptDataException {
        if (!this.fCreationTimeNanosSet) {
            throw new DataUnavailable("Creation time not available");
        }
        return this.fCreationTimeNanos;
    }
}

