/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class ComponentColorModel
extends ColorModel {
    private boolean signed;
    private boolean is_sRGB_stdScale;
    private boolean is_LinearRGB_stdScale;
    private boolean is_LinearGray_stdScale;
    private boolean is_ICCGray_stdScale;
    private byte[] tosRGB8LUT;
    private byte[] fromsRGB8LUT8;
    private short[] fromsRGB8LUT16;
    private byte[] fromLinearGray16ToOtherGray8LUT;
    private short[] fromLinearGray16ToOtherGray16LUT;
    private boolean needScaleInit;
    private boolean noUnnorm;
    private boolean nonStdScale;
    private float[] min;
    private float[] diffMinMax;
    private float[] compOffset;
    private float[] compScale;

    public ComponentColorModel(ColorSpace colorSpace, int[] nArray, boolean bl, boolean bl2, int n, int n2) {
        super(ComponentColorModel.bitsHelper(n2, colorSpace, bl), ComponentColorModel.bitsArrayHelper(nArray, n2, colorSpace, bl), colorSpace, bl, bl2, n, n2);
        switch (n2) {
            case 0: 
            case 1: 
            case 3: {
                this.signed = false;
                this.needScaleInit = true;
                break;
            }
            case 2: {
                this.signed = true;
                this.needScaleInit = true;
                break;
            }
            case 4: 
            case 5: {
                this.signed = true;
                this.needScaleInit = false;
                this.noUnnorm = true;
                this.nonStdScale = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("This constructor is not compatible with transferType " + n2);
            }
        }
        this.setupLUTs();
    }

    public ComponentColorModel(ColorSpace colorSpace, boolean bl, boolean bl2, int n, int n2) {
        this(colorSpace, null, bl, bl2, n, n2);
    }

    private static int bitsHelper(int n, ColorSpace colorSpace, boolean bl) {
        int n2 = DataBuffer.getDataTypeSize(n);
        int n3 = colorSpace.getNumComponents();
        if (bl) {
            ++n3;
        }
        return n2 * n3;
    }

    private static int[] bitsArrayHelper(int[] nArray, int n, ColorSpace colorSpace, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                if (nArray == null) break;
                return nArray;
            }
        }
        int n2 = DataBuffer.getDataTypeSize(n);
        int n3 = colorSpace.getNumComponents();
        if (bl) {
            ++n3;
        }
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = n2;
        }
        return nArray2;
    }

    private void setupLUTs() {
        if (this.is_sRGB) {
            this.is_sRGB_stdScale = true;
            this.nonStdScale = false;
        } else if (ColorModel.isLinearRGBspace(this.colorSpace)) {
            this.is_LinearRGB_stdScale = true;
            this.nonStdScale = false;
            if (this.transferType == 0) {
                this.tosRGB8LUT = ColorModel.getLinearRGB8TosRGB8LUT();
                this.fromsRGB8LUT8 = ColorModel.getsRGB8ToLinearRGB8LUT();
            } else {
                this.tosRGB8LUT = ColorModel.getLinearRGB16TosRGB8LUT();
                this.fromsRGB8LUT16 = ColorModel.getsRGB8ToLinearRGB16LUT();
            }
        } else if (this.colorSpaceType == 6 && this.colorSpace instanceof ICC_ColorSpace && this.colorSpace.getMinValue(0) == 0.0f && this.colorSpace.getMaxValue(0) == 1.0f) {
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)this.colorSpace;
            this.is_ICCGray_stdScale = true;
            this.nonStdScale = false;
            this.fromsRGB8LUT16 = ColorModel.getsRGB8ToLinearRGB16LUT();
            if (ColorModel.isLinearGRAYspace(iCC_ColorSpace)) {
                this.is_LinearGray_stdScale = true;
                this.tosRGB8LUT = this.transferType == 0 ? ColorModel.getGray8TosRGB8LUT(iCC_ColorSpace) : ColorModel.getGray16TosRGB8LUT(iCC_ColorSpace);
            } else if (this.transferType == 0) {
                this.tosRGB8LUT = ColorModel.getGray8TosRGB8LUT(iCC_ColorSpace);
                this.fromLinearGray16ToOtherGray8LUT = ColorModel.getLinearGray16ToOtherGray8LUT(iCC_ColorSpace);
            } else {
                this.tosRGB8LUT = ColorModel.getGray16TosRGB8LUT(iCC_ColorSpace);
                this.fromLinearGray16ToOtherGray16LUT = ColorModel.getLinearGray16ToOtherGray16LUT(iCC_ColorSpace);
            }
        } else if (this.needScaleInit) {
            int n;
            this.nonStdScale = false;
            for (n = 0; n < this.numColorComponents; ++n) {
                if (this.colorSpace.getMinValue(n) == 0.0f && this.colorSpace.getMaxValue(n) == 1.0f) continue;
                this.nonStdScale = true;
                break;
            }
            if (this.nonStdScale) {
                this.min = new float[this.numColorComponents];
                this.diffMinMax = new float[this.numColorComponents];
                for (n = 0; n < this.numColorComponents; ++n) {
                    this.min[n] = this.colorSpace.getMinValue(n);
                    this.diffMinMax[n] = this.colorSpace.getMaxValue(n) - this.min[n];
                }
            }
        }
    }

    private void initScale() {
        int n;
        float[] fArray;
        float[] fArray2;
        this.needScaleInit = false;
        this.noUnnorm = this.nonStdScale || this.signed;
        switch (this.transferType) {
            case 0: {
                int n2;
                Object[] objectArray = new byte[this.numComponents];
                for (n2 = 0; n2 < this.numColorComponents; ++n2) {
                    objectArray[n2] = 0;
                }
                if (this.supportsAlpha) {
                    objectArray[this.numColorComponents] = (byte)((1 << this.nBits[this.numColorComponents]) - 1);
                }
                fArray2 = this.getNormalizedComponents(objectArray, null, 0);
                for (n2 = 0; n2 < this.numColorComponents; ++n2) {
                    objectArray[n2] = (byte)((1 << this.nBits[n2]) - 1);
                }
                fArray = this.getNormalizedComponents(objectArray, null, 0);
                break;
            }
            case 1: {
                int n2;
                Object[] objectArray = new short[this.numComponents];
                for (n2 = 0; n2 < this.numColorComponents; ++n2) {
                    objectArray[n2] = 0;
                }
                if (this.supportsAlpha) {
                    objectArray[this.numColorComponents] = (short)((1 << this.nBits[this.numColorComponents]) - 1);
                }
                fArray2 = this.getNormalizedComponents(objectArray, null, 0);
                for (n2 = 0; n2 < this.numColorComponents; ++n2) {
                    objectArray[n2] = (short)((1 << this.nBits[n2]) - 1);
                }
                fArray = this.getNormalizedComponents(objectArray, null, 0);
                break;
            }
            case 3: {
                int n2;
                Object[] objectArray = new int[this.numComponents];
                for (n2 = 0; n2 < this.numColorComponents; ++n2) {
                    objectArray[n2] = 0;
                }
                if (this.supportsAlpha) {
                    objectArray[this.numColorComponents] = (1 << this.nBits[this.numColorComponents]) - 1;
                }
                fArray2 = this.getNormalizedComponents(objectArray, null, 0);
                for (n2 = 0; n2 < this.numColorComponents; ++n2) {
                    objectArray[n2] = (1 << this.nBits[n2]) - 1;
                }
                fArray = this.getNormalizedComponents(objectArray, null, 0);
                break;
            }
            case 2: {
                int n2;
                Object[] objectArray = new short[this.numComponents];
                for (n2 = 0; n2 < this.numColorComponents; ++n2) {
                    objectArray[n2] = 0;
                }
                if (this.supportsAlpha) {
                    objectArray[this.numColorComponents] = Short.MAX_VALUE;
                }
                fArray2 = this.getNormalizedComponents(objectArray, null, 0);
                for (n2 = 0; n2 < this.numColorComponents; ++n2) {
                    objectArray[n2] = Short.MAX_VALUE;
                }
                fArray = this.getNormalizedComponents(objectArray, null, 0);
                break;
            }
            default: {
                fArray = null;
                fArray2 = null;
            }
        }
        this.nonStdScale = false;
        for (n = 0; n < this.numColorComponents; ++n) {
            if (fArray2[n] == 0.0f && fArray[n] == 1.0f) continue;
            this.nonStdScale = true;
            break;
        }
        if (this.nonStdScale) {
            this.noUnnorm = true;
            this.is_sRGB_stdScale = false;
            this.is_LinearRGB_stdScale = false;
            this.is_LinearGray_stdScale = false;
            this.is_ICCGray_stdScale = false;
            this.compOffset = new float[this.numColorComponents];
            this.compScale = new float[this.numColorComponents];
            for (n = 0; n < this.numColorComponents; ++n) {
                this.compOffset[n] = fArray2[n];
                this.compScale[n] = 1.0f / (fArray[n] - fArray2[n]);
            }
        }
    }

    private int getRGBComponent(int n, int n2) {
        Object[] objectArray;
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (this.signed) {
            throw new IllegalArgumentException("Component value is signed");
        }
        if (this.needScaleInit) {
            this.initScale();
        }
        Object[] objectArray2 = null;
        switch (this.transferType) {
            case 0: {
                objectArray2 = objectArray = (Object[])new byte[]{(byte)n};
                break;
            }
            case 1: {
                objectArray2 = objectArray = (Object[])new short[]{(short)n};
                break;
            }
            case 3: {
                objectArray2 = objectArray = (Object[])new int[]{n};
            }
        }
        objectArray = this.getNormalizedComponents(objectArray2, null, 0);
        float[] fArray = this.colorSpace.toRGB((float[])objectArray);
        return (int)(fArray[n2] * 255.0f + 0.5f);
    }

    @Override
    public int getRed(int n) {
        return this.getRGBComponent(n, 0);
    }

    @Override
    public int getGreen(int n) {
        return this.getRGBComponent(n, 1);
    }

    @Override
    public int getBlue(int n) {
        return this.getRGBComponent(n, 2);
    }

    @Override
    public int getAlpha(int n) {
        if (!this.supportsAlpha) {
            return 255;
        }
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (this.signed) {
            throw new IllegalArgumentException("Component value is signed");
        }
        return (int)((float)n / (float)((1 << this.nBits[0]) - 1) * 255.0f + 0.5f);
    }

    @Override
    public int getRGB(int n) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (this.signed) {
            throw new IllegalArgumentException("Component value is signed");
        }
        return this.getAlpha(n) << 24 | this.getRed(n) << 16 | this.getGreen(n) << 8 | this.getBlue(n) << 0;
    }

    private int extractComponent(Object object, int n, int n2) {
        int n3;
        boolean bl = this.supportsAlpha && this.isAlphaPremultiplied;
        int n4 = 0;
        int n5 = (1 << this.nBits[n]) - 1;
        switch (this.transferType) {
            case 2: {
                short[] sArray = (short[])object;
                float f = (1 << n2) - 1;
                if (bl) {
                    short s = sArray[this.numColorComponents];
                    if (s != 0) {
                        return (int)((float)sArray[n] / (float)s * f + 0.5f);
                    }
                    return 0;
                }
                return (int)((float)sArray[n] / 32767.0f * f + 0.5f);
            }
            case 4: {
                float[] fArray = (float[])object;
                float f = (1 << n2) - 1;
                if (bl) {
                    float f2 = fArray[this.numColorComponents];
                    if (f2 != 0.0f) {
                        return (int)(fArray[n] / f2 * f + 0.5f);
                    }
                    return 0;
                }
                return (int)(fArray[n] * f + 0.5f);
            }
            case 5: {
                double[] dArray = (double[])object;
                double d = (1 << n2) - 1;
                if (bl) {
                    double d2 = dArray[this.numColorComponents];
                    if (d2 != 0.0) {
                        return (int)(dArray[n] / d2 * d + 0.5);
                    }
                    return 0;
                }
                return (int)(dArray[n] * d + 0.5);
            }
            case 0: {
                byte[] byArray = (byte[])object;
                n3 = byArray[n] & n5;
                n2 = 8;
                if (!bl) break;
                n4 = byArray[this.numColorComponents] & n5;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n3 = sArray[n] & n5;
                if (!bl) break;
                n4 = sArray[this.numColorComponents] & n5;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n3 = nArray[n];
                if (!bl) break;
                n4 = nArray[this.numColorComponents];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (bl) {
            if (n4 != 0) {
                float f = (1 << n2) - 1;
                float f3 = (float)n3 / (float)n5;
                float f4 = (float)((1 << this.nBits[this.numColorComponents]) - 1) / (float)n4;
                return (int)(f3 * f4 * f + 0.5f);
            }
            return 0;
        }
        if (this.nBits[n] != n2) {
            float f = (1 << n2) - 1;
            float f5 = (float)n3 / (float)n5;
            return (int)(f5 * f + 0.5f);
        }
        return n3;
    }

    private int getRGBComponent(Object object, int n) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.is_sRGB_stdScale) {
            return this.extractComponent(object, n, 8);
        }
        if (this.is_LinearRGB_stdScale) {
            int n2 = this.extractComponent(object, n, 16);
            return this.tosRGB8LUT[n2] & 0xFF;
        }
        if (this.is_ICCGray_stdScale) {
            int n3 = this.extractComponent(object, 0, 16);
            return this.tosRGB8LUT[n3] & 0xFF;
        }
        float[] fArray = this.getNormalizedComponents(object, null, 0);
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[n] * 255.0f + 0.5f);
    }

    @Override
    public int getRed(Object object) {
        return this.getRGBComponent(object, 0);
    }

    @Override
    public int getGreen(Object object) {
        return this.getRGBComponent(object, 1);
    }

    @Override
    public int getBlue(Object object) {
        return this.getRGBComponent(object, 2);
    }

    @Override
    public int getAlpha(Object object) {
        if (!this.supportsAlpha) {
            return 255;
        }
        int n = 0;
        int n2 = this.numColorComponents;
        int n3 = (1 << this.nBits[n2]) - 1;
        switch (this.transferType) {
            case 2: {
                short[] sArray = (short[])object;
                n = (int)((float)sArray[n2] / 32767.0f * 255.0f + 0.5f);
                return n;
            }
            case 4: {
                float[] fArray = (float[])object;
                n = (int)(fArray[n2] * 255.0f + 0.5f);
                return n;
            }
            case 5: {
                double[] dArray = (double[])object;
                n = (int)(dArray[n2] * 255.0 + 0.5);
                return n;
            }
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[n2] & n3;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[n2] & n3;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[n2];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (this.nBits[n2] == 8) {
            return n;
        }
        return (int)((float)n / (float)((1 << this.nBits[n2]) - 1) * 255.0f + 0.5f);
    }

    @Override
    public int getRGB(Object object) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.is_sRGB_stdScale || this.is_LinearRGB_stdScale) {
            return this.getAlpha(object) << 24 | this.getRed(object) << 16 | this.getGreen(object) << 8 | this.getBlue(object);
        }
        if (this.colorSpaceType == 6) {
            int n = this.getRed(object);
            return this.getAlpha(object) << 24 | n << 16 | n << 8 | n;
        }
        float[] fArray = this.getNormalizedComponents(object, null, 0);
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return this.getAlpha(object) << 24 | (int)(fArray2[0] * 255.0f + 0.5f) << 16 | (int)(fArray2[1] * 255.0f + 0.5f) << 8 | (int)(fArray2[2] * 255.0f + 0.5f) << 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getDataElements(int n, Object object) {
        int n2;
        float f;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.signed) {
            switch (this.transferType) {
                case 2: {
                    short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                    if (this.is_sRGB_stdScale || this.is_LinearRGB_stdScale) {
                        float f2 = 128.49803f;
                        if (this.is_LinearRGB_stdScale) {
                            n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                            f2 = 0.49999237f;
                        }
                        if (this.supportsAlpha) {
                            int n6 = n >> 24 & 0xFF;
                            sArray[3] = (short)((float)n6 * 128.49803f + 0.5f);
                            if (this.isAlphaPremultiplied) {
                                f2 = (float)n6 * f2 * 0.003921569f;
                            }
                        }
                        sArray[0] = (short)((float)n3 * f2 + 0.5f);
                        sArray[1] = (short)((float)n4 * f2 + 0.5f);
                        sArray[2] = (short)((float)n5 * f2 + 0.5f);
                        return sArray;
                    } else if (this.is_LinearGray_stdScale) {
                        n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        float f3 = (0.2125f * (float)n3 + 0.7154f * (float)n4 + 0.0721f * (float)n5) / 65535.0f;
                        float f4 = 32767.0f;
                        if (this.supportsAlpha) {
                            int n7 = n >> 24 & 0xFF;
                            sArray[1] = (short)((float)n7 * 128.49803f + 0.5f);
                            if (this.isAlphaPremultiplied) {
                                f4 = (float)n7 * f4 * 0.003921569f;
                            }
                        }
                        sArray[0] = (short)(f3 * f4 + 0.5f);
                        return sArray;
                    } else if (this.is_ICCGray_stdScale) {
                        n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        int n8 = (int)(0.2125f * (float)n3 + 0.7154f * (float)n4 + 0.0721f * (float)n5 + 0.5f);
                        n8 = this.fromLinearGray16ToOtherGray16LUT[n8] & 0xFFFF;
                        float f5 = 0.49999237f;
                        if (this.supportsAlpha) {
                            int n9 = n >> 24 & 0xFF;
                            sArray[1] = (short)((float)n9 * 128.49803f + 0.5f);
                            if (this.isAlphaPremultiplied) {
                                f5 = (float)n9 * f5 * 0.003921569f;
                            }
                        }
                        sArray[0] = (short)((float)n8 * f5 + 0.5f);
                        return sArray;
                    } else {
                        int n10;
                        float f6 = 0.003921569f;
                        float[] fArray = new float[]{(float)n3 * f6, (float)n4 * f6, (float)n5 * f6};
                        fArray = this.colorSpace.fromRGB(fArray);
                        if (this.nonStdScale) {
                            for (n10 = 0; n10 < this.numColorComponents; ++n10) {
                                fArray[n10] = (fArray[n10] - this.compOffset[n10]) * this.compScale[n10];
                                if (fArray[n10] < 0.0f) {
                                    fArray[n10] = 0.0f;
                                }
                                if (!(fArray[n10] > 1.0f)) continue;
                                fArray[n10] = 1.0f;
                            }
                        }
                        f6 = 32767.0f;
                        if (this.supportsAlpha) {
                            int n11 = n >> 24 & 0xFF;
                            sArray[this.numColorComponents] = (short)((float)n11 * 128.49803f + 0.5f);
                            if (this.isAlphaPremultiplied) {
                                f6 *= (float)n11 * 0.003921569f;
                            }
                        }
                        for (n10 = 0; n10 < this.numColorComponents; ++n10) {
                            sArray[n10] = (short)(fArray[n10] * f6 + 0.5f);
                        }
                    }
                    return sArray;
                }
                case 4: {
                    float[] fArray = object == null ? new float[this.numComponents] : (float[])object;
                    if (this.is_sRGB_stdScale || this.is_LinearRGB_stdScale) {
                        float f7;
                        if (this.is_LinearRGB_stdScale) {
                            n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                            f7 = 1.5259022E-5f;
                        } else {
                            f7 = 0.003921569f;
                        }
                        if (this.supportsAlpha) {
                            int n12 = n >> 24 & 0xFF;
                            fArray[3] = (float)n12 * 0.003921569f;
                            if (this.isAlphaPremultiplied) {
                                f7 *= fArray[3];
                            }
                        }
                        fArray[0] = (float)n3 * f7;
                        fArray[1] = (float)n4 * f7;
                        fArray[2] = (float)n5 * f7;
                        return fArray;
                    } else if (this.is_LinearGray_stdScale) {
                        n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        fArray[0] = (0.2125f * (float)n3 + 0.7154f * (float)n4 + 0.0721f * (float)n5) / 65535.0f;
                        if (!this.supportsAlpha) return fArray;
                        int n13 = n >> 24 & 0xFF;
                        fArray[1] = (float)n13 * 0.003921569f;
                        if (!this.isAlphaPremultiplied) return fArray;
                        fArray[0] = fArray[0] * fArray[1];
                        return fArray;
                    } else if (this.is_ICCGray_stdScale) {
                        n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        int n14 = (int)(0.2125f * (float)n3 + 0.7154f * (float)n4 + 0.0721f * (float)n5 + 0.5f);
                        fArray[0] = (float)(this.fromLinearGray16ToOtherGray16LUT[n14] & 0xFFFF) / 65535.0f;
                        if (!this.supportsAlpha) return fArray;
                        int n15 = n >> 24 & 0xFF;
                        fArray[1] = (float)n15 * 0.003921569f;
                        if (!this.isAlphaPremultiplied) return fArray;
                        fArray[0] = fArray[0] * fArray[1];
                        return fArray;
                    } else {
                        int n16;
                        float[] fArray2 = new float[3];
                        float f8 = 0.003921569f;
                        fArray2[0] = (float)n3 * f8;
                        fArray2[1] = (float)n4 * f8;
                        fArray2[2] = (float)n5 * f8;
                        fArray2 = this.colorSpace.fromRGB(fArray2);
                        if (this.supportsAlpha) {
                            int n17 = n >> 24 & 0xFF;
                            fArray[this.numColorComponents] = (float)n17 * f8;
                            if (this.isAlphaPremultiplied) {
                                f8 *= (float)n17;
                                n16 = 0;
                                while (n16 < this.numColorComponents) {
                                    int n18 = n16++;
                                    fArray2[n18] = fArray2[n18] * f8;
                                }
                            }
                        }
                        for (n16 = 0; n16 < this.numColorComponents; ++n16) {
                            fArray[n16] = fArray2[n16];
                        }
                    }
                    return fArray;
                }
                case 5: {
                    double[] dArray = object == null ? new double[this.numComponents] : (double[])object;
                    if (this.is_sRGB_stdScale || this.is_LinearRGB_stdScale) {
                        double d;
                        if (this.is_LinearRGB_stdScale) {
                            n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                            d = 1.5259021896696422E-5;
                        } else {
                            d = 0.00392156862745098;
                        }
                        if (this.supportsAlpha) {
                            int n19 = n >> 24 & 0xFF;
                            dArray[3] = (double)n19 * 0.00392156862745098;
                            if (this.isAlphaPremultiplied) {
                                d *= dArray[3];
                            }
                        }
                        dArray[0] = (double)n3 * d;
                        dArray[1] = (double)n4 * d;
                        dArray[2] = (double)n5 * d;
                        return dArray;
                    } else if (this.is_LinearGray_stdScale) {
                        n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        dArray[0] = (0.2125 * (double)n3 + 0.7154 * (double)n4 + 0.0721 * (double)n5) / 65535.0;
                        if (!this.supportsAlpha) return dArray;
                        int n20 = n >> 24 & 0xFF;
                        dArray[1] = (double)n20 * 0.00392156862745098;
                        if (!this.isAlphaPremultiplied) return dArray;
                        dArray[0] = dArray[0] * dArray[1];
                        return dArray;
                    } else if (this.is_ICCGray_stdScale) {
                        n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        int n21 = (int)(0.2125f * (float)n3 + 0.7154f * (float)n4 + 0.0721f * (float)n5 + 0.5f);
                        dArray[0] = (double)(this.fromLinearGray16ToOtherGray16LUT[n21] & 0xFFFF) / 65535.0;
                        if (!this.supportsAlpha) return dArray;
                        int n22 = n >> 24 & 0xFF;
                        dArray[1] = (double)n22 * 0.00392156862745098;
                        if (!this.isAlphaPremultiplied) return dArray;
                        dArray[0] = dArray[0] * dArray[1];
                        return dArray;
                    } else {
                        int n23;
                        float f9 = 0.003921569f;
                        float[] fArray = new float[]{(float)n3 * f9, (float)n4 * f9, (float)n5 * f9};
                        fArray = this.colorSpace.fromRGB(fArray);
                        if (this.supportsAlpha) {
                            int n24 = n >> 24 & 0xFF;
                            dArray[this.numColorComponents] = (double)n24 * 0.00392156862745098;
                            if (this.isAlphaPremultiplied) {
                                f9 *= (float)n24;
                                n23 = 0;
                                while (n23 < this.numColorComponents) {
                                    int n25 = n23++;
                                    fArray[n25] = fArray[n25] * f9;
                                }
                            }
                        }
                        for (n23 = 0; n23 < this.numColorComponents; ++n23) {
                            dArray[n23] = fArray[n23];
                        }
                    }
                    return dArray;
                }
            }
        }
        int[] nArray = this.transferType == 3 && object != null ? (int[])object : new int[this.numComponents];
        if (this.is_sRGB_stdScale || this.is_LinearRGB_stdScale) {
            int n26;
            if (this.is_LinearRGB_stdScale) {
                if (this.transferType == 0) {
                    n3 = this.fromsRGB8LUT8[n3] & 0xFF;
                    n4 = this.fromsRGB8LUT8[n4] & 0xFF;
                    n5 = this.fromsRGB8LUT8[n5] & 0xFF;
                    n26 = 8;
                    f = 0.003921569f;
                } else {
                    n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                    n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                    n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                    n26 = 16;
                    f = 1.5259022E-5f;
                }
            } else {
                n26 = 8;
                f = 0.003921569f;
            }
            if (this.supportsAlpha) {
                n2 = n >> 24 & 0xFF;
                nArray[3] = this.nBits[3] == 8 ? n2 : (int)((float)n2 * 0.003921569f * (float)((1 << this.nBits[3]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f *= (float)n2 * 0.003921569f;
                    n26 = -1;
                }
            }
            nArray[0] = this.nBits[0] == n26 ? n3 : (int)((float)n3 * f * (float)((1 << this.nBits[0]) - 1) + 0.5f);
            nArray[1] = this.nBits[1] == n26 ? n4 : (int)((float)n4 * f * (float)((1 << this.nBits[1]) - 1) + 0.5f);
            nArray[2] = this.nBits[2] == n26 ? n5 : (int)((float)n5 * f * (float)((1 << this.nBits[2]) - 1) + 0.5f);
        } else if (this.is_LinearGray_stdScale) {
            n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
            float f10 = (0.2125f * (float)n3 + 0.7154f * (float)n4 + 0.0721f * (float)n5) / 65535.0f;
            if (this.supportsAlpha) {
                n2 = n >> 24 & 0xFF;
                nArray[1] = this.nBits[1] == 8 ? n2 : (int)((float)n2 * 0.003921569f * (float)((1 << this.nBits[1]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f10 *= (float)n2 * 0.003921569f;
                }
            }
            nArray[0] = (int)(f10 * (float)((1 << this.nBits[0]) - 1) + 0.5f);
        } else if (this.is_ICCGray_stdScale) {
            n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
            int n27 = (int)(0.2125f * (float)n3 + 0.7154f * (float)n4 + 0.0721f * (float)n5 + 0.5f);
            f = (float)(this.fromLinearGray16ToOtherGray16LUT[n27] & 0xFFFF) / 65535.0f;
            if (this.supportsAlpha) {
                n2 = n >> 24 & 0xFF;
                nArray[1] = this.nBits[1] == 8 ? n2 : (int)((float)n2 * 0.003921569f * (float)((1 << this.nBits[1]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f *= (float)n2 * 0.003921569f;
                }
            }
            nArray[0] = (int)(f * (float)((1 << this.nBits[0]) - 1) + 0.5f);
        } else {
            int n28;
            float[] fArray = new float[3];
            f = 0.003921569f;
            fArray[0] = (float)n3 * f;
            fArray[1] = (float)n4 * f;
            fArray[2] = (float)n5 * f;
            fArray = this.colorSpace.fromRGB(fArray);
            if (this.nonStdScale) {
                for (n28 = 0; n28 < this.numColorComponents; ++n28) {
                    fArray[n28] = (fArray[n28] - this.compOffset[n28]) * this.compScale[n28];
                    if (fArray[n28] < 0.0f) {
                        fArray[n28] = 0.0f;
                    }
                    if (!(fArray[n28] > 1.0f)) continue;
                    fArray[n28] = 1.0f;
                }
            }
            if (this.supportsAlpha) {
                n2 = n >> 24 & 0xFF;
                nArray[this.numColorComponents] = this.nBits[this.numColorComponents] == 8 ? n2 : (int)((float)n2 * f * (float)((1 << this.nBits[this.numColorComponents]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f *= (float)n2;
                    n28 = 0;
                    while (n28 < this.numColorComponents) {
                        int n29 = n28++;
                        fArray[n29] = fArray[n29] * f;
                    }
                }
            }
            for (n28 = 0; n28 < this.numColorComponents; ++n28) {
                nArray[n28] = (int)(fArray[n28] * (float)((1 << this.nBits[n28]) - 1) + 0.5f);
            }
        }
        switch (this.transferType) {
            case 0: {
                byte[] byArray = object == null ? new byte[this.numComponents] : (byte[])object;
                for (int i = 0; i < this.numComponents; ++i) {
                    byArray[i] = (byte)(0xFF & nArray[i]);
                }
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                for (int i = 0; i < this.numComponents; ++i) {
                    sArray[i] = (short)(nArray[i] & 0xFFFF);
                }
                return sArray;
            }
            case 3: {
                if (this.maxBits <= 23) return nArray;
                for (int i = 0; i < this.numComponents; ++i) {
                    if (nArray[i] <= (1 << this.nBits[i]) - 1) continue;
                    nArray[i] = (1 << this.nBits[i]) - 1;
                }
                return nArray;
            }
        }
        throw new IllegalArgumentException("This method has not been implemented for transferType " + this.transferType);
    }

    @Override
    public int[] getComponents(int n, int[] nArray, int n2) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.noUnnorm) {
            throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
        }
        if (nArray == null) {
            nArray = new int[n2 + 1];
        }
        nArray[n2 + 0] = n & (1 << this.nBits[0]) - 1;
        return nArray;
    }

    @Override
    public int[] getComponents(Object object, int[] nArray, int n) {
        int[] nArray2;
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.noUnnorm) {
            throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
        }
        if (object instanceof int[]) {
            nArray2 = (int[])object;
        } else {
            nArray2 = DataBuffer.toIntArray(object);
            if (nArray2 == null) {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (nArray2.length < this.numComponents) {
            throw new IllegalArgumentException("Length of pixel array < number of components in model");
        }
        if (nArray == null) {
            nArray = new int[n + this.numComponents];
        } else if (nArray.length - n < this.numComponents) {
            throw new IllegalArgumentException("Length of components array < number of components in model");
        }
        System.arraycopy((Object)nArray2, 0, (Object)nArray, n, this.numComponents);
        return nArray;
    }

    @Override
    public int[] getUnnormalizedComponents(float[] fArray, int n, int[] nArray, int n2) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.noUnnorm) {
            throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
        }
        return super.getUnnormalizedComponents(fArray, n, nArray, n2);
    }

    @Override
    public float[] getNormalizedComponents(int[] nArray, int n, float[] fArray, int n2) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.noUnnorm) {
            throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
        }
        return super.getNormalizedComponents(nArray, n, fArray, n2);
    }

    @Override
    public int getDataElement(int[] nArray, int n) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.numComponents == 1) {
            if (this.noUnnorm) {
                throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
            }
            return nArray[n + 0];
        }
        throw new IllegalArgumentException("This model returns " + this.numComponents + " elements in the pixel array.");
    }

    @Override
    public Object getDataElements(int[] nArray, int n, Object object) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.noUnnorm) {
            throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
        }
        if (nArray.length - n < this.numComponents) {
            throw new IllegalArgumentException("Component array too small (should be " + this.numComponents);
        }
        switch (this.transferType) {
            case 3: {
                int[] nArray2 = object == null ? new int[this.numComponents] : (int[])object;
                System.arraycopy((Object)nArray, n, (Object)nArray2, 0, this.numComponents);
                return nArray2;
            }
            case 0: {
                byte[] byArray = object == null ? new byte[this.numComponents] : (byte[])object;
                for (int i = 0; i < this.numComponents; ++i) {
                    byArray[i] = (byte)(nArray[n + i] & 0xFF);
                }
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                for (int i = 0; i < this.numComponents; ++i) {
                    sArray[i] = (short)(nArray[n + i] & 0xFFFF);
                }
                return sArray;
            }
        }
        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
    }

    @Override
    public int getDataElement(float[] fArray, int n) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (this.signed) {
            throw new IllegalArgumentException("Component value is signed");
        }
        if (this.needScaleInit) {
            this.initScale();
        }
        Object object = this.getDataElements(fArray, n, null);
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                return byArray[0] & 0xFF;
            }
            case 1: {
                short[] sArray = (short[])object;
                return sArray[0] & 0xFFFF;
            }
            case 3: {
                int[] nArray = (int[])object;
                return nArray[0];
            }
        }
        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
    }

    @Override
    public Object getDataElements(float[] fArray, int n, Object object) {
        int n2;
        float[] fArray2;
        boolean bl;
        boolean bl2 = bl = this.supportsAlpha && this.isAlphaPremultiplied;
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.nonStdScale) {
            fArray2 = new float[this.numComponents];
            int n3 = 0;
            n2 = n;
            while (n3 < this.numColorComponents) {
                fArray2[n3] = (fArray[n2] - this.compOffset[n3]) * this.compScale[n3];
                if (fArray2[n3] < 0.0f) {
                    fArray2[n3] = 0.0f;
                }
                if (fArray2[n3] > 1.0f) {
                    fArray2[n3] = 1.0f;
                }
                ++n3;
                ++n2;
            }
            if (this.supportsAlpha) {
                fArray2[this.numColorComponents] = fArray[this.numColorComponents + n];
            }
            n = 0;
        } else {
            fArray2 = fArray;
        }
        switch (this.transferType) {
            case 0: {
                byte[] byArray = object == null ? new byte[this.numComponents] : (byte[])object;
                if (bl) {
                    float f = fArray2[this.numColorComponents + n];
                    int n4 = 0;
                    int n5 = n;
                    while (n4 < this.numColorComponents) {
                        byArray[n4] = (byte)(fArray2[n5] * f * (float)((1 << this.nBits[n4]) - 1) + 0.5f);
                        ++n4;
                        ++n5;
                    }
                    byArray[this.numColorComponents] = (byte)(f * (float)((1 << this.nBits[this.numColorComponents]) - 1) + 0.5f);
                } else {
                    n2 = 0;
                    int n6 = n;
                    while (n2 < this.numComponents) {
                        byArray[n2] = (byte)(fArray2[n6] * (float)((1 << this.nBits[n2]) - 1) + 0.5f);
                        ++n2;
                        ++n6;
                    }
                }
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                if (bl) {
                    float f = fArray2[this.numColorComponents + n];
                    int n7 = 0;
                    int n8 = n;
                    while (n7 < this.numColorComponents) {
                        sArray[n7] = (short)(fArray2[n8] * f * (float)((1 << this.nBits[n7]) - 1) + 0.5f);
                        ++n7;
                        ++n8;
                    }
                    sArray[this.numColorComponents] = (short)(f * (float)((1 << this.nBits[this.numColorComponents]) - 1) + 0.5f);
                } else {
                    int n9 = 0;
                    int n10 = n;
                    while (n9 < this.numComponents) {
                        sArray[n9] = (short)(fArray2[n10] * (float)((1 << this.nBits[n9]) - 1) + 0.5f);
                        ++n9;
                        ++n10;
                    }
                }
                return sArray;
            }
            case 3: {
                int[] nArray = object == null ? new int[this.numComponents] : (int[])object;
                if (bl) {
                    float f = fArray2[this.numColorComponents + n];
                    int n11 = 0;
                    int n12 = n;
                    while (n11 < this.numColorComponents) {
                        nArray[n11] = (int)(fArray2[n12] * f * (float)((1 << this.nBits[n11]) - 1) + 0.5f);
                        ++n11;
                        ++n12;
                    }
                    nArray[this.numColorComponents] = (int)(f * (float)((1 << this.nBits[this.numColorComponents]) - 1) + 0.5f);
                } else {
                    int n13 = 0;
                    int n14 = n;
                    while (n13 < this.numComponents) {
                        nArray[n13] = (int)(fArray2[n14] * (float)((1 << this.nBits[n13]) - 1) + 0.5f);
                        ++n13;
                        ++n14;
                    }
                }
                return nArray;
            }
            case 2: {
                short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                if (bl) {
                    float f = fArray2[this.numColorComponents + n];
                    int n15 = 0;
                    int n16 = n;
                    while (n15 < this.numColorComponents) {
                        sArray[n15] = (short)(fArray2[n16] * f * 32767.0f + 0.5f);
                        ++n15;
                        ++n16;
                    }
                    sArray[this.numColorComponents] = (short)(f * 32767.0f + 0.5f);
                } else {
                    int n17 = 0;
                    int n18 = n;
                    while (n17 < this.numComponents) {
                        sArray[n17] = (short)(fArray2[n18] * 32767.0f + 0.5f);
                        ++n17;
                        ++n18;
                    }
                }
                return sArray;
            }
            case 4: {
                float[] fArray3 = object == null ? new float[this.numComponents] : (float[])object;
                if (bl) {
                    float f = fArray[this.numColorComponents + n];
                    int n19 = 0;
                    int n20 = n;
                    while (n19 < this.numColorComponents) {
                        fArray3[n19] = fArray[n20] * f;
                        ++n19;
                        ++n20;
                    }
                    fArray3[this.numColorComponents] = f;
                } else {
                    int n21 = 0;
                    int n22 = n;
                    while (n21 < this.numComponents) {
                        fArray3[n21] = fArray[n22];
                        ++n21;
                        ++n22;
                    }
                }
                return fArray3;
            }
            case 5: {
                double[] dArray = object == null ? new double[this.numComponents] : (double[])object;
                if (bl) {
                    double d = fArray[this.numColorComponents + n];
                    int n23 = 0;
                    int n24 = n;
                    while (n23 < this.numColorComponents) {
                        dArray[n23] = (double)fArray[n24] * d;
                        ++n23;
                        ++n24;
                    }
                    dArray[this.numColorComponents] = d;
                } else {
                    int n25 = 0;
                    int n26 = n;
                    while (n25 < this.numComponents) {
                        dArray[n25] = fArray[n26];
                        ++n25;
                        ++n26;
                    }
                }
                return dArray;
            }
        }
        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
    }

    @Override
    public float[] getNormalizedComponents(Object object, float[] fArray, int n) {
        float f;
        if (fArray == null) {
            fArray = new float[this.numComponents + n];
        }
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                int n2 = 0;
                int n3 = n;
                while (n2 < this.numComponents) {
                    fArray[n3] = (float)(byArray[n2] & 0xFF) / (float)((1 << this.nBits[n2]) - 1);
                    ++n2;
                    ++n3;
                }
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                int n4 = 0;
                int n5 = n;
                while (n4 < this.numComponents) {
                    fArray[n5] = (float)(sArray[n4] & 0xFFFF) / (float)((1 << this.nBits[n4]) - 1);
                    ++n4;
                    ++n5;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n6 = 0;
                int n7 = n;
                while (n6 < this.numComponents) {
                    fArray[n7] = (float)nArray[n6] / (float)((1 << this.nBits[n6]) - 1);
                    ++n6;
                    ++n7;
                }
                break;
            }
            case 2: {
                short[] sArray = (short[])object;
                int n8 = 0;
                int n9 = n;
                while (n8 < this.numComponents) {
                    fArray[n9] = (float)sArray[n8] / 32767.0f;
                    ++n8;
                    ++n9;
                }
                break;
            }
            case 4: {
                float[] fArray2 = (float[])object;
                int n10 = 0;
                int n11 = n;
                while (n10 < this.numComponents) {
                    fArray[n11] = fArray2[n10];
                    ++n10;
                    ++n11;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n11 = 0;
                int n12 = n;
                while (n11 < this.numComponents) {
                    fArray[n12] = (float)dArray[n11];
                    ++n11;
                    ++n12;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (this.supportsAlpha && this.isAlphaPremultiplied && (f = fArray[this.numColorComponents + n]) != 0.0f) {
            float f2 = 1.0f / f;
            int n13 = n;
            while (n13 < this.numColorComponents + n) {
                int n14 = n13++;
                fArray[n14] = fArray[n14] * f2;
            }
        }
        if (this.min != null) {
            for (int i = 0; i < this.numColorComponents; ++i) {
                fArray[i + n] = this.min[i] + this.diffMinMax[i] * fArray[i + n];
            }
        }
        return fArray;
    }

    @Override
    public ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        block79: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            block78: {
                if (!this.supportsAlpha || this.isAlphaPremultiplied == bl) {
                    return this;
                }
                n5 = writableRaster.getWidth();
                n4 = writableRaster.getHeight();
                n3 = writableRaster.getNumBands() - 1;
                n2 = writableRaster.getMinX();
                n = writableRaster.getMinY();
                if (!bl) break block78;
                switch (this.transferType) {
                    case 0: {
                        byte[] byArray = null;
                        byte[] byArray2 = null;
                        float f = 1.0f / (float)((1 << this.nBits[n3]) - 1);
                        int n6 = 0;
                        while (n6 < n4) {
                            int n7 = n2;
                            int n8 = 0;
                            while (n8 < n5) {
                                float f2 = (float)((byArray = (byte[])writableRaster.getDataElements(n7, n, byArray))[n3] & 0xFF) * f;
                                if (f2 != 0.0f) {
                                    for (int i = 0; i < n3; ++i) {
                                        byArray[i] = (byte)((float)(byArray[i] & 0xFF) * f2 + 0.5f);
                                    }
                                    writableRaster.setDataElements(n7, n, byArray);
                                } else {
                                    if (byArray2 == null) {
                                        byArray2 = new byte[this.numComponents];
                                        Arrays.fill(byArray2, (byte)0);
                                    }
                                    writableRaster.setDataElements(n7, n, byArray2);
                                }
                                ++n8;
                                ++n7;
                            }
                            ++n6;
                            ++n;
                        }
                        break block79;
                    }
                    case 1: {
                        short[] sArray = null;
                        short[] sArray2 = null;
                        float f = 1.0f / (float)((1 << this.nBits[n3]) - 1);
                        int n9 = 0;
                        while (n9 < n4) {
                            int n10 = n2;
                            int n11 = 0;
                            while (n11 < n5) {
                                float f3 = (float)((sArray = (short[])writableRaster.getDataElements(n10, n, sArray))[n3] & 0xFFFF) * f;
                                if (f3 != 0.0f) {
                                    for (int i = 0; i < n3; ++i) {
                                        sArray[i] = (short)((float)(sArray[i] & 0xFFFF) * f3 + 0.5f);
                                    }
                                    writableRaster.setDataElements(n10, n, sArray);
                                } else {
                                    if (sArray2 == null) {
                                        sArray2 = new short[this.numComponents];
                                        Arrays.fill(sArray2, (short)0);
                                    }
                                    writableRaster.setDataElements(n10, n, sArray2);
                                }
                                ++n11;
                                ++n10;
                            }
                            ++n9;
                            ++n;
                        }
                        break block79;
                    }
                    case 3: {
                        int[] nArray = null;
                        int[] nArray2 = null;
                        float f = 1.0f / (float)((1 << this.nBits[n3]) - 1);
                        int n12 = 0;
                        while (n12 < n4) {
                            int n13 = n2;
                            int n14 = 0;
                            while (n14 < n5) {
                                float f4 = (float)(nArray = (int[])writableRaster.getDataElements(n13, n, nArray))[n3] * f;
                                if (f4 != 0.0f) {
                                    for (int i = 0; i < n3; ++i) {
                                        nArray[i] = (int)((float)nArray[i] * f4 + 0.5f);
                                    }
                                    writableRaster.setDataElements(n13, n, nArray);
                                } else {
                                    if (nArray2 == null) {
                                        nArray2 = new int[this.numComponents];
                                        Arrays.fill(nArray2, 0);
                                    }
                                    writableRaster.setDataElements(n13, n, nArray2);
                                }
                                ++n14;
                                ++n13;
                            }
                            ++n12;
                            ++n;
                        }
                        break block79;
                    }
                    case 2: {
                        short[] sArray = null;
                        short[] sArray3 = null;
                        float f = 3.051851E-5f;
                        int n15 = 0;
                        while (n15 < n4) {
                            int n16 = n2;
                            int n17 = 0;
                            while (n17 < n5) {
                                float f5 = (float)(sArray = (short[])writableRaster.getDataElements(n16, n, sArray))[n3] * f;
                                if (f5 != 0.0f) {
                                    for (int i = 0; i < n3; ++i) {
                                        sArray[i] = (short)((float)sArray[i] * f5 + 0.5f);
                                    }
                                    writableRaster.setDataElements(n16, n, sArray);
                                } else {
                                    if (sArray3 == null) {
                                        sArray3 = new short[this.numComponents];
                                        Arrays.fill(sArray3, (short)0);
                                    }
                                    writableRaster.setDataElements(n16, n, sArray3);
                                }
                                ++n17;
                                ++n16;
                            }
                            ++n15;
                            ++n;
                        }
                        break block79;
                    }
                    case 4: {
                        float[] fArray = null;
                        float[] fArray2 = null;
                        int n18 = 0;
                        while (n18 < n4) {
                            int n19 = n2;
                            int n20 = 0;
                            while (n20 < n5) {
                                float f = (fArray = (float[])writableRaster.getDataElements(n19, n, fArray))[n3];
                                if (f != 0.0f) {
                                    int n21 = 0;
                                    while (n21 < n3) {
                                        int n22 = n21++;
                                        fArray[n22] = fArray[n22] * f;
                                    }
                                    writableRaster.setDataElements(n19, n, fArray);
                                } else {
                                    if (fArray2 == null) {
                                        fArray2 = new float[this.numComponents];
                                        Arrays.fill(fArray2, 0.0f);
                                    }
                                    writableRaster.setDataElements(n19, n, fArray2);
                                }
                                ++n20;
                                ++n19;
                            }
                            ++n18;
                            ++n;
                        }
                        break block79;
                    }
                    case 5: {
                        double[] dArray = null;
                        double[] dArray2 = null;
                        int n23 = 0;
                        while (n23 < n4) {
                            int n24 = n2;
                            int n25 = 0;
                            while (n25 < n5) {
                                double d = (dArray = (double[])writableRaster.getDataElements(n24, n, dArray))[n3];
                                if (d != 0.0) {
                                    int n26 = 0;
                                    while (n26 < n3) {
                                        int n27 = n26++;
                                        dArray[n27] = dArray[n27] * d;
                                    }
                                    writableRaster.setDataElements(n24, n, dArray);
                                } else {
                                    if (dArray2 == null) {
                                        dArray2 = new double[this.numComponents];
                                        Arrays.fill(dArray2, 0.0);
                                    }
                                    writableRaster.setDataElements(n24, n, dArray2);
                                }
                                ++n25;
                                ++n24;
                            }
                            ++n23;
                            ++n;
                        }
                        break block79;
                    }
                    default: {
                        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                    }
                }
            }
            switch (this.transferType) {
                case 0: {
                    byte[] byArray = null;
                    float f = 1.0f / (float)((1 << this.nBits[n3]) - 1);
                    int n28 = 0;
                    while (n28 < n4) {
                        int n29 = n2;
                        int n30 = 0;
                        while (n30 < n5) {
                            float f6 = (float)((byArray = (byte[])writableRaster.getDataElements(n29, n, byArray))[n3] & 0xFF) * f;
                            if (f6 != 0.0f) {
                                float f7 = 1.0f / f6;
                                for (int i = 0; i < n3; ++i) {
                                    byArray[i] = (byte)((float)(byArray[i] & 0xFF) * f7 + 0.5f);
                                }
                                writableRaster.setDataElements(n29, n, byArray);
                            }
                            ++n30;
                            ++n29;
                        }
                        ++n28;
                        ++n;
                    }
                    break;
                }
                case 1: {
                    short[] sArray = null;
                    float f = 1.0f / (float)((1 << this.nBits[n3]) - 1);
                    int n31 = 0;
                    while (n31 < n4) {
                        int n32 = n2;
                        int n33 = 0;
                        while (n33 < n5) {
                            float f8 = (float)((sArray = (short[])writableRaster.getDataElements(n32, n, sArray))[n3] & 0xFFFF) * f;
                            if (f8 != 0.0f) {
                                float f9 = 1.0f / f8;
                                for (int i = 0; i < n3; ++i) {
                                    sArray[i] = (short)((float)(sArray[i] & 0xFFFF) * f9 + 0.5f);
                                }
                                writableRaster.setDataElements(n32, n, sArray);
                            }
                            ++n33;
                            ++n32;
                        }
                        ++n31;
                        ++n;
                    }
                    break;
                }
                case 3: {
                    int[] nArray = null;
                    float f = 1.0f / (float)((1 << this.nBits[n3]) - 1);
                    int n34 = 0;
                    while (n34 < n4) {
                        int n35 = n2;
                        int n36 = 0;
                        while (n36 < n5) {
                            float f10 = (float)(nArray = (int[])writableRaster.getDataElements(n35, n, nArray))[n3] * f;
                            if (f10 != 0.0f) {
                                float f11 = 1.0f / f10;
                                for (int i = 0; i < n3; ++i) {
                                    nArray[i] = (int)((float)nArray[i] * f11 + 0.5f);
                                }
                                writableRaster.setDataElements(n35, n, nArray);
                            }
                            ++n36;
                            ++n35;
                        }
                        ++n34;
                        ++n;
                    }
                    break;
                }
                case 2: {
                    short[] sArray = null;
                    float f = 3.051851E-5f;
                    int n37 = 0;
                    while (n37 < n4) {
                        int n38 = n2;
                        int n39 = 0;
                        while (n39 < n5) {
                            float f12 = (float)(sArray = (short[])writableRaster.getDataElements(n38, n, sArray))[n3] * f;
                            if (f12 != 0.0f) {
                                float f13 = 1.0f / f12;
                                for (int i = 0; i < n3; ++i) {
                                    sArray[i] = (short)((float)sArray[i] * f13 + 0.5f);
                                }
                                writableRaster.setDataElements(n38, n, sArray);
                            }
                            ++n39;
                            ++n38;
                        }
                        ++n37;
                        ++n;
                    }
                    break;
                }
                case 4: {
                    float[] fArray = null;
                    int n40 = 0;
                    while (n40 < n4) {
                        int n41 = n2;
                        int n42 = 0;
                        while (n42 < n5) {
                            float f = (fArray = (float[])writableRaster.getDataElements(n41, n, fArray))[n3];
                            if (f != 0.0f) {
                                float f14 = 1.0f / f;
                                int n43 = 0;
                                while (n43 < n3) {
                                    int n44 = n43++;
                                    fArray[n44] = fArray[n44] * f14;
                                }
                                writableRaster.setDataElements(n41, n, fArray);
                            }
                            ++n42;
                            ++n41;
                        }
                        ++n40;
                        ++n;
                    }
                    break;
                }
                case 5: {
                    double[] dArray = null;
                    int n45 = 0;
                    while (n45 < n4) {
                        int n46 = n2;
                        int n47 = 0;
                        while (n47 < n5) {
                            double d = (dArray = (double[])writableRaster.getDataElements(n46, n, dArray))[n3];
                            if (d != 0.0) {
                                double d2 = 1.0 / d;
                                int n48 = 0;
                                while (n48 < n3) {
                                    int n49 = n48++;
                                    dArray[n49] = dArray[n49] * d2;
                                }
                                writableRaster.setDataElements(n46, n, dArray);
                            }
                            ++n47;
                            ++n46;
                        }
                        ++n45;
                        ++n;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
        }
        if (!this.signed) {
            return new ComponentColorModel(this.colorSpace, this.nBits, this.supportsAlpha, bl, this.transparency, this.transferType);
        }
        return new ComponentColorModel(this.colorSpace, this.supportsAlpha, bl, this.transparency, this.transferType);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel instanceof ComponentSampleModel) {
            if (sampleModel.getNumBands() != this.getNumComponents()) {
                return false;
            }
            for (int i = 0; i < this.nBits.length; ++i) {
                if (sampleModel.getSampleSize(i) >= this.nBits[i]) continue;
                return false;
            }
            return raster.getTransferType() == this.transferType;
        }
        return false;
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        int n3 = n * n2 * this.numComponents;
        WritableRaster writableRaster = null;
        switch (this.transferType) {
            case 0: 
            case 1: {
                writableRaster = Raster.createInterleavedRaster(this.transferType, n, n2, this.numComponents, null);
                break;
            }
            default: {
                SampleModel sampleModel = this.createCompatibleSampleModel(n, n2);
                DataBuffer dataBuffer = sampleModel.createDataBuffer();
                writableRaster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
            }
        }
        return writableRaster;
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray = new int[this.numComponents];
        for (int i = 0; i < this.numComponents; ++i) {
            nArray[i] = i;
        }
        switch (this.transferType) {
            case 0: 
            case 1: {
                return new PixelInterleavedSampleModel(this.transferType, n, n2, this.numComponents, n * this.numComponents, nArray);
            }
        }
        return new ComponentSampleModel(this.transferType, n, n2, this.numComponents, n * this.numComponents, nArray);
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        if (this.numComponents != sampleModel.getNumBands()) {
            return false;
        }
        return sampleModel.getTransferType() == this.transferType;
    }

    @Override
    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        if (!this.hasAlpha()) {
            return null;
        }
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int[] nArray = new int[]{writableRaster.getNumBands() - 1};
        return writableRaster.createWritableChild(n, n2, writableRaster.getWidth(), writableRaster.getHeight(), n, n2, nArray);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return object.getClass() == this.getClass();
    }
}

