/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.util.Msg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import openj9.internal.tools.attach.target.IPC;

public final class Reply {
    private String key;
    private Integer portNumber;
    private final File replyFile;
    static final long ROOT_UID = 0L;
    static final int REPLY_PERMISSIONS = 384;
    static final String REPLY_FILENAME = "replyInfo";
    final long targetUid;

    public Reply(Integer n, String string, String string2, long l) {
        this.portNumber = n;
        this.key = string;
        this.targetUid = l;
        this.replyFile = new File(string2, REPLY_FILENAME);
    }

    Reply(String string) {
        this.targetUid = 0L;
        this.replyFile = new File(string, REPLY_FILENAME);
    }

    public void writeReply() throws IOException {
        String string = this.replyFile.getAbsolutePath();
        IPC.logMessage("writing reply file port=", this.portNumber, " file path=", string);
        IPC.createNewFileWithPermissions(this.replyFile, 384);
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.replyFile, "rw");){
            randomAccessFile.writeBytes(this.key);
            randomAccessFile.writeByte(10);
            randomAccessFile.writeBytes(this.portNumber.toString());
            randomAccessFile.writeByte(10);
            randomAccessFile.close();
            long l = IPC.getUid();
            if (0L == l && 0L != this.targetUid) {
                IPC.chownFileToTargetUid(string, this.targetUid);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(Msg.getString("K0552", string), fileNotFoundException);
        }
    }

    static Reply readReply(String string) throws IOException {
        Reply reply = new Reply(string);
        String string2 = reply.replyFile.getAbsolutePath();
        if (reply.fileDoesNotExist()) {
            return null;
        }
        IPC.checkOwnerAccessOnly(string2);
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(reply.replyFile));){
            reply.key = bufferedReader.readLine();
            String string3 = bufferedReader.readLine();
            bufferedReader.close();
            try {
                reply.portNumber = Integer.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                reply.portNumber = -1;
                throw new IOException(numberFormatException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(Msg.getString("K0548", string2), fileNotFoundException);
        }
        return reply;
    }

    private boolean fileDoesNotExist() {
        return !this.replyFile.exists();
    }

    synchronized int getPortNumber() {
        return this.portNumber;
    }

    synchronized String getKey() {
        return this.key;
    }

    public void deleteReply() {
        if (null != this.replyFile) {
            if (!this.replyFile.delete()) {
                IPC.logMessage("eraseReply could not delete ", this.replyFile.getName());
            } else {
                IPC.logMessage("eraseReply deleted ", this.replyFile.getName());
            }
        }
    }
}

