/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9PortLibraryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMRMemCategoryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMRMemCategorySetPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMRPortLibraryGlobalDataPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9PortLibrary;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OMRMemCategoryHelper {
    public static OMRMemCategoryPointer getUnusedAllocate32HeapRegionsMemoryCategory(OMRPortLibraryGlobalDataPointer oMRPortLibraryGlobalDataPointer) throws CorruptDataException {
        ReflectiveOperationException reflectiveOperationException;
        try {
            Class<OMRPortLibraryGlobalDataPointer> clazz = OMRPortLibraryGlobalDataPointer.class;
            Method method = clazz.getDeclaredMethod("unusedAllocate32HeapRegionsMemoryCategory", new Class[0]);
            return (OMRMemCategoryPointer)method.invoke((Object)oMRPortLibraryGlobalDataPointer, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            reflectiveOperationException = noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof CorruptDataException) {
                throw (CorruptDataException)throwable;
            }
            reflectiveOperationException = invocationTargetException;
        }
        CorruptDataException corruptDataException = new CorruptDataException(reflectiveOperationException.toString(), reflectiveOperationException);
        EventManager.raiseCorruptDataEvent("Error accessing unusedAllocate32HeapRegionsMemoryCategory", corruptDataException, true);
        return null;
    }

    public static OMRMemCategoryPointer getMemoryCategory(UDATA uDATA) throws CorruptDataException {
        J9PortLibraryPointer j9PortLibraryPointer = J9RASHelper.getVM(DataType.getJ9RASPointer()).portLibrary();
        OMRPortLibraryGlobalDataPointer oMRPortLibraryGlobalDataPointer = j9PortLibraryPointer.omrPortLibrary().portGlobals();
        if (uDATA.eq(J9PortLibrary.OMRMEM_CATEGORY_PORT_LIBRARY)) {
            return oMRPortLibraryGlobalDataPointer.portLibraryMemoryCategory();
        }
        if (J9BuildFlags.J9VM_ENV_DATA64 && uDATA.eq(J9PortLibrary.OMRMEM_CATEGORY_PORT_LIBRARY_UNUSED_ALLOCATE32_REGIONS)) {
            return OMRMemCategoryHelper.getUnusedAllocate32HeapRegionsMemoryCategory(oMRPortLibraryGlobalDataPointer);
        }
        OMRMemCategorySetPointer oMRMemCategorySetPointer = OMRMemCategorySetPointer.NULL;
        long l = 0L;
        if (uDATA.lt(new U32(Integer.MAX_VALUE))) {
            oMRMemCategorySetPointer = oMRPortLibraryGlobalDataPointer.control().language_memory_categories();
            l = uDATA.longValue();
        } else {
            oMRMemCategorySetPointer = oMRPortLibraryGlobalDataPointer.control().omr_memory_categories();
            l = Integer.MAX_VALUE & uDATA.longValue();
        }
        if (oMRMemCategorySetPointer.notNull()) {
            if (oMRMemCategorySetPointer.numberOfCategories().gt(l) && oMRMemCategorySetPointer.categories().at(l).notNull()) {
                return OMRMemCategoryPointer.cast(oMRMemCategorySetPointer.categories().at(l));
            }
            return oMRPortLibraryGlobalDataPointer.unknownMemoryCategory();
        }
        return oMRPortLibraryGlobalDataPointer.unknownMemoryCategory();
    }

    public static void visitMemoryCategoryChildren(OMRMemCategoryPointer oMRMemCategoryPointer, IOMRMemCategoryVisitor iOMRMemCategoryVisitor) throws CorruptDataException {
        iOMRMemCategoryVisitor.visit(oMRMemCategoryPointer);
        int n = oMRMemCategoryPointer.numberOfChildren().intValue();
        for (int i = 0; i < n; ++i) {
            UDATA uDATA = oMRMemCategoryPointer.children().at(i);
            OMRMemCategoryPointer oMRMemCategoryPointer2 = OMRMemCategoryHelper.getMemoryCategory(uDATA);
            if (!oMRMemCategoryPointer2.categoryCode().eq(uDATA)) {
                UDATA uDATA2 = null;
                try {
                    uDATA2 = oMRMemCategoryPointer.categoryCode();
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
                if (uDATA2 == null) {
                    throw new CorruptDataException("Bad memory category child relationship. Memory Category at " + oMRMemCategoryPointer.getHexAddress() + " references unknown memory category code " + uDATA);
                }
                throw new CorruptDataException("Bad memory category child relationship. Memory Category at " + oMRMemCategoryPointer.getHexAddress() + " code " + uDATA2 + " references unknown memory category code " + uDATA);
            }
            OMRMemCategoryHelper.visitMemoryCategoryChildren(oMRMemCategoryPointer2, iOMRMemCategoryVisitor);
        }
    }

    public static interface IOMRMemCategoryVisitor {
        public void visit(OMRMemCategoryPointer var1) throws CorruptDataException;
    }
}

