/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf.unwind;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.elf.LinuxProcessAddressSpace;
import com.ibm.j9ddr.corereaders.elf.ProgramHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.unwind.CIE;
import com.ibm.j9ddr.corereaders.elf.unwind.FDE;
import com.ibm.j9ddr.corereaders.elf.unwind.UnwindTable;
import com.ibm.j9ddr.corereaders.memory.IMemoryImageInputStream;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class Unwind {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    LinuxProcessAddressSpace process;
    private List<FDE> frameDescriptionEntries = new LinkedList<FDE>();

    public Unwind(LinuxProcessAddressSpace linuxProcessAddressSpace) {
        this.process = linuxProcessAddressSpace;
    }

    public void addCallFrameInformation(long l, ProgramHeaderEntry programHeaderEntry, String string) throws CorruptDataException, IOException {
        if (!programHeaderEntry.isEhFrame()) {
            throw new CorruptDataException("Unexpected program header type, expected GNU_EH_FRAME");
        }
        long l2 = this.getCFIAddress(l, programHeaderEntry, string);
        if (l2 != 0L) {
            this.parseCallFrameInformation(l2, string);
        }
    }

    private void parseCallFrameInformation(long l, String string) throws CorruptDataException, IOException {
        boolean bl = false;
        HashMap<Long, CIE> hashMap = new HashMap<Long, CIE>();
        if (bl) {
            System.err.printf("Dumping data for %s!\n", string);
        }
        try {
            if (bl) {
                System.err.printf("Reading cfi info from 0x%x\n", l);
            }
            IMemoryImageInputStream iMemoryImageInputStream = new IMemoryImageInputStream(this.process, l);
            while (true) {
                CIE cIE;
                if (bl) {
                    System.err.printf("Reading length at position %d\n", iMemoryImageInputStream.getStreamPosition());
                }
                long l2 = iMemoryImageInputStream.getStreamPosition();
                long l3 = (long)iMemoryImageInputStream.readInt() & 0xFFFFFFFFL;
                long l4 = iMemoryImageInputStream.getStreamPosition();
                if (bl) {
                    System.err.printf("Got length: %x (%1$d)\n", l3);
                }
                if (l3 == 0L) {
                    if (bl) {
                        System.err.printf("Length = 0, end of cfi.\n", new Object[0]);
                    }
                    break;
                }
                if (l3 == -1L) {
                    l3 = iMemoryImageInputStream.readLong();
                    if (bl) {
                        System.err.printf("Got extended length: %x\n", l3);
                    }
                    throw new CorruptDataException("CFI record contained unhandled extended length field.");
                }
                if (bl) {
                    System.err.printf("Reading ciePointer at position %d\n", iMemoryImageInputStream.getStreamPosition());
                }
                int n = iMemoryImageInputStream.readInt();
                if (bl) {
                    System.err.printf("Got ciePointer: %x\n", n);
                }
                if (n == 0) {
                    if (bl) {
                        System.err.printf("CIE!\n", new Object[0]);
                    }
                    cIE = new CIE(this, iMemoryImageInputStream, l4, l3);
                    hashMap.put(l2, cIE);
                    if (!bl) continue;
                    cIE.dump(System.err);
                    System.err.printf("--- End CIE\n", new Object[0]);
                    continue;
                }
                if (bl) {
                    System.err.printf("FDE!\n", new Object[0]);
                }
                if ((cIE = (CIE)hashMap.get(l4 - (long)n)) == null) {
                    throw new IOException(String.format("Missing CIE record @0x%x (0x%x - 0x%x) for FDE@0x%x", (long)n - l4, n, l4, l4));
                }
                FDE fDE = new FDE(this, iMemoryImageInputStream, cIE, l4, l3);
                this.frameDescriptionEntries.add(fDE);
                if (!bl) continue;
                fDE.dump(System.err);
                System.err.printf("--- End FDE\n", new Object[0]);
            }
        }
        catch (MemoryFault memoryFault) {
            logger.log(Level.FINER, "MemoryFault in parseCallFrameInformation for " + string, memoryFault);
        }
        catch (IOException iOException) {
            logger.log(Level.FINER, "IOException in parseCallFrameInformation for " + string, iOException);
        }
        catch (CorruptDataException corruptDataException) {
            logger.log(Level.FINER, "CorruptDataException in parseCallFrameInformation for " + string, corruptDataException);
        }
    }

    private long getCFIAddress(long l, ProgramHeaderEntry programHeaderEntry, String string) throws IOException, MemoryFault {
        IMemoryImageInputStream iMemoryImageInputStream = new IMemoryImageInputStream(this.process, l + programHeaderEntry.fileOffset);
        long l2 = iMemoryImageInputStream.getStreamPosition();
        byte by = iMemoryImageInputStream.readByte();
        if (by != 1) {
            iMemoryImageInputStream.close();
            throw new IOException(String.format("Invalid version number for .eh_frame_hdr @ 0x%x in library %s, was %d not 1", l, string, by));
        }
        byte by2 = iMemoryImageInputStream.readByte();
        byte by3 = iMemoryImageInputStream.readByte();
        byte by4 = iMemoryImageInputStream.readByte();
        long l3 = iMemoryImageInputStream.getStreamPosition() - l2;
        long l4 = this.readEncodedPC(iMemoryImageInputStream, by2);
        long l5 = 0L;
        long l6 = 0L;
        if ((by2 & 0x10) == 16) {
            l6 = l3 + l4;
        }
        l5 = l + programHeaderEntry.fileOffset + l6;
        return l5;
    }

    static String byteArrayToHexString(byte[] byArray) {
        String string = "";
        for (byte by : byArray) {
            string = string + String.format("0x%x ", by);
        }
        return string;
    }

    public static long readUnsignedLEB128(ImageInputStream imageInputStream) throws IOException {
        byte by = imageInputStream.readByte();
        long l = 0L;
        int n = 0;
        while ((by & 0x80) == 128) {
            l += (long)((by & 0x7F) << n);
            n += 7;
            by = imageInputStream.readByte();
        }
        return l += (long)((by & 0x7F) << n);
    }

    public static long readSignedLEB128(ImageInputStream imageInputStream) throws IOException {
        byte by;
        long l = 0L;
        int n = 0;
        do {
            by = imageInputStream.readByte();
            l += (long)((by & 0x7F) << n);
            n += 7;
        } while ((by & 0x80) == 128);
        if ((by & 0x40) == 64) {
            l |= -(1L << n);
        }
        return l;
    }

    long readEncodedPC(ImageInputStream imageInputStream, byte by) throws IOException {
        this.process.bytesPerPointer();
        switch (by & 0xF) {
            case 0: {
                if (this.process.bytesPerPointer() == 8) {
                    return imageInputStream.readLong();
                }
                return imageInputStream.readInt();
            }
            case 1: {
                return Unwind.readUnsignedLEB128(imageInputStream);
            }
            case 9: {
                return Unwind.readSignedLEB128(imageInputStream);
            }
            case 2: 
            case 10: {
                return imageInputStream.readShort();
            }
            case 3: 
            case 11: {
                return imageInputStream.readInt();
            }
            case 4: 
            case 12: {
                return imageInputStream.readLong();
            }
        }
        throw new IOException(String.format("Unsupported encoding 0x%x", by & 0xF));
    }

    public UnwindTable getUnwindTableForInstructionAddress(long l) throws CorruptDataException, IOException {
        for (FDE fDE : this.frameDescriptionEntries) {
            try {
                if (!fDE.contains(l)) continue;
                return new UnwindTable(fDE, this, l);
            }
            catch (IOException iOException) {
            }
            catch (CorruptDataException corruptDataException) {
            }
        }
        return null;
    }

    protected class DW_EH_PE {
        static final int absptr = 0;
        static final int omit = 255;
        static final int uleb128 = 1;
        static final int udata2 = 2;
        static final int udata4 = 3;
        static final int udata8 = 4;
        static final int sleb128 = 9;
        static final int sdata2 = 10;
        static final int sdata4 = 11;
        static final int sdata8 = 12;
        static final int signed = 8;
        static final int pcrel = 16;
        static final int textrel = 32;
        static final int datarel = 48;
        static final int funcrel = 64;
        static final int aligned = 80;
        static final int indirect = 128;

        protected DW_EH_PE() {
        }
    }
}

