/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.AbstractMemory;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.SymbolUtil;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class BufferedMemory
extends AbstractMemory
implements IProcess,
IAddressSpace {
    private final int bytesPerPointer = Integer.parseInt(System.getProperty("sun.arch.data.model")) / 8;

    public BufferedMemory(ByteOrder byteOrder) {
        super(byteOrder);
    }

    @Override
    public Platform getPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("aix")) {
            return Platform.AIX;
        }
        if (string.contains("windows")) {
            return Platform.WINDOWS;
        }
        if (string.contains("z/os")) {
            return Platform.ZOS;
        }
        if (string.contains("linux")) {
            return Platform.LINUX;
        }
        if (string.contains("mac")) {
            return Platform.OSX;
        }
        throw new InternalError("Unsupported platform");
    }

    @Override
    public IAddressSpace getAddressSpace() {
        return this;
    }

    @Override
    public long getPointerAt(long l) throws MemoryFault {
        if (this.bytesPerPointer == 8) {
            return this.getLongAt(l);
        }
        return 0xFFFFFFFFL & (long)this.getIntAt(l);
    }

    @Override
    public int bytesPerPointer() {
        return this.bytesPerPointer;
    }

    @Override
    public String getCommandLine() throws DataUnavailableException, CorruptDataException {
        throw new DataUnavailableException("DDR not invoked via command line.");
    }

    @Override
    public Properties getEnvironmentVariables() throws DataUnavailableException, CorruptDataException {
        Properties properties = new Properties();
        System.getenv().forEach((string, string2) -> properties.setProperty((String)string, (String)string2));
        return properties;
    }

    @Override
    public Collection<? extends IModule> getModules() throws CorruptDataException {
        return Collections.emptySet();
    }

    @Override
    public IModule getExecutable() throws CorruptDataException {
        return null;
    }

    @Override
    public long getProcessId() throws CorruptDataException {
        return -1L;
    }

    @Override
    public String getProcedureNameForAddress(long l) throws DataUnavailableException, CorruptDataException {
        return this.getProcedureNameForAddress(l, false);
    }

    @Override
    public String getProcedureNameForAddress(long l, boolean bl) throws DataUnavailableException, CorruptDataException {
        return SymbolUtil.getProcedureNameForAddress(this, l, bl);
    }

    @Override
    public Collection<? extends IOSThread> getThreads() throws CorruptDataException {
        return Collections.emptySet();
    }

    @Override
    public int getSignalNumber() throws DataUnavailableException {
        return 0;
    }

    @Override
    public boolean isFailingProcess() throws DataUnavailableException {
        return false;
    }

    @Override
    public ICore getCore() {
        return null;
    }

    public List<IProcess> getProcesses() {
        return Collections.singletonList(this);
    }

    @Override
    public int getAddressSpaceId() {
        return 0;
    }
}

