/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.OptInfo;
import com.ibm.j9ddr.vm29.j9.walkers.LocalVariableTable;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.structure.J9NonbuilderConstants;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U8;
import java.util.Iterator;

public abstract class LocalVariableTableIterator
implements Iterator<LocalVariableTable> {
    public static void checkVariableTableVersion() throws CorruptDataException {
        int n = AlgorithmVersion.getVersionOf("VM_LOCAL_VARIABLE_TABLE_VERSION").getAlgorithmVersion();
        if (n < 1) {
            throw new CorruptDataException("Unexpected local variable table version " + n);
        }
    }

    public static LocalVariableTableIterator localVariableTableIteratorFor(J9MethodDebugInfoPointer j9MethodDebugInfoPointer) throws CorruptDataException {
        LocalVariableTableIterator.checkVariableTableVersion();
        return new LocalVariableTableIterator_V1(j9MethodDebugInfoPointer);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public abstract U8Pointer getLocalVariableTablePtr();

    private static class LocalVariableTableIterator_V1
    extends LocalVariableTableIterator {
        private J9MethodDebugInfoPointer methodInfo;
        private U32 count = new U32(0L);
        private U8Pointer localVariableTablePtr;
        private U32 slotNumber = new U32(0L);
        private U32 startVisibility = new U32(0L);
        private U32 visibilityLength = new U32(0L);

        public LocalVariableTableIterator_V1(J9MethodDebugInfoPointer j9MethodDebugInfoPointer) throws CorruptDataException {
            this.methodInfo = j9MethodDebugInfoPointer;
            this.localVariableTablePtr = OptInfo.getV1VariableTableForMethodDebugInfo(j9MethodDebugInfoPointer);
        }

        @Override
        public boolean hasNext() {
            try {
                return this.count.lt(this.methodInfo.varInfoCount());
            }
            catch (CorruptDataException corruptDataException) {
                return false;
            }
        }

        @Override
        public LocalVariableTable next() {
            J9UTF8Pointer j9UTF8Pointer;
            SelfRelativePointer selfRelativePointer;
            J9UTF8Pointer j9UTF8Pointer2;
            SelfRelativePointer selfRelativePointer2;
            J9UTF8Pointer j9UTF8Pointer3;
            SelfRelativePointer selfRelativePointer3;
            this.count = this.count.add(1);
            try {
                U8 u8 = this.localVariableTablePtr.at(0L);
                if (u8.bitAnd(128).eq(0L)) {
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                    this.slotNumber = this.slotNumber.add(u8.rightShift(6));
                    this.visibilityLength = this.visibilityLength.add(LocalVariableTableIterator_V1.signExtend(new I32(u8.bitAnd(63)), 6));
                } else if (u8.bitAnd(192).eq(128L)) {
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                    this.slotNumber = this.slotNumber.add(u8.rightShift(5).bitAnd(1));
                    this.startVisibility = this.startVisibility.add(LocalVariableTableIterator_V1.signExtend(new I32(u8.bitAnd(31)), 5));
                    this.visibilityLength = this.visibilityLength.add(LocalVariableTableIterator_V1.signExtend(new I32(this.localVariableTablePtr.at(0L)), 8));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                } else if (u8.bitAnd(224).eq(192L)) {
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                    this.slotNumber = this.slotNumber.add(u8.rightShift(4).bitAnd(1));
                    U32 u32 = new U32(u8).leftShift(16);
                    u32 = u32.bitOr(U16Pointer.cast(this.localVariableTablePtr).at(0L));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(2L);
                    this.startVisibility = this.startVisibility.add(LocalVariableTableIterator_V1.signExtend(new I32(u32.rightShift(11).bitAnd(511)), 9));
                    this.visibilityLength = this.visibilityLength.add(LocalVariableTableIterator_V1.signExtend(new I32(u32.bitAnd(2047)), 11));
                } else if (u8.bitAnd(240).eq(224L)) {
                    U32 u32 = new U32(u8);
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                    this.slotNumber = this.slotNumber.add(u32.rightShift(2).bitAnd(3));
                    U32 u322 = u32.bitAnd(3).leftShift(16);
                    u322 = u322.bitOr(U16Pointer.cast(this.localVariableTablePtr).at(0L));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(2L);
                    this.visibilityLength = this.visibilityLength.add(LocalVariableTableIterator_V1.signExtend(new I32(u322), 18));
                    this.startVisibility = this.startVisibility.add(LocalVariableTableIterator_V1.signExtend(new I32(U16Pointer.cast(this.localVariableTablePtr).at(0L)), 16));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(2L);
                } else if (u8.eq(240L)) {
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                    this.slotNumber = this.slotNumber.add(I32Pointer.cast(this.localVariableTablePtr).at(0L));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                    this.startVisibility = this.startVisibility.add(I32Pointer.cast(this.localVariableTablePtr).at(0L));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                    this.visibilityLength = this.visibilityLength.add(I32Pointer.cast(this.localVariableTablePtr).at(0L));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                } else {
                    return null;
                }
                selfRelativePointer3 = SelfRelativePointer.cast(this.localVariableTablePtr);
                j9UTF8Pointer3 = J9UTF8Pointer.cast(selfRelativePointer3.get());
                this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                selfRelativePointer2 = SelfRelativePointer.cast(this.localVariableTablePtr);
                j9UTF8Pointer2 = J9UTF8Pointer.cast(selfRelativePointer2.get());
                this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                if (this.visibilityLength.anyBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_VARIABLE_TABLE_HAS_GENERIC)) {
                    selfRelativePointer = SelfRelativePointer.cast(this.localVariableTablePtr);
                    j9UTF8Pointer = J9UTF8Pointer.cast(selfRelativePointer.get());
                    this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                } else {
                    selfRelativePointer = SelfRelativePointer.NULL;
                    j9UTF8Pointer = J9UTF8Pointer.NULL;
                }
                this.visibilityLength = this.visibilityLength.bitAnd(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_VARIABLE_TABLE_HAS_GENERIC ^ 0xFFFFFFFFFFFFFFFFL);
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("CorruptData encountered walking local variable table.", corruptDataException, false);
                return null;
            }
            return new LocalVariableTable(this.slotNumber, this.startVisibility, this.visibilityLength, selfRelativePointer, j9UTF8Pointer, selfRelativePointer3, j9UTF8Pointer3, selfRelativePointer2, j9UTF8Pointer2);
        }

        private static I32 signExtend(I32 i32, int n) {
            int n2 = 32 - n;
            return i32.leftShift(n2).rightShift(n2);
        }

        @Override
        public U8Pointer getLocalVariableTablePtr() {
            return this.localVariableTablePtr;
        }
    }
}

