/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.framework.scanner;

import com.ibm.dtfj.javacore.parser.framework.parser.ILookAheadBuffer;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.scanner.IScanner;
import com.ibm.dtfj.javacore.parser.framework.scanner.ScannerException;
import java.io.IOException;
import java.util.ArrayList;

public class LookAheadBuffer
implements ILookAheadBuffer {
    private ArrayList fBuffer;
    private int fCurrentDepth;
    private IScanner fScanner;

    public LookAheadBuffer(int n, IScanner iScanner) {
        this.fCurrentDepth = n;
        this.fBuffer = new ArrayList(this.fCurrentDepth);
        this.fScanner = iScanner;
    }

    @Override
    public boolean match(String string) {
        boolean bl = false;
        if (this.fBuffer.size() > 0) {
            IParserToken iParserToken = (IParserToken)this.fBuffer.get(0);
            bl = iParserToken != null ? iParserToken.getType().equals(string) : string == null;
        }
        return bl;
    }

    @Override
    public void consume() throws IOException, ScannerException {
        if (this.fBuffer.size() > 0) {
            this.fBuffer.remove(0);
        }
        this.fill();
    }

    @Override
    public boolean allConsumed() {
        return this.fScanner.allTokensGenerated() && this.fBuffer.isEmpty();
    }

    private void fill() throws IOException, ScannerException {
        while (!this.fScanner.allTokensGenerated() && this.fBuffer.size() < this.fCurrentDepth) {
            IParserToken iParserToken = this.fScanner.next();
            this.fBuffer.add(iParserToken);
        }
    }

    @Override
    public IParserToken lookAhead(int n) throws IOException, ScannerException, IndexOutOfBoundsException {
        this.fill();
        return (IParserToken)this.fBuffer.get(n - 1);
    }

    @Override
    public void init() throws IOException, ScannerException {
        this.fill();
    }

    @Override
    public void setLookAheadDepth(int n) throws IOException, ScannerException {
        if (n > 0) {
            this.fCurrentDepth = n;
            this.fill();
        }
    }

    @Override
    public int length() {
        return this.fBuffer.size();
    }

    @Override
    public int maxDepth() {
        return this.fCurrentDepth;
    }
}

