/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.nativememory;

import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.nativememory.INativeMemoryTypes;
import java.util.Stack;

public class NativeMemorySectionParser
extends SectionParser
implements INativeMemoryTypes {
    public NativeMemorySectionParser() {
        super("NATIVEMEMINFO");
    }

    @Override
    protected void sovOnlyRules(String string) throws ParserException {
    }

    @Override
    protected void topLevelRule() throws ParserException {
        IImageProcessBuilder iImageProcessBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder();
        IJavaRuntimeBuilder iJavaRuntimeBuilder = iImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        IAttributeValueMap iAttributeValueMap = null;
        Stack<JavaRuntimeMemoryCategory> stack = new Stack<JavaRuntimeMemoryCategory>();
        this.processTagLineOptional("0MEMUSER");
        while ((iAttributeValueMap = this.processMemUserLine()) != null) {
            String string = iAttributeValueMap.getTokenValue("nativemem_name");
            if (string == null) continue;
            int n = iAttributeValueMap.getIntValue("nativemem_depth");
            while (stack.size() >= n) {
                stack.pop();
            }
            long l = this.parseCommaDelimitedLong(iAttributeValueMap.getTokenValue("nativemem_deepbytes"));
            long l2 = this.parseCommaDelimitedLong(iAttributeValueMap.getTokenValue("nativemem_allocations"));
            JavaRuntimeMemoryCategory javaRuntimeMemoryCategory = null;
            if (stack.size() > 0) {
                javaRuntimeMemoryCategory = (JavaRuntimeMemoryCategory)stack.peek();
            }
            if (string.equals("Other")) {
                if (javaRuntimeMemoryCategory == null) {
                    throw new ParserException("Parse error: Unexpected NULL parent category for \"Other\" memory category");
                }
                iJavaRuntimeBuilder.setShallowCountersForCategory(javaRuntimeMemoryCategory, l, l2);
                continue;
            }
            JavaRuntimeMemoryCategory javaRuntimeMemoryCategory2 = iJavaRuntimeBuilder.addMemoryCategory(string, l, l2, javaRuntimeMemoryCategory);
            stack.push(javaRuntimeMemoryCategory2);
        }
    }

    private long parseCommaDelimitedLong(String string) {
        return Long.parseLong(string.replaceAll(",", ""));
    }

    private IAttributeValueMap processMemUserLine() throws ParserException {
        for (int i = 0; i < T_MEMUSERS.length; ++i) {
            String string = T_MEMUSERS[i];
            IAttributeValueMap iAttributeValueMap = this.processTagLineOptional(string);
            if (iAttributeValueMap == null) continue;
            return iAttributeValueMap;
        }
        return null;
    }
}

