/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.parser;

import com.ibm.dtfj.phd.parser.Base;
import com.ibm.dtfj.phd.parser.DumpClass;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import com.ibm.dtfj.phd.parser.PortableHeapDumpListener;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.io.PrintStream;

public class PrintHeapdump
extends Base {
    boolean hash;
    String[] types = new String[]{"bool", "char", "float", "double", "byte", "short", "int", "long"};
    int objectCount;
    int objectArrayCount;
    int classCount;
    int primitiveArrayCount;
    int totalObjectCount;
    int refCount;
    int minimumInstanceSize = 100;
    PrintStream out;
    static boolean is64Bit;

    public static void main(String[] stringArray) throws Exception {
        new PrintHeapdump(stringArray);
    }

    public PrintHeapdump(String[] stringArray) throws Exception {
        this.parseOptions(stringArray);
        this.out = System.out;
        this.parse(stringArray[stringArray.length - 1]);
    }

    public PrintHeapdump(String string) throws Exception {
        this.out = System.out;
        this.parse(string);
    }

    public PrintHeapdump(String string, PrintStream printStream) throws Exception {
        this.out = printStream;
        this.parse(string);
    }

    int roundup(int n) {
        return n + 7 & 0xFFFFFFF8;
    }

    void printRefs(LongEnumeration longEnumeration) {
        this.out.print("\t");
        while (longEnumeration.hasMoreElements()) {
            this.out.print("0x" + PrintHeapdump.hex(longEnumeration.nextLong()) + " ");
            ++this.refCount;
        }
        this.out.println("");
    }

    public void parse(String string) throws Exception {
        HeapdumpReader heapdumpReader = new HeapdumpReader(string);
        this.out.println("// Version: " + heapdumpReader.full_version());
        heapdumpReader.parse(new PortableHeapDumpListener(){

            @Override
            public void objectDump(long l, long l2, int n, int n2, LongEnumeration longEnumeration, long l3) {
                DumpClass.foundClass(l2);
            }

            @Override
            public void objectArrayDump(long l, long l2, int n, int n2, LongEnumeration longEnumeration, int n3, long l3) {
                DumpClass.foundClass(l2);
            }

            @Override
            public void classDump(long l, long l2, String string, int n, int n2, int n3, LongEnumeration longEnumeration) {
                DumpClass.put(l, string, n);
                if (n >= 0 && n < PrintHeapdump.this.minimumInstanceSize) {
                    PrintHeapdump.this.minimumInstanceSize = n;
                }
            }

            @Override
            public void primitiveArrayDump(long l, int n, int n2, int n3, int n4, long l2) {
            }
        });
        heapdumpReader.close();
        heapdumpReader = new HeapdumpReader(string);
        is64Bit = heapdumpReader.is64Bit();
        heapdumpReader.parse(new PortableHeapDumpListener(){

            @Override
            public void objectDump(long l, long l2, int n, int n2, LongEnumeration longEnumeration, long l3) {
                DumpClass dumpClass = DumpClass.get(l2);
                long l4 = dumpClass.instanceSize;
                PrintHeapdump.this.out.println("0x" + PrintHeapdump.hexpad(l).toUpperCase() + " [" + l4 + "] " + dumpClass.name + (PrintHeapdump.this.hash ? " [hashcode = " + Base.hex(n2) + "]" : ""));
                PrintHeapdump.this.printRefs(longEnumeration);
                ++PrintHeapdump.this.objectCount;
                ++PrintHeapdump.this.totalObjectCount;
            }

            @Override
            public void objectArrayDump(long l, long l2, int n, int n2, LongEnumeration longEnumeration, int n3, long l3) {
                DumpClass dumpClass = DumpClass.get(l2);
                if (l3 == -1L) {
                    l3 = n3 + 4 << (is64Bit ? 3 : 2);
                    l3 = PrintHeapdump.this.roundup((int)l3);
                }
                PrintHeapdump.this.out.println("0x" + PrintHeapdump.hexpad(l).toUpperCase() + " [" + l3 + "] array of " + dumpClass.name + (PrintHeapdump.this.hash ? " [hashcode = " + Base.hex(n2) + "]" : ""));
                PrintHeapdump.this.printRefs(longEnumeration);
                ++PrintHeapdump.this.objectArrayCount;
                ++PrintHeapdump.this.totalObjectCount;
            }

            @Override
            public void classDump(long l, long l2, String string, int n, int n2, int n3, LongEnumeration longEnumeration) {
                PrintHeapdump.this.out.println("0x" + PrintHeapdump.hexpad(l).toUpperCase() + " [" + (is64Bit ? "552" : "304") + "] class " + string + (PrintHeapdump.this.hash ? " [hashcode = " + Base.hex(n3) + "]" : ""));
                PrintHeapdump.this.printRefs(longEnumeration);
                ++PrintHeapdump.this.classCount;
                ++PrintHeapdump.this.totalObjectCount;
            }

            @Override
            public void primitiveArrayDump(long l, int n, int n2, int n3, int n4, long l2) {
                if (l2 == -1L) {
                    l2 = (n2 << (n & 3)) + (is64Bit ? 24 : 12);
                    l2 = PrintHeapdump.this.roundup((int)l2);
                }
                if (n >= PrintHeapdump.this.types.length) {
                    PrintHeapdump.this.out.println("Warning! bad type " + n + " found in following object");
                    n = 0;
                }
                PrintHeapdump.this.out.println("0x" + PrintHeapdump.hexpad(l).toUpperCase() + " [" + l2 + "] " + PrintHeapdump.this.types[n] + "[]" + (PrintHeapdump.this.hash ? " [hashcode = " + Base.hex(n4) + "]" : ""));
                ++PrintHeapdump.this.primitiveArrayCount;
                ++PrintHeapdump.this.totalObjectCount;
            }
        });
        heapdumpReader.close();
        this.out.println("");
        this.out.println("// Breakdown - Classes: " + this.classCount + ", Objects: " + this.objectCount + ", ObjectArrays: " + this.objectArrayCount + ", PrimitiveArrays: " + this.primitiveArrayCount);
        this.out.println("// EOF:  Total 'Objects',Refs(null) : " + this.totalObjectCount + "," + this.refCount + "(0)");
    }

    @Override
    String[] options() {
        return new String[]{"-hash"};
    }

    @Override
    String[] optionDescriptions() {
        return new String[]{"\tInclude the hash codes"};
    }

    @Override
    public boolean parseOption(String string, String string2) {
        if ("-hash".equals(string)) {
            this.hash = true;
            return true;
        }
        return super.parseOption(string, string2);
    }

    @Override
    String className() {
        return "PrintHeapdump";
    }

    public static String hexpad(long l) {
        String string = is64Bit ? Long.toHexString(l) : Integer.toHexString((int)l);
        for (int i = string.length(); i < (is64Bit ? 16 : 8); ++i) {
            string = "0" + string;
        }
        return string;
    }

    public static String hex(long l) {
        String string = is64Bit ? String.format("%016X", l) : String.format("%08X", l);
        return string;
    }
}

