/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.util;

import com.ibm.dtfj.phd.util.BitStream;
import com.ibm.dtfj.phd.util.LongArray;
import com.ibm.dtfj.phd.util.NumberStream;

public class SortedNumberStream
extends NumberStream {
    NumberStream streamBuffer;
    static final int BUFFER_SIZE = 200000;
    LongArray buffer = new LongArray(200000, 0L);
    int bufferCount;

    public SortedNumberStream() {
        this.streamBuffer = new NumberStream();
    }

    void flushBuffer() {
        if (this.bufferCount == 0) {
            return;
        }
        this.buffer.setSize(this.bufferCount);
        this.buffer.sort();
        this.buffer.setSize(200000);
        this.reset();
        this.readElementCount = this.elementCount;
        this.streamBuffer.reset();
        this.streamBuffer.elementCount = 0;
        this.streamBuffer.readElementCount = 0;
        this.streamBuffer.bitStream.clear();
        int n = 0;
        while (n < this.bufferCount || this.hasMore()) {
            if (this.hasMore()) {
                long l = this.readLong();
                while (n < this.bufferCount && this.buffer.get(n) < l) {
                    this.streamBuffer.writeLong(this.buffer.get(n++));
                }
                this.streamBuffer.writeLong(l);
                continue;
            }
            this.streamBuffer.writeLong(this.buffer.get(n++));
        }
        this.streamBuffer.flush();
        BitStream bitStream = this.bitStream;
        this.setBitStream(this.streamBuffer.bitStream);
        this.streamBuffer.setBitStream(bitStream);
        this.elementCount = this.streamBuffer.elementCount;
        this.readElementCount = this.streamBuffer.readElementCount;
        this.bufferCount = 0;
    }

    @Override
    public void writeLong(long l) {
        this.buffer.put(this.bufferCount++, l);
        if (this.bufferCount == 200000) {
            this.flushBuffer();
        }
    }

    @Override
    public void rewind() {
        this.flushBuffer();
        super.rewind();
    }
}

