/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins.impl;

import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.ClassInfo;
import com.ibm.java.diagnostics.utils.plugins.ClassListener;
import com.ibm.java.diagnostics.utils.plugins.Container;
import com.ibm.java.diagnostics.utils.plugins.Entry;
import com.ibm.java.diagnostics.utils.plugins.PluginManager;
import com.ibm.java.diagnostics.utils.plugins.impl.ClassScanner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class PluginManagerImpl
implements PluginManager {
    protected static final Logger logger = Logger.getLogger("com.ibm.java.diagnostics.plugins");
    protected final Container cache = new Container(null);
    protected final ArrayList<File> pluginSearchPath = new ArrayList();
    private static PluginManagerImpl instance;
    private final Set<ClassListener> listeners = new HashSet<ClassListener>();
    private URL[] classpath;

    public static PluginManager getPluginManager() {
        if (instance == null) {
            instance = new PluginManagerImpl();
        }
        return instance;
    }

    private PluginManagerImpl() {
        this.refreshSearchPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshSearchPath() {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            String[] stringArray;
            this.pluginSearchPath.clear();
            String string = System.getProperty("com.ibm.java.diagnostics.plugins");
            if (null == string) {
                string = System.getenv("com.ibm.java.diagnostics.plugins");
            }
            if (null == string || string.length() == 0) {
                logger.fine("No system property called com.ibm.java.diagnostics.plugins was found");
                return;
            }
            logger.fine("Plugins search path = " + string);
            for (String string2 : stringArray = string.split(File.pathSeparator)) {
                String string3 = PluginManagerImpl.stripQuotesFromPath(string2);
                this.pluginSearchPath.add(new File(string3));
            }
        }
    }

    private static String stripQuotesFromPath(String string) {
        if (string.length() > 0 && string.charAt(0) == '\"') {
            string = string.substring(1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanForClassFiles() throws CommandException {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            this.classpath = null;
            for (File file : this.pluginSearchPath) {
                logger.fine("Scanning path " + file + " in search of plugins");
                if (!file.exists()) {
                    logger.fine(String.format("Skipping search path: %s does not exist", file.getAbsolutePath()));
                    continue;
                }
                if (file.isDirectory()) {
                    this.scanDirectory(file);
                    continue;
                }
                this.scanFile(file);
            }
        }
    }

    public <T extends Entry> T getEntry(File file) {
        return this.cache.getEntry(file);
    }

    private void scanDirectory(File file) {
        File[] fileArray;
        logger.fine("Scanning directory " + file.getAbsolutePath());
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                this.scanDirectory(file2);
                continue;
            }
            this.scanFile(file2);
        }
    }

    private static String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (-1 == n || string.length() == n + 1) {
            return "";
        }
        return string.substring(n);
    }

    private void scanFile(File file) {
        Entry entry = null;
        logger.fine("Scanning file " + file.getAbsolutePath());
        String string = PluginManagerImpl.getExtension(file);
        if (string.equals(".jar") && !file.getName().equalsIgnoreCase("dtfj.jar")) {
            entry = this.examineJarFile(file);
        }
        if (string.equals(".class") && (entry = this.examineClassFile(file)) != null) {
            for (ClassListener classListener : this.listeners) {
                classListener.scanComplete(entry);
            }
        }
    }

    private Entry examineClassFile(File file) {
        if (file.length() > Integer.MAX_VALUE) {
            logger.fine("Skipping file " + file.getAbsolutePath() + " as the file size is > Integer.MAX_VALUE");
            return null;
        }
        Object object = this.getEntry(file);
        if (object == null || ((Entry)object).getData() == null || ((Entry)object).hasChanged(file)) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                ClassInfo classInfo = this.scanClassFile(fileInputStream, file.toURI().toURL());
                if (object == null) {
                    object = new Entry(classInfo.getClassname(), file);
                    this.cache.addEntry((Entry)object);
                }
                ((Entry)object).setData(classInfo);
                ((Entry)object).setSize(file.length());
                ((Entry)object).setLastModified(file.lastModified());
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, iOException.getMessage());
            }
        }
        return object;
    }

    private ClassInfo scanClassFile(InputStream inputStream, URL uRL) throws IOException {
        return ClassScanner.getClassInfo(inputStream, uRL, this.listeners);
    }

    private Entry examineJarFile(File file) {
        logger.fine("Found jar file " + file.getAbsolutePath());
        Container container = (Container)this.getEntry(file);
        if (container == null) {
            container = new Container(file);
            this.cache.addEntry(container);
        }
        if (container.getData() == null || container.hasChanged(file)) {
            try {
                Throwable object = null;
                try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));){
                    Object object2;
                    while ((object2 = jarInputStream.getNextJarEntry()) != null) {
                        String string = ((ZipEntry)object2).getName();
                        if (((ZipEntry)object2).isDirectory() || !string.endsWith(".class")) continue;
                        long l = ((ZipEntry)object2).getSize();
                        if (l > Integer.MAX_VALUE) {
                            logger.fine("Skipping jar entry " + string + " as the uncompressed size is > Integer.MAX_VALUE");
                            continue;
                        }
                        Entry entry = new Entry(string);
                        ClassInfo classInfo = this.scanClassFile(jarInputStream, entry.toURL());
                        entry.setData(classInfo);
                        entry.setSize(l);
                        entry.setLastModified(((ZipEntry)object2).getTime());
                        container.addEntry(entry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "Error reading from file " + file.getAbsolutePath(), iOException);
            }
            container.setData(new Object());
        }
        for (Entry entry : container.getEntries()) {
            for (ClassListener classListener : this.listeners) {
                classListener.scanComplete(entry);
            }
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container getCache() {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            return this.cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(ClassListener classListener) {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            if (this.listeners.contains(classListener)) {
                this.listeners.remove(classListener);
            }
            return this.listeners.add(classListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(ClassListener classListener) {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            return this.listeners.remove(classListener);
        }
    }

    @Override
    public Set<ClassListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL[] getClasspath() {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            if (this.classpath == null) {
                HashSet<URL> hashSet = new HashSet<URL>();
                for (Entry entry : this.cache.getEntries()) {
                    try {
                        File file = entry.getFile();
                        if (file != null && !(entry instanceof Container)) {
                            ClassInfo classInfo = (ClassInfo)entry.getData();
                            String string = classInfo.getClassname();
                            int n = -1;
                            do {
                                file = file.getParentFile();
                                n = string.indexOf(46, n + 1);
                            } while (file != null && n != -1);
                        }
                        if (file == null) continue;
                        hashSet.add(file.toURI().toURL());
                    }
                    catch (Exception exception) {
                        logger.log(Level.FINE, "Error setting classpath for plugin " + entry.getName(), exception);
                    }
                }
                this.classpath = new URL[hashSet.size()];
                hashSet.toArray(this.classpath);
            }
            return this.classpath;
        }
    }
}

