/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import jdk.crypto.jniprovider.NativeCrypto;
import sun.security.ec.ECKeyPairGenerator;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.ec.NativeECUtil;
import sun.security.provider.Sun;
import sun.security.util.ECUtil;
import sun.security.util.SecurityProviderConstants;

public final class NativeECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int KEY_SIZE_MIN = 112;
    private static final int KEY_SIZE_MAX = 571;
    private static NativeCrypto nativeCrypto;
    private static final boolean nativeCryptTrace;
    private SecureRandom random;
    private int keySize;
    private ECParameterSpec params;
    private String curve;
    private ECKeyPairGenerator javaImplementation;

    public NativeECKeyPairGenerator() {
        this.initialize(SecurityProviderConstants.DEF_EC_KEY_SIZE, null);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        if (secureRandom == null) {
            if (nativeCryptTrace) {
                System.err.println("No SecureRandom implementation was provided during initialization. Using OpenSSL.");
            }
        } else if (secureRandom.getProvider() instanceof Sun && ("NativePRNG".equals(secureRandom.getAlgorithm()) || "DRBG".equals(secureRandom.getAlgorithm()))) {
            if (nativeCryptTrace) {
                System.err.println("Default SecureRandom implementation was provided during initialization. Using OpenSSL.");
            }
        } else {
            if (nativeCryptTrace) {
                System.err.println("SecureRandom implementation was provided during initialization. Using Java implementation instead of OpenSSL.");
            }
            this.javaImplementation = new ECKeyPairGenerator();
            this.javaImplementation.initialize(n, secureRandom);
            return;
        }
        if (n < 112) {
            throw new InvalidParameterException("Key size must be at least 112 bits");
        }
        if (n > 571) {
            throw new InvalidParameterException("Key size must be at most 571 bits");
        }
        this.keySize = n;
        this.params = ECUtil.getECParameterSpec(null, n);
        if (this.params == null) {
            throw new InvalidParameterException("No EC parameters available for key size " + n + " bits");
        }
        this.random = secureRandom;
        this.curve = NativeECUtil.getCurveName(this.params);
        if (this.curve != null && NativeECUtil.isCurveSupported(this.curve, this.params)) {
            this.javaImplementation = null;
        } else {
            this.javaImplementation = new ECKeyPairGenerator();
            this.javaImplementation.initialize(this.keySize, this.random);
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (secureRandom == null) {
            if (nativeCryptTrace) {
                System.err.println("No SecureRandom implementation was provided during initialization. Using OpenSSL.");
            }
        } else if (secureRandom.getProvider() instanceof Sun && ("NativePRNG".equals(secureRandom.getAlgorithm()) || "DRBG".equals(secureRandom.getAlgorithm()))) {
            if (nativeCryptTrace) {
                System.err.println("Default SecureRandom implementation was provided during initialization. Using OpenSSL.");
            }
        } else {
            if (nativeCryptTrace) {
                System.err.println("SecureRandom implementation was provided during initialization. Using Java implementation instead of OpenSSL.");
            }
            this.javaImplementation = new ECKeyPairGenerator();
            this.javaImplementation.initialize(algorithmParameterSpec, secureRandom);
            return;
        }
        ECParameterSpec eCParameterSpec = null;
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec eCParameterSpec2 = (ECParameterSpec)algorithmParameterSpec;
            eCParameterSpec = ECUtil.getECParameterSpec(null, eCParameterSpec2);
            if (eCParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("Unsupported curve: " + algorithmParameterSpec);
            }
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)algorithmParameterSpec;
            String string = eCGenParameterSpec.getName();
            eCParameterSpec = ECUtil.getECParameterSpec(null, string);
            if (eCParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("Unknown curve name: " + string);
            }
        } else {
            throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
        }
        ECKeyPairGenerator.ensureCurveIsSupported(eCParameterSpec);
        this.params = eCParameterSpec;
        this.keySize = eCParameterSpec.getCurve().getField().getFieldSize();
        this.random = secureRandom;
        this.curve = NativeECUtil.getCurveName(this.params);
        if (this.curve != null && NativeECUtil.isCurveSupported(this.curve, this.params)) {
            this.javaImplementation = null;
        } else {
            this.initializeJavaImplementation();
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        ECPrivateKeyImpl eCPrivateKeyImpl;
        ECPublicKeyImpl eCPublicKeyImpl;
        byte[] byArray;
        byte[] byArray2;
        int n;
        byte[] byArray3;
        int n2;
        int n3;
        if (this.javaImplementation != null) {
            return this.javaImplementation.generateKeyPair();
        }
        long l = NativeECUtil.encodeGroup(this.params);
        if (l == -1L) {
            NativeECUtil.putCurveIfAbsent(this.curve, Boolean.FALSE);
            if (nativeCryptTrace) {
                System.err.println("Could not encode group for curve " + this.curve + " in OpenSSL, using Java crypto implementation.");
            }
            try {
                this.initializeJavaImplementation();
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new ProviderException(invalidAlgorithmParameterException);
            }
            return this.javaImplementation.generateKeyPair();
        }
        ECField eCField = this.params.getCurve().getField();
        if (eCField instanceof ECFieldFp) {
            n3 = 0;
        } else if (eCField instanceof ECFieldF2m) {
            n3 = 1;
        } else {
            NativeECUtil.putCurveIfAbsent(this.curve, Boolean.FALSE);
            if (nativeCryptTrace) {
                System.err.println("Field type not supported for curve " + this.curve + " by OpenSSL, using Java crypto implementation.");
            }
            try {
                this.initializeJavaImplementation();
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new ProviderException(invalidAlgorithmParameterException);
            }
            return this.javaImplementation.generateKeyPair();
        }
        if (nativeCrypto == null) {
            nativeCrypto = NativeCrypto.getNativeCrypto();
        }
        if ((n2 = nativeCrypto.ECGenerateKeyPair(l, byArray3 = new byte[n = this.params.getCurve().getField().getFieldSize() + 7 >> 3], byArray3.length, byArray2 = new byte[n], byArray2.length, byArray = new byte[n], byArray.length, n3)) == -1) {
            NativeECUtil.putCurveIfAbsent(this.curve, Boolean.FALSE);
            if (nativeCryptTrace) {
                System.err.println("Could not generate key pair for curve " + this.curve + " using OpenSSL, using Java crypto implementation for key generation.");
            }
            try {
                this.initializeJavaImplementation();
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new ProviderException(invalidAlgorithmParameterException);
            }
            return this.javaImplementation.generateKeyPair();
        }
        BigInteger bigInteger = new BigInteger(1, byArray3);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        ECPoint eCPoint = new ECPoint(bigInteger, bigInteger2);
        try {
            eCPublicKeyImpl = new ECPublicKeyImpl(eCPoint, this.params);
        }
        catch (Exception exception) {
            throw new ProviderException("Could not generate key pair. Error with data transformation.");
        }
        try {
            eCPrivateKeyImpl = new ECPrivateKeyImpl(bigInteger3, this.params);
        }
        catch (Exception exception) {
            throw new ProviderException("Could not generate key pair. Error with data transformation.");
        }
        return new KeyPair(eCPublicKeyImpl, eCPrivateKeyImpl);
    }

    private void initializeJavaImplementation() throws InvalidAlgorithmParameterException {
        this.javaImplementation = new ECKeyPairGenerator();
        this.javaImplementation.initialize(this.params, this.random);
    }

    static {
        nativeCryptTrace = NativeCrypto.isTraceEnabled();
    }
}

