/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.crypto.jniprovider.NativeCrypto;
import sun.security.util.NamedCurve;

public final class NativeECUtil {
    private static NativeCrypto nativeCrypto;
    private static final boolean nativeCryptTrace;
    private static boolean nativeGF2m;
    private static final Map<String, Boolean> curveSupported;

    private NativeECUtil() {
    }

    static boolean isCurveSupported(String string, ECParameterSpec eCParameterSpec) {
        if (nativeCrypto == null) {
            nativeCrypto = NativeCrypto.getNativeCrypto();
        }
        if (!(nativeGF2m = nativeCrypto.ECNativeGF2m()) && eCParameterSpec.getCurve().getField() instanceof ECFieldF2m) {
            boolean bl = NativeECUtil.putCurveIfAbsent("EC2m", Boolean.FALSE);
            if (bl && nativeCryptTrace) {
                System.err.println("EC2m is not supported by OpenSSL, using Java crypto implementation.");
            }
            return false;
        }
        return curveSupported.getOrDefault(string, Boolean.TRUE);
    }

    static boolean putCurveIfAbsent(String string, Boolean bl) {
        return curveSupported.putIfAbsent(string, bl) == null;
    }

    static String getCurveName(ECParameterSpec eCParameterSpec) {
        String string;
        if (eCParameterSpec instanceof NamedCurve) {
            NamedCurve namedCurve = (NamedCurve)eCParameterSpec;
            string = namedCurve.getName();
        } else {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
                algorithmParameters.init(eCParameterSpec);
                string = algorithmParameters.getParameterSpec(ECGenParameterSpec.class).getName();
            }
            catch (NoSuchAlgorithmException | InvalidParameterSpecException generalSecurityException) {
                string = null;
            }
        }
        return string;
    }

    static long encodeGroup(ECParameterSpec eCParameterSpec) {
        int n;
        byte[] byArray;
        ECPoint eCPoint = eCParameterSpec.getGenerator();
        EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
        ECField eCField = ellipticCurve.getField();
        byte[] byArray2 = ellipticCurve.getA().toByteArray();
        byte[] byArray3 = ellipticCurve.getB().toByteArray();
        byte[] byArray4 = eCPoint.getAffineX().toByteArray();
        byte[] byArray5 = eCPoint.getAffineY().toByteArray();
        byte[] byArray6 = eCParameterSpec.getOrder().toByteArray();
        byte[] byArray7 = BigInteger.valueOf(eCParameterSpec.getCofactor()).toByteArray();
        if (eCField instanceof ECFieldFp) {
            ECFieldFp eCFieldFp = (ECFieldFp)eCField;
            byArray = eCFieldFp.getP().toByteArray();
            n = 0;
        } else if (eCField instanceof ECFieldF2m) {
            ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
            byArray = eCFieldF2m.getReductionPolynomial().toByteArray();
            n = 1;
        } else {
            return -1L;
        }
        if (nativeCrypto == null) {
            nativeCrypto = NativeCrypto.getNativeCrypto();
        }
        return nativeCrypto.ECEncodeGF(n, byArray2, byArray2.length, byArray3, byArray3.length, byArray, byArray.length, byArray4, byArray4.length, byArray5, byArray5.length, byArray6, byArray6.length, byArray7, byArray7.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getPublicKeyNativePtr(ECPublicKey eCPublicKey) {
        ECPublicKey eCPublicKey2 = eCPublicKey;
        synchronized (eCPublicKey2) {
            long l = NativeECUtil.encodeGroup(eCPublicKey.getParams());
            if (l != -1L) {
                try {
                    byte[] byArray = eCPublicKey.getW().getAffineX().toByteArray();
                    byte[] byArray2 = eCPublicKey.getW().getAffineY().toByteArray();
                    int n = 0;
                    if (eCPublicKey.getParams().getCurve().getField() instanceof ECFieldF2m) {
                        n = 1;
                    }
                    if (nativeCrypto.ECCreatePublicKey(l, byArray, byArray.length, byArray2, byArray2.length, n) == -1) {
                        nativeCrypto.ECDestroyKey(l);
                        l = -1L;
                    }
                }
                finally {
                    if (l != -1L) {
                        nativeCrypto.createECKeyCleaner((Object)eCPublicKey, l);
                    }
                }
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getPrivateKeyNativePtr(ECPrivateKey eCPrivateKey) {
        ECPrivateKey eCPrivateKey2 = eCPrivateKey;
        synchronized (eCPrivateKey2) {
            long l = NativeECUtil.encodeGroup(eCPrivateKey.getParams());
            if (l != -1L) {
                try {
                    byte[] byArray = eCPrivateKey.getS().toByteArray();
                    if (nativeCrypto.ECCreatePrivateKey(l, byArray, byArray.length) == -1) {
                        nativeCrypto.ECDestroyKey(l);
                        l = -1L;
                    }
                }
                finally {
                    if (l != -1L) {
                        nativeCrypto.createECKeyCleaner((Object)eCPrivateKey, l);
                    }
                }
            }
            return l;
        }
    }

    static {
        nativeCryptTrace = NativeCrypto.isTraceEnabled();
        curveSupported = new ConcurrentHashMap<String, Boolean>();
    }
}

