/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.corereaders.ClosingFileReader;
import com.ibm.j9ddr.corereaders.IModuleFile;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.Symbol;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

public class XCOFFReader
implements IModuleFile {
    public static final short F_RELFLG = 1;
    public static final short F_EXEC = 2;
    public static final short F_LNNO = 4;
    public static final short F_AR32W = 512;
    public static final short F_DYNLOAD = 4096;
    public static final short F_SHROBJ = 8192;
    public static final short F_LOADONLY = 16384;
    public static final int STYP_REG = 0;
    public static final int STYP_PAD = 8;
    public static final int STYP_TEXT = 32;
    public static final int STYP_DATA = 64;
    public static final int STYP_BSS = 128;
    public static final int STYP_EXCEPT = 256;
    public static final int STYP_INFO = 512;
    public static final int STYP_TDATA = 1024;
    public static final int STYP_TBSS = 2048;
    public static final int STYP_LOADER = 4096;
    public static final int STYP_DEBUG = 8192;
    public static final int STYP_TYPCHK = 16384;
    public static final int STYP_OVRFLO = 32768;
    private static final short XCOFF_MAGIC_NUMBER_AIX32 = 479;
    private static final short XCOFF_MAGIC_NUMBER_AIX64_PRE43 = 495;
    private static final short XCOFF_MAGIC_NUMBER_AIX64_POST51 = 503;
    private final ImageInputStream _backing;
    private long _startOffset;
    private long _size;
    private boolean _is64Bit;
    private final String _library;
    private long _symbolTableOffset = -1L;
    private long _timeAndDate = 0L;
    private short _flags = 0;

    public XCOFFReader(File file) throws IOException {
        this(file, 0L, (int)file.length());
    }

    public XCOFFReader(File file, long l, long l2) throws IOException {
        this._startOffset = l;
        this._size = l2;
        this._library = file.getName();
        this._backing = new ClosingFileReader(file, ByteOrder.BIG_ENDIAN);
        this.init();
    }

    public XCOFFReader(String string, ImageInputStream imageInputStream, long l, long l2) throws IOException {
        this._backing = imageInputStream;
        this._library = string;
        this._startOffset = l;
        this._size = l2;
        this.init();
    }

    private void init() throws IOException {
        this.seekFileRelative(0L);
        short s = this._backing.readShort();
        if (479 != s && 495 != s && 503 != s) {
            throw new IllegalArgumentException();
        }
        this._is64Bit = 495 == s || 503 == s;
        this._backing.readShort();
        this._timeAndDate = 1000L * (0xFFFFFFFFL & (long)this._backing.readInt());
        this._symbolTableOffset = this._is64Bit ? this._backing.readLong() : 0xFFFFFFFFL & (long)this._backing.readInt();
        this.seekFileRelative(16L);
        this._backing.readShort();
        this._flags = this._backing.readShort();
    }

    private void seekFileRelative(long l) throws IOException {
        this._backing.seek(this._startOffset + l);
    }

    private long _symbolTableOffset() throws IOException {
        return this._symbolTableOffset;
    }

    private int _numberOfSymbols() throws IOException {
        this.seekFileRelative(this._is64Bit ? 20L : 12L);
        return this._backing.readInt();
    }

    private String _stringFromArray(byte[] byArray, int n) {
        int n2;
        for (n2 = n; n2 < byArray.length && 0 != byArray[n2]; ++n2) {
        }
        try {
            return new String(byArray, n, n2 - n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public long baseFileOffset() {
        return this._startOffset;
    }

    public long logicalSize() {
        return this._size;
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put("Time and Date", new Date(this._timeAndDate).toString());
        String string = (0 != (this._flags & 1) ? "F_RELFLG " : "") + (0 != (this._flags & 2) ? "F_EXEC " : "") + (0 != (this._flags & 4) ? "F_LNNO " : "") + (0 != (this._flags & 0x200) ? "F_AR32W " : "") + (0 != (this._flags & 0x1000) ? "F_DYNLOAD " : "") + (0 != (this._flags & 0x2000) ? "F_SHROBJ " : "") + (0 != (this._flags & 0x4000) ? "F_LOADONLY " : "");
        properties.put("Flags", string);
        return properties;
    }

    @Override
    public IMemorySource getTextSegment(long l, long l2) {
        return new TextSegment(l, l2);
    }

    @Override
    public List<? extends ISymbol> getSymbols(long l) throws IOException {
        LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
        long l2 = this._symbolTableOffset();
        int n = this._numberOfSymbols();
        if (0L != l2) {
            this.seekFileRelative(l2 + (long)(18 * n));
            int n2 = this._backing.readInt();
            if (4 != n2 && 0 != n2) {
                byte[] byArray = new byte[n2 - 4];
                this._backing.readFully(byArray);
                this.seekFileRelative(l2);
                byte[] byArray2 = new byte[18];
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    this._backing.readFully(byArray2);
                    if (n3 > 0) {
                        --n3;
                        continue;
                    }
                    int n4 = 0;
                    String string = null;
                    if (this._is64Bit) {
                        n4 = (0xFF & byArray2[8]) << 24 | (0xFF & byArray2[9]) << 16 | (0xFF & byArray2[10]) << 8 | 0xFF & byArray2[11];
                    } else if (0 == byArray2[0] && 0 == byArray2[1] && 0 == byArray2[2] && 0 == byArray2[3]) {
                        n4 = (0xFF & byArray2[4]) << 24 | (0xFF & byArray2[5]) << 16 | (0xFF & byArray2[6]) << 8 | 0xFF & byArray2[7];
                    } else {
                        string = this._stringFromArray(byArray2, 0);
                    }
                    if (null == string && 0 == (byArray2[16] & 0x80) && 0 != n4 && n4 < n2 - 4) {
                        string = this._stringFromArray(byArray, n4 - 4);
                    } else if (0 == (byArray2[16] & 0x80) && n4 > n2 - 4) {
                        string = "(string out of table bounds)";
                    }
                    if (null == string) {
                        string = "";
                    }
                    long l3 = 0L;
                    l3 = this._is64Bit ? (0xFFL & (long)byArray2[0]) << 56 | (0xFFL & (long)byArray2[1]) << 48 | (0xFFL & (long)byArray2[2]) << 40 | (0xFFL & (long)byArray2[3]) << 32 | (0xFFL & (long)byArray2[4]) << 24 | (0xFFL & (long)byArray2[5]) << 16 | (0xFFL & (long)byArray2[6]) << 8 | 0xFFL & (long)byArray2[7] : (long)((0xFF & byArray2[8]) << 24 | (0xFF & byArray2[9]) << 16 | (0xFF & byArray2[10]) << 8 | 0xFF & byArray2[11]);
                    linkedList.add(new Symbol(string, l3 + l));
                    n3 = byArray2[17];
                }
            }
        }
        return linkedList;
    }

    public void close() throws IOException {
        if (this._backing != null) {
            this._backing.close();
        }
    }

    private class TextSegment
    extends ProtectedMemoryRange
    implements IMemorySource {
        public TextSegment(long l, long l2) {
            super(l, l2);
            this.readOnly = true;
            this.executable = true;
            this.shared = false;
        }

        @Override
        public String getName() {
            return ".text";
        }

        @Override
        public int getAddressSpaceId() {
            return 0;
        }

        @Override
        public int getBytes(long l, byte[] byArray, int n, int n2) throws MemoryFault {
            if (l < this.baseAddress) {
                throw new MemoryFault(l, "Address out of range. Segment starts at 0x" + Long.toHexString(this.baseAddress));
            }
            long l2 = l + (long)n2 - 1L;
            if (l2 > this.getTopAddress()) {
                throw new MemoryFault(l, "Address out of range (overflow). Top address is 0x" + Long.toHexString(this.getTopAddress()));
            }
            if (l2 - this.baseAddress > this.size) {
                throw new MemoryFault(l, "Address out of range (overflow). Top backed address is 0x" + Long.toHexString(this.baseAddress + this.size - 1L));
            }
            long l3 = l - this.baseAddress;
            try {
                XCOFFReader.this._backing.seek(XCOFFReader.this._startOffset + l3);
                XCOFFReader.this._backing.readFully(byArray, n, n2);
            }
            catch (IOException iOException) {
                throw new MemoryFault(l, "Memory fault caused by IOException reading file " + XCOFFReader.this._library);
            }
            return n2;
        }
    }
}

