/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.DelegatingMemorySource;
import com.ibm.j9ddr.corereaders.memory.IDetailedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemory;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemorySourceTable;
import com.ibm.j9ddr.corereaders.memory.SearchableMemory;
import com.ibm.j9ddr.util.WeakValueMap;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMemory
extends SearchableMemory
implements IMemory {
    static final Logger logger;
    private static final long MAXIMUM_CORE_FILE_CACHE_BYTES;
    private static final long DEFAULT_MAX_CORE_FILE_CACHE_BYTES = 0xA00000L;
    private static final String MAX_CORE_FILE_CACHE_SIZE_SYSTEM_PROPERTY = "ddr.max.core.data.cache.bytes";
    private static final String ENABLE_CACHE_STATS_SYSTEM_PROPERTY = "ddr.track.core.cache.stats";
    private static final long CACHE_BLOCK_SIZE = 1024L;
    private static final boolean GLOBAL_CACHE_ENABLED;
    static final boolean RECORDING_CACHE_STATS;
    private static long cacheHits;
    private static long cacheMisses;
    private static long bytesReadFromDisk;
    private static long bytesReadFromBlockCache;
    private static long purgedBlocks;
    private static long purgedBytes;
    private static long cacheByteHighWaterMark;
    private static final List<CacheBlock> keepAliveList;
    private static long cacheSize;
    private final ByteOrder byteOrder;
    protected final MemorySourceTable memorySources = new MemorySourceTable();
    protected final Map<IMemorySource, IMemorySource> decoratorMappingTable = new TreeMap<IMemorySource, IMemorySource>();

    protected AbstractMemory(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public byte getByteAt(long l) throws MemoryFault {
        byte[] byArray = new byte[1];
        this.getBytesAt(l, byArray);
        return byArray[0];
    }

    @Override
    public int getBytesAt(long l, byte[] byArray) throws MemoryFault {
        return this.getBytesAt(l, byArray, 0, byArray.length);
    }

    @Override
    public int getBytesAt(long l, byte[] byArray, int n, int n2) throws MemoryFault {
        IMemorySource iMemorySource = this.memorySources.getRangeForAddress(l);
        int n3 = 0;
        if (iMemorySource == null) {
            throw new MemoryFault(l);
        }
        long l2 = l + (long)n2 - 1L;
        if (iMemorySource.contains(l2)) {
            n3 = iMemorySource.getBytes(l, byArray, n, n2);
        } else {
            int n4 = n;
            long l3 = l;
            while (Addresses.lessThanOrEqual(l3, l2) && (iMemorySource.contains(l3) || null != (iMemorySource = this.memorySources.getRangeForAddress(l3)))) {
                long l4 = iMemorySource.getTopAddress();
                long l5 = Addresses.greaterThan(l4, l2) ? l2 - l3 + 1L : l4 - l3 + 1L;
                int n5 = iMemorySource.getBytes(l3, byArray, n4, (int)l5);
                n3 += n5;
                l3 += (long)n5;
                n4 += n5;
            }
        }
        return n3;
    }

    @Override
    public int getIntAt(long l) throws MemoryFault {
        byte[] byArray = new byte[4];
        this.getBytesAt(l, byArray);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (0xFF & byArray[3]) << 24 | (0xFF & byArray[2]) << 16 | (0xFF & byArray[1]) << 8 | 0xFF & byArray[0];
        }
        return (0xFF & byArray[0]) << 24 | (0xFF & byArray[1]) << 16 | (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
    }

    @Override
    public long getLongAt(long l) throws MemoryFault {
        byte[] byArray = new byte[8];
        this.getBytesAt(l, byArray);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return 0xFF00000000000000L & (long)byArray[7] << 56 | 0xFF000000000000L & (long)byArray[6] << 48 | 0xFF0000000000L & (long)byArray[5] << 40 | 0xFF00000000L & (long)byArray[4] << 32 | 0xFF000000L & (long)byArray[3] << 24 | 0xFF0000L & (long)byArray[2] << 16 | 0xFF00L & (long)byArray[1] << 8 | 0xFFL & (long)byArray[0];
        }
        return 0xFF00000000000000L & (long)byArray[0] << 56 | 0xFF000000000000L & (long)byArray[1] << 48 | 0xFF0000000000L & (long)byArray[2] << 40 | 0xFF00000000L & (long)byArray[3] << 32 | 0xFF000000L & (long)byArray[4] << 24 | 0xFF0000L & (long)byArray[5] << 16 | 0xFF00L & (long)byArray[6] << 8 | 0xFFL & (long)byArray[7];
    }

    @Override
    public short getShortAt(long l) throws MemoryFault {
        byte[] byArray = new byte[2];
        this.getBytesAt(l, byArray);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (short)((0xFF & byArray[1]) << 8 | 0xFF & byArray[0]);
        }
        return (short)((0xFF & byArray[0]) << 8 | 0xFF & byArray[1]);
    }

    public void addMemorySource(IMemorySource iMemorySource) {
        logger.logp(Level.FINEST, "AbstractMemory", "addMemorySource", "Added memory range {0}-{1}", new Object[]{Long.toHexString(iMemorySource.getBaseAddress()), Long.toHexString(iMemorySource.getTopAddress())});
        if (GLOBAL_CACHE_ENABLED) {
            CachingMemorySource cachingMemorySource = new CachingMemorySource(iMemorySource);
            this.decoratorMappingTable.put(iMemorySource, cachingMemorySource);
            this.memorySources.addMemorySource(cachingMemorySource);
        } else if (RECORDING_CACHE_STATS) {
            CountingMemorySource countingMemorySource = new CountingMemorySource(iMemorySource);
            this.decoratorMappingTable.put(iMemorySource, countingMemorySource);
            this.memorySources.addMemorySource(countingMemorySource);
        } else {
            this.memorySources.addMemorySource(iMemorySource);
        }
        this.rangeTable = null;
    }

    public void removeMemorySource(IMemorySource iMemorySource) {
        IMemorySource iMemorySource2 = this.decoratorMappingTable.remove(iMemorySource);
        if (iMemorySource2 != null) {
            this.memorySources.removeMemorySource(iMemorySource2);
        } else {
            this.memorySources.removeMemorySource(iMemorySource);
        }
        this.rangeTable = null;
    }

    public void addMemorySources(Collection<? extends IMemorySource> collection) {
        for (IMemorySource iMemorySource : collection) {
            this.addMemorySource(iMemorySource);
        }
    }

    public List<IMemoryRange> getMemoryRanges() {
        return this.memorySources.getMemorySources();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public boolean isShared(long l) {
        IMemorySource iMemorySource = this.memorySources.getRangeForAddress(l);
        if (iMemorySource == null) {
            return false;
        }
        return iMemorySource.isShared();
    }

    @Override
    public boolean isExecutable(long l) {
        IMemorySource iMemorySource = this.memorySources.getRangeForAddress(l);
        if (iMemorySource == null) {
            return false;
        }
        return iMemorySource.isExecutable();
    }

    @Override
    public boolean isReadOnly(long l) {
        IMemorySource iMemorySource = this.memorySources.getRangeForAddress(l);
        if (iMemorySource == null) {
            return false;
        }
        return iMemorySource.isReadOnly();
    }

    @Override
    public Properties getProperties(long l) {
        IMemorySource iMemorySource = this.memorySources.getRangeForAddress(l);
        if (iMemorySource != null && iMemorySource instanceof IDetailedMemoryRange) {
            return ((IDetailedMemoryRange)((Object)iMemorySource)).getProperties();
        }
        return new Properties();
    }

    static {
        long l;
        logger = Logger.getLogger("j9ddr.core_readers");
        cacheHits = 0L;
        cacheMisses = 0L;
        bytesReadFromDisk = 0L;
        bytesReadFromBlockCache = 0L;
        purgedBlocks = 0L;
        purgedBytes = 0L;
        cacheByteHighWaterMark = 0L;
        keepAliveList = new ArrayList<CacheBlock>();
        cacheSize = 0L;
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(AbstractMemory.MAX_CORE_FILE_CACHE_SIZE_SYSTEM_PROPERTY);
            }
        });
        logger.logp(Level.FINE, "AbstractMemory", "<clinit>", "System property value from {0} was {1}", new Object[]{MAX_CORE_FILE_CACHE_SIZE_SYSTEM_PROPERTY, string});
        if (string != null) {
            l = Long.parseLong(string);
            logger.logp(Level.FINE, "AbstractMemory", "<clinit>", "Max core memory cache size parsed as {0}", l);
        } else {
            l = 0xA00000L;
            logger.logp(Level.FINE, "AbstractMemory", "<clinit>", "Max core memory cache set to default: {0}", l);
        }
        MAXIMUM_CORE_FILE_CACHE_BYTES = l;
        if (l <= 0L) {
            GLOBAL_CACHE_ENABLED = false;
            logger.logp(Level.FINE, "AbstractMemory", "<clinit>", "Disabled core memory caching");
        } else {
            GLOBAL_CACHE_ENABLED = true;
        }
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(AbstractMemory.ENABLE_CACHE_STATS_SYSTEM_PROPERTY);
            }
        });
        if (string2 != null && string2.toLowerCase().equals("true")) {
            Runtime.getRuntime().addShutdownHook(new Thread(new CacheStatsReporter()));
            RECORDING_CACHE_STATS = true;
            logger.logp(Level.FINE, "AbstractMemory", "<clinit>", "Cache stats enabled");
        } else {
            RECORDING_CACHE_STATS = false;
        }
    }

    private static class CacheStatsReporter
    implements Runnable {
        private CacheStatsReporter() {
        }

        @Override
        public void run() {
            System.err.println("**DDR Core Reader Cache Stats**");
            System.err.println("Global cache enabled: " + GLOBAL_CACHE_ENABLED);
            System.err.println("Cache hits: " + cacheHits);
            System.err.println("Cache misses: " + cacheMisses);
            double d = (double)cacheHits / (double)(cacheHits + cacheMisses) * 100.0;
            System.err.println("Cache hit rate: " + d);
            System.err.println("Bytes read from disk: " + bytesReadFromDisk);
            System.err.println("Bytes read from cache: " + bytesReadFromBlockCache);
            System.err.println("Purged blocks: " + purgedBlocks);
            System.err.println("Purged bytes: " + purgedBytes);
            System.err.println("Cache bytes high water mark: " + cacheByteHighWaterMark);
            System.err.println("TLB Cache hits: " + MemorySourceTable.tlbCacheHits);
            System.err.println("TLB Cache misses: " + MemorySourceTable.tlbCacheMisses);
            double d2 = (double)MemorySourceTable.tlbCacheHits / (double)(MemorySourceTable.tlbCacheHits + MemorySourceTable.tlbCacheMisses) * 100.0;
            System.err.println("TLB Cache hit rate: " + d2);
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "DDR Core Reader Cache Stats");
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "Global cache enabled: {0}", GLOBAL_CACHE_ENABLED);
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "Cache hits: {0}, cache misses: {1}, cache hit rate: {2}", new Object[]{cacheHits, cacheMisses, d});
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "Bytes read from disk: {0}, from cache: {1}, purged blocks: {2}, purged bytes: {3}", new Object[]{bytesReadFromDisk, bytesReadFromBlockCache, purgedBlocks, purgedBytes});
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "Cache bytes high water mark {0}", new Object[]{cacheByteHighWaterMark});
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "TLB Cache hits: {0}, misses: {1}, hit rate:{2}", new Object[]{MemorySourceTable.tlbCacheHits, MemorySourceTable.tlbCacheMisses, d2});
        }
    }

    private static class CountingMemorySource
    extends DelegatingMemorySource {
        public CountingMemorySource(IMemorySource iMemorySource) {
            super(iMemorySource);
        }

        @Override
        public int getBytes(long l, byte[] byArray, int n, int n2) throws MemoryFault {
            int n3 = super.getBytes(l, byArray, n, n2);
            cacheMisses++;
            bytesReadFromDisk = bytesReadFromDisk + (long)n3;
            return n3;
        }
    }

    private static final class CachingMemorySource
    extends DelegatingMemorySource {
        private final boolean singleBlockRange;
        private final WeakValueMap<Integer, CacheBlock> blockMap;
        private Reference<CacheBlock> singleBlockRef;

        public CachingMemorySource(IMemorySource iMemorySource) {
            super(iMemorySource);
            if (this.delegate.getSize() <= 1024L) {
                this.singleBlockRange = true;
                this.blockMap = null;
            } else {
                this.singleBlockRange = false;
                this.blockMap = new WeakValueMap();
            }
        }

        @Override
        public int getBytes(long l, byte[] byArray, int n, int n2) throws MemoryFault {
            int n3;
            if (this.singleBlockRange) {
                CacheBlock cacheBlock;
                boolean bl = false;
                if (this.singleBlockRef == null || (cacheBlock = this.singleBlockRef.get()) == null) {
                    if (RECORDING_CACHE_STATS) {
                        bl = true;
                    }
                    cacheBlock = this.loadBlock(this.getBaseAddress(), l, (int)this.getSize());
                    this.singleBlockRef = new WeakReference<CacheBlock>(cacheBlock);
                } else if (RECORDING_CACHE_STATS) {
                    bl = false;
                }
                System.arraycopy(cacheBlock.buffer, (int)(l - this.delegate.getBaseAddress()), byArray, n, n2);
                if (RECORDING_CACHE_STATS) {
                    if (bl) {
                        cacheHits++;
                        bytesReadFromBlockCache = bytesReadFromBlockCache + (long)n2;
                    } else {
                        cacheMisses++;
                    }
                }
                return n2;
            }
            int n4 = 0;
            int n5 = n;
            while ((n3 = n2 - n4) > 0) {
                long l2;
                long l3;
                long l4 = l - this.getBaseAddress();
                int n6 = (int)(l4 / 1024L);
                long l5 = this.delegate.getBaseAddress() + 1024L * (long)n6;
                long l6 = this.delegate.getTopAddress() - l5 + 1L;
                int n7 = (int)(l6 > 1024L ? 1024L : l6);
                boolean bl = false;
                CacheBlock cacheBlock = this.blockMap.get(n6);
                if (RECORDING_CACHE_STATS) {
                    boolean bl2 = bl = cacheBlock != null;
                }
                if (cacheBlock == null) {
                    cacheBlock = this.loadBlock(l5, l, n7);
                    this.blockMap.put(n6, cacheBlock);
                }
                long l7 = (l3 = (long)n7 - (l2 = l - l5)) > (long)n3 ? (long)n3 : l3;
                System.arraycopy(cacheBlock.buffer, (int)l2, byArray, n5, (int)l7);
                if (RECORDING_CACHE_STATS) {
                    if (bl) {
                        cacheHits++;
                        bytesReadFromBlockCache = bytesReadFromBlockCache + l7;
                    } else {
                        cacheMisses++;
                    }
                }
                l += l7;
                n4 = (int)((long)n4 + l7);
                n5 = (int)((long)n5 + l7);
            }
            return n4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CacheBlock loadBlock(long l, long l2, int n) throws MemoryFault {
            byte[] byArray = new byte[n];
            if (this.delegate.isBacked()) {
                try {
                    this.delegate.getBytes(l, byArray, 0, n);
                }
                catch (MemoryFault memoryFault) {
                    throw new MemoryFault(l2, "MemoryFault loading cache block", memoryFault);
                }
            } else {
                throw new MemoryFault(l2, "MemoryFault loading cache block, unbacked memory");
            }
            if (RECORDING_CACHE_STATS) {
                bytesReadFromDisk = bytesReadFromDisk + (long)n;
            }
            CacheBlock cacheBlock = new CacheBlock(byArray);
            List list = keepAliveList;
            synchronized (list) {
                cacheSize = cacheSize + (long)n;
                if (cacheSize > MAXIMUM_CORE_FILE_CACHE_BYTES) {
                    CachingMemorySource.trimCache();
                }
                if (RECORDING_CACHE_STATS && cacheSize > cacheByteHighWaterMark) {
                    cacheByteHighWaterMark = cacheSize;
                }
                keepAliveList.add(cacheBlock);
            }
            return cacheBlock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void trimCache() {
            List list = keepAliveList;
            synchronized (list) {
                while (cacheSize > MAXIMUM_CORE_FILE_CACHE_BYTES && keepAliveList.size() > 0) {
                    CacheBlock cacheBlock = (CacheBlock)keepAliveList.remove(0);
                    cacheSize = cacheSize - (long)cacheBlock.buffer.length;
                    if (!RECORDING_CACHE_STATS) continue;
                    purgedBlocks++;
                    purgedBytes = purgedBytes + (long)cacheBlock.buffer.length;
                }
            }
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.blockMap == null ? 0 : this.blockMap.hashCode());
            n = 31 * n + (this.singleBlockRange ? 1231 : 1237);
            n = 31 * n + (this.singleBlockRef == null ? 0 : this.singleBlockRef.hashCode());
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (!(object instanceof CachingMemorySource)) {
                return false;
            }
            CachingMemorySource cachingMemorySource = (CachingMemorySource)object;
            if (this.blockMap == null ? cachingMemorySource.blockMap != null : !this.blockMap.equals(cachingMemorySource.blockMap)) {
                return false;
            }
            if (this.singleBlockRange != cachingMemorySource.singleBlockRange) {
                return false;
            }
            return !(this.singleBlockRef == null ? cachingMemorySource.singleBlockRef != null : !this.singleBlockRef.equals(cachingMemorySource.singleBlockRef));
        }
    }

    static class CacheBlock {
        public final byte[] buffer;

        public CacheBlock(byte[] byArray) {
            this.buffer = byArray;
        }
    }
}

