/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump.unwind;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindCode;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindModule;

public class UnwindInfo {
    private static final int FLAGS_CHAINED = 4;
    private long address;
    private UnwindModule module;
    private IAddressSpace process;
    private static final int OFFSET_VERSION = 0;
    private static final int OFFSET_FLAGS = 0;
    private static final int OFFSET_SIZEOFPROLOG = 1;
    private static final int OFFSET_COUNTOFCODES = 2;
    private static final int OFFSET_FRAMEREGISTER = 3;
    private static final int OFFSET_FRAMEOFFSET = 3;
    private static final int OFFSET_UNWINDCODE = 4;

    public UnwindInfo(IAddressSpace iAddressSpace, UnwindModule unwindModule, long l) throws CorruptDataException {
        this.address = l;
        this.module = unwindModule;
        this.process = iAddressSpace;
        byte by = this.getVersion();
        if (by != 1) {
            throw new CorruptDataException(String.format("Incorrect version number %d in UNWIND_INFO at 0x%08x", by, l));
        }
    }

    private byte getVersion() throws MemoryFault {
        byte by = (byte)(this.process.getByteAt(0L + this.module.getLoadAddress() + this.address) & 7);
        return by;
    }

    private byte getFlags() throws MemoryFault {
        byte by = (byte)(this.process.getByteAt(0L + this.module.getLoadAddress() + this.address) >> 3 & 0x1F);
        return by;
    }

    private byte getPrologSize() throws MemoryFault {
        byte by = this.process.getByteAt(1L + this.module.getLoadAddress() + this.address);
        return by;
    }

    private byte getCountOfCodes() throws MemoryFault {
        byte by = this.process.getByteAt(2L + this.module.getLoadAddress() + this.address);
        return by;
    }

    public String toString() {
        String string = "";
        try {
            byte by = this.getVersion();
            byte by2 = this.getFlags();
            byte by3 = this.getPrologSize();
            byte by4 = this.getCountOfCodes();
            string = string + String.format("Version: 0x%x, flags 0x%x, SizeOfProlog 0x%02x, CountOfCodes %d", by, by2, by3, by4);
            long l = 4L + this.address;
            byte by5 = 0;
            while (by5 < by4) {
                UnwindCode unwindCode = new UnwindCode(this.process, this.module, this, l);
                string = string + "\n\t";
                string = string + unwindCode.toString();
                by5 = (byte)(by5 + unwindCode.getNodeCount());
                l += (long)(2 * unwindCode.getNodeCount());
            }
            return string;
        }
        catch (MemoryFault memoryFault) {
            return "Error getting UnwindInfo " + memoryFault.toString();
        }
        catch (CorruptDataException corruptDataException) {
            return "Error getting UnwindInfo " + corruptDataException.toString();
        }
    }

    public long apply(long l) throws CorruptDataException {
        byte by = this.getVersion();
        if (by != 1) {
            throw new CorruptDataException("Invalid version " + by + " in UNWIND_INFO expected 1");
        }
        byte by2 = this.getFlags();
        byte by3 = this.getPrologSize();
        byte by4 = this.getCountOfCodes();
        if (by4 != 0) {
            long l2 = 4L + this.address;
            byte by5 = 0;
            while (by5 < by4) {
                UnwindCode unwindCode = new UnwindCode(this.process, this.module, this, l2);
                l = unwindCode.getNewSP(l);
                by5 = (byte)(by5 + unwindCode.getNodeCount());
                l2 += (long)(2 * unwindCode.getNodeCount());
            }
        }
        if ((by2 & 4) == 4) {
            UnwindInfo unwindInfo = this.getChainedUnwindInfo();
            l = unwindInfo.apply(l);
        }
        return l;
    }

    private UnwindInfo getChainedUnwindInfo() throws CorruptDataException {
        long l = this.process.getIntAt(this.module.getLoadAddress() + this.address + 4L + (long)(this.getCountOfCodes() * 2) + 8L);
        UnwindInfo unwindInfo = new UnwindInfo(this.process, this.module, l);
        return unwindInfo;
    }
}

