/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import com.ibm.dtfj.corereaders.NewElfDump;
import com.ibm.j9ddr.libraries.LibraryAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class DTFJLibraryAdapter
implements Builder,
LibraryAdapter {
    private static final Logger logger = Logger.getLogger("com.ibm.j9ddr.libraries");
    private File _parentDir;
    private ArrayList<String> moduleNames = null;
    private final ArrayList<String> errorMessages = new ArrayList();
    private boolean isAIX = false;

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                System.out.println("Reading \"" + file.getAbsolutePath() + "\"...");
                DTFJLibraryAdapter dTFJLibraryAdapter = new DTFJLibraryAdapter();
                ArrayList<String> arrayList = dTFJLibraryAdapter.getLibraryList(file);
                for (String string : arrayList) {
                    System.out.println("\t" + string);
                }
            }
        } else {
            System.out.println("Usage:  \"LibraryAdapter <core files> ...\"");
            System.exit(1);
        }
    }

    @Override
    public boolean isLibraryCollectionRequired(File file) {
        ICoreFileReader iCoreFileReader = null;
        try {
            ClosingFileReader closingFileReader = new ClosingFileReader(file);
            iCoreFileReader = DumpFactory.createDumpForCore((ImageInputStream)closingFileReader);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Could not determine if library collection is required for " + file.getAbsolutePath(), exception);
            this.errorMessages.add(exception.getMessage());
            return false;
        }
        if (iCoreFileReader instanceof NewElfDump) {
            return true;
        }
        return iCoreFileReader instanceof NewAixDump;
    }

    @Override
    public ArrayList<String> getLibraryList(File file) {
        if (this.moduleNames == null) {
            this.moduleNames = new ArrayList();
            try {
                this._parentDir = file.getParentFile();
                logger.fine("Creating DTFJ core file reader");
                ClosingFileReader closingFileReader = new ClosingFileReader(file);
                ICoreFileReader iCoreFileReader = DumpFactory.createDumpForCore((ImageInputStream)closingFileReader);
                this.isAIX = iCoreFileReader instanceof NewAixDump;
                logger.fine("Extracting modules");
                iCoreFileReader.extract((Builder)this);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.log(Level.SEVERE, "Could not open core file " + file.getAbsolutePath(), fileNotFoundException);
                this.errorMessages.add(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Error processing core file " + file.getAbsolutePath(), iOException);
                this.errorMessages.add(iOException.getMessage());
            }
        }
        return this.moduleNames;
    }

    @Override
    public ArrayList<String> getErrorMessages() {
        return this.errorMessages;
    }

    public ClosingFileReader openFile(String string) throws IOException {
        ClosingFileReader closingFileReader = null;
        File file = new File(string);
        String string2 = file.getName();
        File file2 = new File(this._parentDir, string2);
        closingFileReader = file2.exists() ? new ClosingFileReader(file2) : new ClosingFileReader(file);
        return closingFileReader;
    }

    public Object buildModule(String string, Properties properties, Iterator iterator, Iterator iterator2, long l) {
        logger.fine("Module : " + string);
        if (this.isAIX) {
            int n = string.indexOf(".a(");
            if (n != -1 && string.lastIndexOf(41) == string.length() - 1) {
                this.moduleNames.add(string.substring(0, n + 2));
            } else {
                this.moduleNames.add(string);
            }
        } else {
            this.moduleNames.add(string);
        }
        return null;
    }

    public Object buildProcess(Object object, String string, String string2, Properties properties, Object object2, Iterator iterator, Object object3, Iterator iterator2, int n) {
        if (logger.isLoggable(Level.FINEST)) {
            String string3 = String.format("Building process %s : %s", string, string2);
            logger.finest(string3);
        }
        return null;
    }

    public Object buildAddressSpace(String string, int n) {
        if (logger.isLoggable(Level.FINEST)) {
            String string2 = String.format("Building address space %s[%d]", string, n);
            logger.finest(string2);
        }
        return null;
    }

    public Object buildRegister(String string, Number number) {
        return null;
    }

    public Object buildStackSection(Object object, long l, long l2) {
        return null;
    }

    public Object buildThread(String string, Iterator iterator, Iterator iterator2, Iterator iterator3, Properties properties, int n) {
        if (logger.isLoggable(Level.FINEST)) {
            String string2 = String.format("Building thread %s [signal %d]", string, n);
            logger.finest(string2);
        }
        return null;
    }

    public Object buildModuleSection(Object object, String string, long l, long l2) {
        if (logger.isLoggable(Level.FINEST)) {
            String string2 = String.format("Building module %s [0x%s - 0x%s]", string, Long.toHexString(l), Long.toHexString(l2));
            logger.finest(string2);
        }
        return null;
    }

    public Object buildStackFrame(Object object, long l, long l2) {
        return null;
    }

    public Object buildSymbol(Object object, String string, long l) {
        return null;
    }

    public Object buildCorruptData(Object object, String string, long l) {
        return null;
    }

    public long getEnvironmentAddress() {
        return 0L;
    }

    public long getValueOfNamedRegister(List list, String string) {
        return 0L;
    }

    public void setExecutableUnavailable(String string) {
        this.errorMessages.add("Library collection not possible as the executable cannot be found [" + string + "]");
        if (logger.isLoggable(Level.FINEST)) {
            String string2 = String.format("Executable not available : %s", string);
            logger.warning(string2);
        }
    }

    public void setOSType(String string) {
        if (logger.isLoggable(Level.FINEST)) {
            String string2 = String.format("OS Type : %s", string);
            logger.finest(string2);
        }
    }

    public void setCPUType(String string) {
    }

    public void setCPUSubType(String string) {
    }

    public void setCreationTime(long l) {
    }

    public Object buildModule(String string, Properties properties, Iterator iterator, Iterator iterator2) {
        if (logger.isLoggable(Level.FINEST)) {
            String string2 = String.format("Building module %s", string);
            logger.finest(string2);
        }
        return null;
    }
}

