/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.J9DDRClassLoader;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.DDRInteractiveClassLoader;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.PluginConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MissingVMData
implements IVMData {
    private final Logger logger = Logger.getLogger("j9ddr.interactive.context");

    @Override
    public void bootstrap(String string, Object ... objectArray) throws ClassNotFoundException {
    }

    @Override
    public void bootstrapRelative(String string, Object ... objectArray) throws ClassNotFoundException {
        if (string.equals("tools.ddrinteractive.FindVMTask")) {
            long[] lArray = (long[])objectArray[0];
            lArray[0] = 0L;
            return;
        }
        if (string.equals("tools.ddrinteractive.GetCommandsTask")) {
            Object[] objectArray2 = (Object[])objectArray[0];
            Object object = objectArray2[1];
            LinkedList<ICommand> linkedList = new LinkedList<ICommand>();
            this.loadPlugins(linkedList, object);
            objectArray2[0] = linkedList;
            return;
        }
        throw new ClassNotFoundException("The bootstrap relative class " + string + " was not recognised");
    }

    private void loadPlugins(List<ICommand> list, Object object) {
        if (!(object instanceof DDRInteractiveClassLoader)) {
            this.logger.fine("Plugin classloader is not an instance of DRRInteractiveClassLoader. No plugins have been loaded");
            return;
        }
        DDRInteractiveClassLoader dDRInteractiveClassLoader = (DDRInteractiveClassLoader)object;
        for (PluginConfig pluginConfig : dDRInteractiveClassLoader.getPlugins()) {
            try {
                ICommand iCommand = pluginConfig.newInstance();
                list.add(iCommand);
            }
            catch (Throwable throwable) {
                this.logger.log(Level.WARNING, "Failed to create an instance of " + pluginConfig.getId(), throwable);
            }
        }
    }

    @Override
    public Collection<StructureReader.StructureDescriptor> getStructures() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public J9DDRClassLoader getClassLoader() {
        return null;
    }

    @Override
    public String getVersion() {
        return "Missing VM";
    }
}

