/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NoSuchFieldException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;

public class GpInfoCommand
extends Command {
    public GpInfoCommand() {
        this.addCommand("gpinfo", "", "print out info about a gpf if one occured");
    }

    @Override
    public Collection<String> getCommandDescriptions() {
        return Collections.singleton("gpinfo                         - print out info about a gpf if one occured");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        long l = context.vmAddress;
        try {
            long l2 = CommandUtils.followPointerFromStructure(context, "J9JavaVM", l, "j9ras");
            long l3 = CommandUtils.followPointerFromStructure(context, "J9RAS", l2, "crashInfo");
            if (l3 != 0L) {
                long l4 = CommandUtils.followPointerFromStructure(context, "J9RASCrashInfo", l3, "failingThread");
                long l5 = CommandUtils.followPointerFromStructure(context, "J9RASCrashInfo", l3, "failingThreadID");
                long l6 = CommandUtils.followPointerFromStructure(context, "J9RASCrashInfo", l3, "gpInfo");
                printStream.println("Failing Thread: !j9vmthread 0x" + Long.toHexString(l4));
                printStream.println("Failing Thread ID: 0x" + Long.toHexString(l5) + " (" + l5 + ")");
                printStream.println("gpInfo:");
                printStream.println(CommandUtils.getCStringAtAddress(context.process, l6));
            } else {
                printStream.println("Core does not appear to have been triggered by a gpf. No J9RASCrashInfo found.");
            }
        }
        catch (MemoryFault memoryFault) {
            throw new DDRInteractiveCommandException(memoryFault);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new DDRInteractiveCommandException(noSuchFieldException);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

