/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class NativeStacksCommand
extends Command {
    public NativeStacksCommand() {
        this.addCommand("nativestacks", "[tid] [tid] ...", "Display the native stacks for all or the specified thread ids.");
        this.addCommand("nstack", "[tid] [tid] ...", "Display the native stacks for all or the specified thread ids.");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        HashSet<Long> hashSet = null;
        for (String string2 : stringArray) {
            if (hashSet == null) {
                hashSet = new HashSet<Long>();
            }
            Long l = CommandUtils.parseNumber(string2).longValue();
            hashSet.add(l);
        }
        try {
            Collection<? extends IOSThread> collection = context.process.getThreads();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                IOSThread iOSThread = (IOSThread)iterator.next();
                if (hashSet != null && !hashSet.contains(iOSThread.getThreadId())) continue;
                try {
                    printStream.printf("Thread id: %d (0x%X)\n", iOSThread.getThreadId(), iOSThread.getThreadId());
                    int n = 0;
                    if (hashSet != null) {
                        hashSet.remove(iOSThread.getThreadId());
                    }
                    for (IOSStackFrame iOSStackFrame : iOSThread.getStackFrames()) {
                        String string3 = context.process.getProcedureNameForAddress(iOSStackFrame.getInstructionPointer());
                        if (context.process.bytesPerPointer() == 8) {
                            printStream.printf("#%d bp:0x%016X ip:0x%016X %s\n", n++, iOSStackFrame.getBasePointer(), iOSStackFrame.getInstructionPointer(), string3);
                            continue;
                        }
                        printStream.printf("#%d bp:0x%08X ip:0x%08X %s\n", n++, iOSStackFrame.getBasePointer(), iOSStackFrame.getInstructionPointer(), string3);
                    }
                }
                catch (DataUnavailableException dataUnavailableException) {
                    printStream.printf("DataUnavailableException reading stack for thread %d\n", iOSThread.getThreadId());
                }
                catch (CorruptDataException corruptDataException) {
                    printStream.printf("CorruptDataException reading stack for thread %d\n", iOSThread.getThreadId());
                }
                printStream.println("----------");
            }
            if (hashSet != null && !hashSet.isEmpty()) {
                printStream.print("Unable to find native thread for id(s): ");
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    printStream.print(l);
                }
                printStream.println();
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

