/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class J9DDRImageAddressSpace
implements ImageAddressSpace {
    private final IAddressSpace as;

    public J9DDRImageAddressSpace(IAddressSpace iAddressSpace) {
        this.as = iAddressSpace;
    }

    public IAddressSpace getIAddressSpace() {
        return this.as;
    }

    public ByteOrder getByteOrder() {
        return this.as.getByteOrder();
    }

    public J9DDRImageProcess getCurrentProcess() {
        Iterator<J9DDRImageProcess> iterator = this.getProcesses();
        J9DDRImageProcess j9DDRImageProcess = null;
        while (iterator.hasNext()) {
            J9DDRImageProcess j9DDRImageProcess2 = iterator.next();
            try {
                if (j9DDRImageProcess2.isFailingProcess()) {
                    return j9DDRImageProcess2;
                }
            }
            catch (DataUnavailableException dataUnavailableException) {
                // empty catch block
            }
            if (j9DDRImageProcess != null) continue;
            j9DDRImageProcess = j9DDRImageProcess2;
        }
        return j9DDRImageProcess;
    }

    public Iterator<?> getImageSections() {
        Collection<? extends IMemoryRange> collection = this.as.getMemoryRanges();
        ArrayList<J9DDRImageSection> arrayList = new ArrayList<J9DDRImageSection>(collection.size());
        IProcess iProcess = this.getPointerProcess();
        if (null == iProcess) {
            return J9DDRDTFJUtils.emptyIterator();
        }
        for (IMemoryRange iMemoryRange : collection) {
            J9DDRImageSection j9DDRImageSection = new J9DDRImageSection(iProcess, iMemoryRange.getBaseAddress(), iMemoryRange.getSize(), iMemoryRange.getName());
            arrayList.add(j9DDRImageSection);
        }
        return arrayList.iterator();
    }

    public ImagePointer getPointer(long l) {
        return new J9DDRImagePointer(this.getPointerProcess(), l);
    }

    private IProcess getPointerProcess() {
        Iterator<? extends IProcess> iterator = this.as.getProcesses().iterator();
        IProcess iProcess = null;
        while (iterator.hasNext()) {
            iProcess = iterator.next();
            if (iProcess.bytesPerPointer() != 8) continue;
            return iProcess;
        }
        return iProcess;
    }

    public Iterator<J9DDRImageProcess> getProcesses() {
        Collection<? extends IProcess> collection = this.as.getProcesses();
        LinkedList<J9DDRImageProcess> linkedList = new LinkedList<J9DDRImageProcess>();
        for (IProcess iProcess : collection) {
            linkedList.add(new J9DDRImageProcess(iProcess));
        }
        return linkedList.iterator();
    }

    public String getID() {
        return "0x" + Long.toHexString(this.as.getAddressSpaceId());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof J9DDRImageAddressSpace)) {
            return false;
        }
        J9DDRImageAddressSpace j9DDRImageAddressSpace = (J9DDRImageAddressSpace)object;
        return this.as.equals(j9DDRImageAddressSpace.as);
    }

    public int hashCode() {
        return this.as.getAddressSpaceId();
    }

    public String toString() {
        return "AddressSpace id 0x" + Integer.toHexString(this.as.getAddressSpaceId());
    }

    public Properties getProperties() {
        return new Properties();
    }
}

