/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.java.helper;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import java.util.Iterator;

public class DTFJJavaRuntimeHelper {
    private static long totalSizeOfAllHeaps = -1L;

    public static long getTotalHeapSize(JavaRuntime javaRuntime, IProcess iProcess) throws CorruptDataException {
        if (totalSizeOfAllHeaps > 0L) {
            return totalSizeOfAllHeaps;
        }
        if (javaRuntime == null) {
            throw new CorruptDataException((CorruptData)J9DDRDTFJUtils.newCorruptData(iProcess, "No Java Runtime present"));
        }
        Iterator iterator = javaRuntime.getHeaps();
        while (iterator.hasNext()) {
            Iterator iterator2;
            Object e = iterator.next();
            if (e instanceof JavaHeap) {
                iterator2 = ((JavaHeap)e).getSections();
            } else {
                throw new CorruptDataException((CorruptData)J9DDRDTFJUtils.newCorruptData(iProcess, "Corrupt heap encountered whilst calculating total heap size"));
            }
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (e2 instanceof ImageSection) {
                    long l = ((ImageSection)e2).getSize();
                    if (Long.MAX_VALUE - l > totalSizeOfAllHeaps) {
                        totalSizeOfAllHeaps += l;
                        continue;
                    }
                    return Long.MAX_VALUE;
                }
                throw new CorruptDataException((CorruptData)J9DDRDTFJUtils.newCorruptData(iProcess, "Corrupt section encountered whilst calculating total heap size"));
            }
        }
        return totalSizeOfAllHeaps;
    }
}

