/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.AVLTree;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.IAVLSearchComparator;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9AVLTreeNodePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9AVLTreePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm29.structure.J9HashtableConstants;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.NoSuchElementException;

public class HashTable_V1<StructType extends AbstractPointer>
extends HashTable<StructType> {
    private static final long AVL_TREE_TAG_BIT = J9HashtableConstants.J9HASH_TABLE_AVL_TREE_TAG_BIT;
    private boolean _isInline = false;
    private AVLTreeComparatorFunction _avlTreeComparatorFunction;
    private EqualFunctionWrapper _equalFunctionWrapper;
    private boolean _isSpaceOpt;

    protected HashTable_V1(J9HashTablePointer j9HashTablePointer, boolean bl, Class<StructType> clazz, HashTable.HashEqualFunction<StructType> hashEqualFunction, HashTable.HashFunction<StructType> hashFunction) throws CorruptDataException {
        super(j9HashTablePointer, clazz, hashEqualFunction, hashFunction, null);
        this._equalFunctionWrapper = new EqualFunctionWrapper();
        this._isInline = bl;
        this._isSpaceOpt = this._table.listNodePool().isNull();
    }

    protected HashTable_V1(J9HashTablePointer j9HashTablePointer, boolean bl, Class<StructType> clazz, HashTable.HashFunction<StructType> hashFunction, HashTable.HashComparatorFunction<StructType> hashComparatorFunction) throws CorruptDataException {
        super(j9HashTablePointer, clazz, null, hashFunction, hashComparatorFunction);
        this._avlTreeComparatorFunction = new AVLTreeComparatorFunction();
        this._equalFunctionWrapper = new EqualFunctionFromComparator();
        this._isInline = bl;
        this._isSpaceOpt = this._table.listNodePool().isNull();
    }

    private VoidPointer avlNodeToData(J9AVLTreeNodePointer j9AVLTreeNodePointer) {
        return VoidPointer.cast(j9AVLTreeNodePointer.add(1L));
    }

    private J9AVLTreePointer avlTreeUntag(VoidPointer voidPointer) {
        return J9AVLTreePointer.cast(voidPointer.untag(AVL_TREE_TAG_BIT));
    }

    private PointerPointer nextEA(VoidPointer voidPointer) throws CorruptDataException {
        return PointerPointer.cast(voidPointer.addOffset(this._table.listNodeSize()).subOffset(UDATA.SIZEOF));
    }

    private boolean isAVLTreeTagged(VoidPointer voidPointer) {
        return voidPointer.allBitsIn(AVL_TREE_TAG_BIT);
    }

    public boolean isSpaceOpt() {
        return this._isSpaceOpt;
    }

    @Override
    public String getTableName() {
        try {
            return this._table.tableName().getCStringAtOffset(0L);
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting name", corruptDataException, true);
            return null;
        }
    }

    @Override
    public long getCount() {
        try {
            return this._table.numberOfNodes().longValue();
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting table count", corruptDataException, true);
            return 0L;
        }
    }

    @Override
    public StructType find(StructType StructType) throws CorruptDataException {
        AbstractPointer abstractPointer;
        UDATA uDATA = this._hashFn.hash(StructType).mod(this._table.tableSize());
        PointerPointer pointerPointer = this._table.nodes().add(uDATA);
        VoidPointer voidPointer = VoidPointer.NULL;
        voidPointer = this._table.listNodePool().isNull() ? ((abstractPointer = this.hashTableFindNodeSpaceOpt(this._table, StructType, pointerPointer)).at(0L).notNull() ? VoidPointer.cast(abstractPointer) : VoidPointer.NULL) : (pointerPointer.at(0L).isNull() ? VoidPointer.NULL : (this.isAVLTreeTagged(pointerPointer.at(0L)) ? this.hashTableFindNodeInTree(this._table, StructType, pointerPointer) : this.hashTableFindNodeInList(this._table, StructType, pointerPointer)));
        if (!this._isInline && voidPointer.notNull()) {
            voidPointer = PointerPointer.cast(voidPointer).at(0L);
        }
        abstractPointer = (AbstractPointer)DataType.getStructure(this._structType, voidPointer.getAddress());
        return (StructType)abstractPointer;
    }

    private PointerPointer hashTableFindNodeSpaceOpt(J9HashTablePointer j9HashTablePointer, StructType StructType, PointerPointer pointerPointer) throws CorruptDataException {
        PointerPointer pointerPointer2 = pointerPointer;
        AbstractPointer abstractPointer = (AbstractPointer)DataType.getStructure(this._structType, pointerPointer2.getAddress());
        while (pointerPointer2.at(0L).notNull() && !this._equalFunctionWrapper.equal(abstractPointer, StructType)) {
            if ((pointerPointer2 = pointerPointer2.add(1L)) == j9HashTablePointer.nodes().add(j9HashTablePointer.tableSize())) {
                pointerPointer2 = j9HashTablePointer.nodes();
            }
            abstractPointer = (AbstractPointer)DataType.getStructure(this._structType, pointerPointer2.getAddress());
        }
        return pointerPointer2;
    }

    private VoidPointer hashTableFindNodeInTree(J9HashTablePointer j9HashTablePointer, StructType StructType, PointerPointer pointerPointer) throws CorruptDataException {
        J9AVLTreePointer j9AVLTreePointer = this.avlTreeUntag(pointerPointer.at(0L));
        AVLTree aVLTree = AVLTree.fromJ9AVLTreePointer(j9AVLTreePointer, this._avlTreeComparatorFunction);
        J9AVLTreeNodePointer j9AVLTreeNodePointer = aVLTree.search(UDATA.cast(StructType));
        if (j9AVLTreeNodePointer.notNull()) {
            return this.avlNodeToData(j9AVLTreeNodePointer);
        }
        return VoidPointer.NULL;
    }

    private VoidPointer hashTableFindNodeInList(J9HashTablePointer j9HashTablePointer, StructType StructType, PointerPointer pointerPointer) throws CorruptDataException {
        VoidPointer voidPointer = pointerPointer.at(0L);
        AbstractPointer abstractPointer = (AbstractPointer)DataType.getStructure(this._structType, voidPointer.getAddress());
        while (!voidPointer.isNull() && !this._equalFunctionWrapper.equal(abstractPointer, StructType)) {
            voidPointer = this.nextEA(voidPointer).at(0L);
            abstractPointer = (AbstractPointer)DataType.getStructure(this._structType, voidPointer.getAddress());
        }
        return VoidPointer.cast(abstractPointer);
    }

    @Override
    public SlotIterator<StructType> iterator() {
        return new HashTableSlotIterator();
    }

    private class AVLTreeComparatorFunction
    implements IAVLSearchComparator {
        private AVLTreeComparatorFunction() {
        }

        @Override
        public int searchComparator(J9AVLTreePointer j9AVLTreePointer, UDATA uDATA, J9AVLTreeNodePointer j9AVLTreeNodePointer) throws CorruptDataException {
            VoidPointer voidPointer = HashTable_V1.this.avlNodeToData(j9AVLTreeNodePointer);
            AbstractPointer abstractPointer = (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType, uDATA.longValue());
            AbstractPointer abstractPointer2 = null;
            abstractPointer2 = HashTable_V1.this._isInline ? (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType, voidPointer.longValue()) : (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType, PointerPointer.cast(voidPointer).at(0L).longValue());
            return HashTable_V1.this._comparatorFn.compare(abstractPointer, abstractPointer2);
        }
    }

    private class EqualFunctionFromComparator
    extends EqualFunctionWrapper {
        private EqualFunctionFromComparator() {
        }

        @Override
        public boolean equal(StructType object, StructType StructType) throws CorruptDataException {
            if (!HashTable_V1.this._isInline) {
                object = (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType, PointerPointer.cast(object).at(0L).longValue());
            }
            return 0 == HashTable_V1.this._comparatorFn.compare(object, StructType);
        }
    }

    private class EqualFunctionWrapper {
        private EqualFunctionWrapper() {
        }

        public boolean equal(StructType object, StructType StructType) throws CorruptDataException {
            if (!HashTable_V1.this._isInline) {
                object = (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType, PointerPointer.cast(object).at(0L).longValue());
            }
            return HashTable_V1.this._equalFn.equal(object, StructType);
        }
    }

    private final class HashTableSlotIterator
    implements SlotIterator<StructType> {
        private SlotIterator<PointerPointer> listPoolIterator;
        private SlotIterator<J9AVLTreeNodePointer> treePoolIterator;
        private PointerPointer _spaceOptNode;
        private PointerPointer _tableTop;

        public HashTableSlotIterator() {
            block10: {
                this.listPoolIterator = null;
                this.treePoolIterator = null;
                this._spaceOptNode = null;
                if (!HashTable_V1.this.isSpaceOpt()) {
                    try {
                        this.listPoolIterator = Pool.fromJ9Pool(HashTable_V1.this._table.listNodePool(), PointerPointer.class).iterator();
                    }
                    catch (CorruptDataException corruptDataException) {
                        EventManager.raiseCorruptDataEvent("Error getting ListNodePool iterator", corruptDataException, false);
                    }
                    try {
                        J9PoolPointer j9PoolPointer = HashTable_V1.this._table.treeNodePool();
                        if (j9PoolPointer.notNull()) {
                            this.treePoolIterator = Pool.fromJ9Pool(j9PoolPointer, J9AVLTreeNodePointer.class).iterator();
                            break block10;
                        }
                        this.treePoolIterator = null;
                    }
                    catch (CorruptDataException corruptDataException) {
                        EventManager.raiseCorruptDataEvent("Error getting TreeNodePool iterator", corruptDataException, false);
                    }
                } else {
                    try {
                        this._spaceOptNode = HashTable_V1.this._table.nodes();
                        this._tableTop = HashTable_V1.this._table.nodes().add(HashTable_V1.this._table.tableSize());
                        if (this._spaceOptNode.isNull()) {
                            throw new CorruptDataException("Hashtable nodes pointer is null");
                        }
                        this.nextSpaceOpt();
                    }
                    catch (CorruptDataException corruptDataException) {
                        EventManager.raiseCorruptDataEvent("Error initializing space optimized hashtable", corruptDataException, true);
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            boolean bl = false;
            if (null != this.listPoolIterator && this.listPoolIterator.hasNext()) {
                bl = true;
            } else if (null != this.treePoolIterator && this.treePoolIterator.hasNext()) {
                bl = true;
            } else if (HashTable_V1.this.isSpaceOpt() && this._spaceOptNode.lt(this._tableTop)) {
                bl = true;
            }
            return bl;
        }

        @Override
        public StructType next() {
            PointerPointer pointerPointer = null;
            AbstractPointer abstractPointer = null;
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more available elements");
            }
            if (HashTable_V1.this.isSpaceOpt()) {
                pointerPointer = this._spaceOptNode;
                this._spaceOptNode = this._spaceOptNode.add(1L);
                try {
                    this.nextSpaceOpt();
                }
                catch (CorruptDataException corruptDataException) {
                    EventManager.raiseCorruptDataEvent("Hashtable nodes corrupted", corruptDataException, true);
                }
            } else if (this.listPoolIterator.hasNext()) {
                pointerPointer = (PointerPointer)this.listPoolIterator.next();
            } else if (this.treePoolIterator.hasNext()) {
                J9AVLTreeNodePointer j9AVLTreeNodePointer = (J9AVLTreeNodePointer)this.treePoolIterator.next();
                pointerPointer = PointerPointer.cast(HashTable_V1.this.avlNodeToData(j9AVLTreeNodePointer));
            }
            try {
                abstractPointer = HashTable_V1.this._isInline ? (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType.getSimpleName(), pointerPointer.getAddress()) : (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType.getSimpleName(), PointerPointer.cast(pointerPointer).at(0L).getAddress());
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Pool element corrupted", corruptDataException, true);
            }
            return abstractPointer;
        }

        @Override
        public VoidPointer nextAddress() {
            if (HashTable_V1.this._isInline) {
                throw new UnsupportedOperationException("Not supported.");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more available elements");
            }
            VoidPointer voidPointer = null;
            if (HashTable_V1.this.isSpaceOpt()) {
                voidPointer = VoidPointer.cast(this._spaceOptNode);
                this._spaceOptNode = this._spaceOptNode.add(1L);
                try {
                    this.nextSpaceOpt();
                }
                catch (CorruptDataException corruptDataException) {
                    EventManager.raiseCorruptDataEvent("Hashtable nodes corrupted", corruptDataException, true);
                }
            } else if (this.listPoolIterator.hasNext()) {
                voidPointer = this.listPoolIterator.nextAddress();
            } else if (this.treePoolIterator.hasNext()) {
                voidPointer = HashTable_V1.this.avlNodeToData((J9AVLTreeNodePointer)this.treePoolIterator.next());
            } else {
                throw new NoSuchElementException("There are no more available elements");
            }
            return voidPointer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The J9HashTable is read only and cannot be modified.");
        }

        private void nextSpaceOpt() throws CorruptDataException {
            while (this._spaceOptNode.lt(this._tableTop) && this._spaceOptNode.at(0L).isNull()) {
                this._spaceOptNode = this._spaceOptNode.add(1L);
            }
        }
    }
}

