/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.GCVMThreadStackSlotIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCClassHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCFinalizableObjectIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCJNIGlobalReferenceIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCJNIWeakGlobalReferenceIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCJVMTIObjectTagTableIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCJVMTIObjectTagTableListIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCMonitorReferenceIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCOwnableSynchronizerObjectListIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCRememberedSetIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCRememberedSetSlotIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCStringCacheTableIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCStringTableIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCUnfinalizedObjectListIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMClassSlotIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadJNISlotIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadMonitorRecordSlotIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadSlotIterator;
import com.ibm.j9ddr.vm29.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.IStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.ObjectMonitorReferencePointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JVMTIDataPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JVMTIEnvPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_SublistPuddlePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import com.ibm.j9ddr.vm29.structure.J9VMThread;
import com.ibm.j9ddr.vm29.structure.MM_GCExtensions;
import com.ibm.j9ddr.vm29.types.UDATA;

public abstract class RootScanner {
    private Reachability _reachability = Reachability.STRONG;
    private J9JavaVMPointer _vm;
    private MM_GCExtensionsPointer _extensions;
    private boolean _classDataAsRoots = true;
    private boolean _includeJVMTIObjectTagTables = true;
    private boolean _includeStackFrameClassReferences = true;
    private boolean _trackVisibleStackFrameDepth = false;
    private boolean _scanStackSlots = true;
    private boolean _stringTableAsRoot = true;
    private boolean _nurseryReferencesOnly = false;
    private boolean _nurseryReferencesPossibly = false;
    private boolean _includeRememberedSetReferences;
    private RootScannerStackWalkerCallbacks _stackWalkerCallbacks = new RootScannerStackWalkerCallbacks();

    protected RootScanner() throws CorruptDataException {
        this._vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        this._extensions = GCExtensions.getGCExtensionsPointer();
        this._includeRememberedSetReferences = this._extensions.scavengerEnabled();
        boolean bl = this._stringTableAsRoot = !this._extensions.collectStringConstants();
        this._classDataAsRoots = J9BuildFlags.J9VM_GC_DYNAMIC_CLASS_UNLOADING ? MM_GCExtensions.DynamicClassUnloading.DYNAMIC_CLASS_UNLOADING_NEVER == this._extensions.dynamicClassUnloading() : true;
    }

    public void setStringTableAsRoot(boolean bl) {
        this._stringTableAsRoot = bl;
    }

    public void setNurseryReferencesOnly(boolean bl) {
        if (J9BuildFlags.J9VM_GC_MODRON_SCAVENGER) {
            throw new UnsupportedOperationException("Not supported with non-scavenger based garbage collection");
        }
        this._nurseryReferencesOnly = bl;
    }

    public void setNurseryReferencesPossibly(boolean bl) {
        if (J9BuildFlags.J9VM_GC_MODRON_SCAVENGER) {
            throw new UnsupportedOperationException("Not supported with non-scavenger based garbage collection");
        }
        this._nurseryReferencesPossibly = bl;
    }

    public void setIncludeRememberedSetReferences(boolean bl) {
        if (J9BuildFlags.J9VM_GC_MODRON_SCAVENGER) {
            throw new UnsupportedOperationException("Not supported with non-scavenger based garbage collection");
        }
        this._includeRememberedSetReferences = bl;
    }

    public void setIncludeStackFrameClassReferences(boolean bl) {
        this._includeStackFrameClassReferences = bl;
    }

    public void setClassDataAsRoots(boolean bl) {
        if (J9BuildFlags.J9VM_GC_DYNAMIC_CLASS_UNLOADING) {
            throw new UnsupportedOperationException("Not supoprted without dynamic class unloading");
        }
        this._classDataAsRoots = bl;
    }

    public void setTrackVisibleStackFrameDepth(boolean bl) {
        this._trackVisibleStackFrameDepth = bl;
    }

    public void setScanStackSlots(boolean bl) {
        this._scanStackSlots = bl;
    }

    protected abstract void doClassSlot(J9ClassPointer var1);

    protected abstract void doClass(J9ClassPointer var1);

    protected abstract void doClassLoader(J9ClassLoaderPointer var1);

    protected abstract void doWeakReferenceSlot(J9ObjectPointer var1);

    protected abstract void doSoftReferenceSlot(J9ObjectPointer var1);

    protected abstract void doPhantomReferenceSlot(J9ObjectPointer var1);

    protected abstract void doFinalizableObject(J9ObjectPointer var1);

    protected abstract void doUnfinalizedObject(J9ObjectPointer var1);

    protected abstract void doOwnableSynchronizerObject(J9ObjectPointer var1);

    protected abstract void doMonitorReference(J9ObjectMonitorPointer var1);

    protected abstract void doMonitorLookupCacheSlot(J9ObjectMonitorPointer var1);

    protected abstract void doJNIWeakGlobalReference(J9ObjectPointer var1);

    protected abstract void doJNIGlobalReferenceSlot(J9ObjectPointer var1);

    protected abstract void doRememberedSlot(J9ObjectPointer var1);

    protected abstract void doJVMTIObjectTagSlot(J9ObjectPointer var1);

    protected abstract void doStringTableSlot(J9ObjectPointer var1);

    protected abstract void doStringCacheTableSlot(J9ObjectPointer var1);

    protected abstract void doVMClassSlot(J9ClassPointer var1);

    protected abstract void doVMThreadSlot(J9ObjectPointer var1);

    protected abstract void doVMThreadJNISlot(J9ObjectPointer var1);

    protected abstract void doVMThreadMonitorRecordSlot(J9ObjectPointer var1);

    protected abstract void doNonCollectableObjectSlot(J9ObjectPointer var1);

    protected abstract void doMemorySpaceSlot(J9ObjectPointer var1);

    protected abstract void doStackSlot(J9ObjectPointer var1);

    protected void doClassSlot(J9ClassPointer j9ClassPointer, VoidPointer voidPointer) {
        this.doClassSlot(j9ClassPointer);
    }

    protected void doClass(J9ClassPointer j9ClassPointer, VoidPointer voidPointer) {
        this.doClass(j9ClassPointer);
    }

    protected void doClassLoader(J9ClassLoaderPointer j9ClassLoaderPointer, VoidPointer voidPointer) {
        this.doClassLoader(j9ClassLoaderPointer);
    }

    protected void doWeakReferenceSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doWeakReferenceSlot(j9ObjectPointer);
    }

    protected void doSoftReferenceSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doSoftReferenceSlot(j9ObjectPointer);
    }

    protected void doPhantomReferenceSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doPhantomReferenceSlot(j9ObjectPointer);
    }

    protected void doMonitorLookupCacheSlot(J9ObjectMonitorPointer j9ObjectMonitorPointer, ObjectMonitorReferencePointer objectMonitorReferencePointer) {
        this.doMonitorLookupCacheSlot(j9ObjectMonitorPointer);
    }

    protected void doJNIWeakGlobalReference(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doJNIWeakGlobalReference(j9ObjectPointer);
    }

    protected void doJNIGlobalReferenceSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doJNIGlobalReferenceSlot(j9ObjectPointer);
    }

    protected void doRememberedSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doRememberedSlot(j9ObjectPointer);
    }

    protected void doJVMTIObjectTagSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doJVMTIObjectTagSlot(j9ObjectPointer);
    }

    protected void doStringTableSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doStringTableSlot(j9ObjectPointer);
    }

    protected void doStringCacheTableSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doStringCacheTableSlot(j9ObjectPointer);
    }

    protected void doVMClassSlot(J9ClassPointer j9ClassPointer, VoidPointer voidPointer) {
        this.doVMClassSlot(j9ClassPointer);
    }

    protected void doVMThreadSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doVMThreadSlot(j9ObjectPointer);
    }

    protected void doVMThreadJNISlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doVMThreadJNISlot(j9ObjectPointer);
    }

    protected void doVMThreadMonitorRecordSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doVMThreadMonitorRecordSlot(j9ObjectPointer);
    }

    protected void doNonCollectableObjectSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doNonCollectableObjectSlot(j9ObjectPointer);
    }

    protected void doMemoryAreaSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        this.doMemorySpaceSlot(j9ObjectPointer);
    }

    protected void doStackSlot(J9ObjectPointer j9ObjectPointer, WalkState walkState, VoidPointer voidPointer) {
        this.doStackSlot(j9ObjectPointer);
    }

    protected void scanPermanentClasses() throws CorruptDataException {
        J9ClassLoaderPointer j9ClassLoaderPointer = this._vm.systemClassLoader();
        J9ClassLoaderPointer j9ClassLoaderPointer2 = J9ClassLoaderPointer.cast(this._vm.applicationClassLoader());
        GCSegmentIterator gCSegmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(this._vm.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        this.setReachability(Reachability.STRONG);
        while (gCSegmentIterator.hasNext()) {
            J9MemorySegmentPointer j9MemorySegmentPointer = gCSegmentIterator.next();
            if (!j9MemorySegmentPointer.classLoader().equals(j9ClassLoaderPointer) && !j9MemorySegmentPointer.classLoader().equals(j9ClassLoaderPointer2)) continue;
            GCClassHeapIterator gCClassHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(j9MemorySegmentPointer);
            while (gCClassHeapIterator.hasNext()) {
                this.doClass(gCClassHeapIterator.next());
            }
        }
    }

    public void scanAllSlots() throws CorruptDataException {
        this.scanClasses();
        this.scanVMClassSlots();
        this.scanClassLoaders();
        this.scanThreads();
        if (J9BuildFlags.J9VM_GC_FINALIZATION) {
            this.scanFinalizableObjects();
        }
        this.scanJNIGlobalReferences();
        this.scanStringTable();
        this.scanWeakReferenceObjects();
        this.scanSoftReferenceObjects();
        this.scanPhantomReferenceObjects();
        if (J9BuildFlags.J9VM_GC_FINALIZATION) {
            this.scanUnfinalizedObjects();
        }
        this.scanMonitorReferences();
        this.scanJNIWeakGlobalReferences();
        if (J9BuildFlags.J9VM_GC_MODRON_SCAVENGER && this._extensions.scavengerEnabled()) {
            this.scanRememberedSet();
        }
        if (J9BuildFlags.J9VM_OPT_JVMTI) {
            this.scanJVMTIObjectTagTables();
        }
        this.scanOwnableSynchronizerObjects();
    }

    public void scanRoots() throws CorruptDataException {
        if (this._classDataAsRoots || this._nurseryReferencesOnly || this._nurseryReferencesPossibly) {
            this.scanClassLoaders();
        }
        if (!this._nurseryReferencesOnly && !this._nurseryReferencesPossibly) {
            if (J9BuildFlags.J9VM_GC_DYNAMIC_CLASS_UNLOADING) {
                if (this._classDataAsRoots) {
                    this.scanClasses();
                    this.setIncludeStackFrameClassReferences(false);
                } else {
                    this.scanPermanentClasses();
                    this.setIncludeStackFrameClassReferences(true);
                }
            } else {
                this.scanClasses();
                this.setIncludeStackFrameClassReferences(false);
            }
        }
        this.scanThreads();
        if (J9BuildFlags.J9VM_GC_FINALIZATION) {
            this.scanFinalizableObjects();
        }
        this.scanJNIGlobalReferences();
        if (this._stringTableAsRoot && !this._nurseryReferencesOnly && !this._nurseryReferencesPossibly) {
            this.scanStringTable();
        }
    }

    public void scanClearable() throws CorruptDataException {
        this.scanSoftReferenceObjects();
        this.scanWeakReferenceObjects();
        if (J9BuildFlags.J9VM_GC_FINALIZATION) {
            this.scanUnfinalizedObjects();
        }
        this.scanJNIWeakGlobalReferences();
        this.scanPhantomReferenceObjects();
        this.scanMonitorLookupCaches();
        this.scanMonitorReferences();
        if (!(this._stringTableAsRoot || this._nurseryReferencesOnly || this._nurseryReferencesPossibly)) {
            this.scanStringTable();
        }
        this.scanOwnableSynchronizerObjects();
        if (J9BuildFlags.J9VM_GC_MODRON_SCAVENGER && this._includeRememberedSetReferences && !this._nurseryReferencesOnly && !this._nurseryReferencesPossibly) {
            this.scanRememberedSet();
        }
        if (J9BuildFlags.J9VM_OPT_JVMTI && this._includeJVMTIObjectTagTables) {
            this.scanJVMTIObjectTagTables();
        }
    }

    protected void scanJVMTIObjectTagTables() throws CorruptDataException {
        if (!J9BuildFlags.J9VM_OPT_JVMTI) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        J9JVMTIDataPointer j9JVMTIDataPointer = J9JVMTIDataPointer.cast(this._vm.jvmtiData());
        if (j9JVMTIDataPointer.notNull()) {
            GCJVMTIObjectTagTableListIterator gCJVMTIObjectTagTableListIterator = GCJVMTIObjectTagTableListIterator.fromJ9JVMTIData(j9JVMTIDataPointer);
            while (gCJVMTIObjectTagTableListIterator.hasNext()) {
                J9JVMTIEnvPointer j9JVMTIEnvPointer = gCJVMTIObjectTagTableListIterator.next();
                GCJVMTIObjectTagTableIterator gCJVMTIObjectTagTableIterator = GCJVMTIObjectTagTableIterator.fromJ9JVMTIEnv(j9JVMTIEnvPointer);
                GCJVMTIObjectTagTableIterator gCJVMTIObjectTagTableIterator2 = GCJVMTIObjectTagTableIterator.fromJ9JVMTIEnv(j9JVMTIEnvPointer);
                while (gCJVMTIObjectTagTableIterator.hasNext()) {
                    this.doJVMTIObjectTagSlot(gCJVMTIObjectTagTableIterator.next(), gCJVMTIObjectTagTableIterator2.nextAddress());
                }
            }
        }
    }

    protected void scanNonCollectableObjects() throws CorruptDataException {
        this.scanNonCollectableObjectsInternal(J9MemorySegment.MEMORY_TYPE_IMMORTAL);
        this.scanNonCollectableObjectsInternal(J9MemorySegment.MEMORY_TYPE_SCOPED);
    }

    private void scanNonCollectableObjectsInternal(long l) throws CorruptDataException {
        GCHeapRegionIterator gCHeapRegionIterator = GCHeapRegionIterator.from();
        while (gCHeapRegionIterator.hasNext()) {
            GCHeapRegionDescriptor gCHeapRegionDescriptor = gCHeapRegionIterator.next();
            if (!new UDATA(gCHeapRegionDescriptor.getTypeFlags()).allBitsIn(l)) continue;
            GCObjectHeapIterator gCObjectHeapIterator = GCObjectHeapIterator.fromHeapRegionDescriptor(gCHeapRegionDescriptor, true, false);
            while (gCObjectHeapIterator.hasNext()) {
                J9ObjectPointer j9ObjectPointer = gCObjectHeapIterator.next();
                this.doClassSlot(J9ObjectHelper.clazz(j9ObjectPointer));
                GCObjectIterator gCObjectIterator = GCObjectIterator.fromJ9Object(j9ObjectPointer, true);
                GCObjectIterator gCObjectIterator2 = GCObjectIterator.fromJ9Object(j9ObjectPointer, true);
                while (gCObjectIterator.hasNext()) {
                    this.doNonCollectableObjectSlot(gCObjectIterator.next(), gCObjectIterator2.nextAddress());
                }
            }
        }
    }

    protected void scanRememberedSet() throws CorruptDataException {
        if (!J9BuildFlags.J9VM_GC_MODRON_SCAVENGER) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCRememberedSetIterator gCRememberedSetIterator = GCRememberedSetIterator.from();
        while (gCRememberedSetIterator.hasNext()) {
            MM_SublistPuddlePointer mM_SublistPuddlePointer = gCRememberedSetIterator.next();
            GCRememberedSetSlotIterator gCRememberedSetSlotIterator = GCRememberedSetSlotIterator.fromSublistPuddle(mM_SublistPuddlePointer);
            GCRememberedSetSlotIterator gCRememberedSetSlotIterator2 = GCRememberedSetSlotIterator.fromSublistPuddle(mM_SublistPuddlePointer);
            while (gCRememberedSetSlotIterator.hasNext()) {
                this.doRememberedSlot(gCRememberedSetSlotIterator.next(), gCRememberedSetSlotIterator2.nextAddress());
            }
        }
    }

    protected void scanJNIWeakGlobalReferences() throws CorruptDataException {
        this.setReachability(Reachability.WEAK);
        GCJNIWeakGlobalReferenceIterator gCJNIWeakGlobalReferenceIterator = GCJNIWeakGlobalReferenceIterator.from();
        GCJNIWeakGlobalReferenceIterator gCJNIWeakGlobalReferenceIterator2 = GCJNIWeakGlobalReferenceIterator.from();
        while (gCJNIWeakGlobalReferenceIterator.hasNext()) {
            this.doJNIWeakGlobalReference(gCJNIWeakGlobalReferenceIterator.next(), gCJNIWeakGlobalReferenceIterator2.nextAddress());
        }
    }

    protected void scanMonitorReferences() throws CorruptDataException {
        this.setReachability(Reachability.WEAK);
        GCMonitorReferenceIterator gCMonitorReferenceIterator = GCMonitorReferenceIterator.from();
        while (gCMonitorReferenceIterator.hasNext()) {
            this.doMonitorReference(gCMonitorReferenceIterator.next());
        }
    }

    protected void scanUnfinalizedObjects() throws CorruptDataException {
        if (!J9BuildFlags.J9VM_GC_FINALIZATION) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCUnfinalizedObjectListIterator gCUnfinalizedObjectListIterator = GCUnfinalizedObjectListIterator.from();
        while (gCUnfinalizedObjectListIterator.hasNext()) {
            this.doUnfinalizedObject(gCUnfinalizedObjectListIterator.next());
        }
    }

    protected void scanOwnableSynchronizerObjects() throws CorruptDataException {
        this.setReachability(Reachability.WEAK);
        GCOwnableSynchronizerObjectListIterator gCOwnableSynchronizerObjectListIterator = GCOwnableSynchronizerObjectListIterator.from();
        while (gCOwnableSynchronizerObjectListIterator.hasNext()) {
            J9ObjectPointer j9ObjectPointer = gCOwnableSynchronizerObjectListIterator.next();
            this.doOwnableSynchronizerObject(j9ObjectPointer);
        }
    }

    protected void scanMonitorLookupCaches() throws CorruptDataException {
        this.setReachability(Reachability.WEAK);
        GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
        while (gCVMThreadListIterator.hasNext()) {
            J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
            ObjectMonitorReferencePointer objectMonitorReferencePointer = j9VMThreadPointer.objectMonitorLookupCacheEA();
            for (long i = 0L; i < J9VMThread.J9VMTHREAD_OBJECT_MONITOR_CACHE_SIZE; ++i) {
                ObjectMonitorReferencePointer objectMonitorReferencePointer2 = objectMonitorReferencePointer.add(i);
                this.doMonitorLookupCacheSlot(objectMonitorReferencePointer2.at(0L), objectMonitorReferencePointer2);
            }
        }
    }

    protected void scanPhantomReferenceObjects() throws CorruptDataException {
    }

    protected void scanSoftReferenceObjects() throws CorruptDataException {
    }

    protected void scanWeakReferenceObjects() throws CorruptDataException {
    }

    protected void scanStringTable() throws CorruptDataException {
        if (this._extensions.collectStringConstants()) {
            this.setReachability(Reachability.WEAK);
        } else {
            this.setReachability(Reachability.STRONG);
        }
        GCStringTableIterator gCStringTableIterator = GCStringTableIterator.from();
        GCStringTableIterator gCStringTableIterator2 = GCStringTableIterator.from();
        while (gCStringTableIterator.hasNext()) {
            this.doStringTableSlot(gCStringTableIterator.next(), gCStringTableIterator2.nextAddress());
        }
        GCStringCacheTableIterator gCStringCacheTableIterator = GCStringCacheTableIterator.from();
        GCStringCacheTableIterator gCStringCacheTableIterator2 = GCStringCacheTableIterator.from();
        while (gCStringCacheTableIterator.hasNext()) {
            this.doStringCacheTableSlot(gCStringCacheTableIterator.next(), gCStringCacheTableIterator2.nextAddress());
        }
    }

    protected void scanJNIGlobalReferences() throws CorruptDataException {
        this.setReachability(Reachability.STRONG);
        GCJNIGlobalReferenceIterator gCJNIGlobalReferenceIterator = GCJNIGlobalReferenceIterator.from();
        GCJNIGlobalReferenceIterator gCJNIGlobalReferenceIterator2 = GCJNIGlobalReferenceIterator.from();
        while (gCJNIGlobalReferenceIterator.hasNext()) {
            this.doJNIGlobalReferenceSlot(gCJNIGlobalReferenceIterator.next(), gCJNIGlobalReferenceIterator2.nextAddress());
        }
    }

    protected void scanFinalizableObjects() throws CorruptDataException {
        if (!J9BuildFlags.J9VM_GC_FINALIZATION) {
            return;
        }
        this.setReachability(Reachability.STRONG);
        GCFinalizableObjectIterator gCFinalizableObjectIterator = GCFinalizableObjectIterator.from();
        while (gCFinalizableObjectIterator.hasNext()) {
            this.doFinalizableObject(gCFinalizableObjectIterator.next());
        }
    }

    protected void scanThreads() throws CorruptDataException {
        this.setReachability(Reachability.STRONG);
        GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
        while (gCVMThreadListIterator.hasNext()) {
            J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
            GCVMThreadSlotIterator gCVMThreadSlotIterator = GCVMThreadSlotIterator.fromJ9VMThread(j9VMThreadPointer);
            GCVMThreadSlotIterator gCVMThreadSlotIterator2 = GCVMThreadSlotIterator.fromJ9VMThread(j9VMThreadPointer);
            while (gCVMThreadSlotIterator.hasNext()) {
                this.doVMThreadSlot(gCVMThreadSlotIterator.next(), gCVMThreadSlotIterator2.nextAddress());
            }
            GCVMThreadJNISlotIterator gCVMThreadJNISlotIterator = GCVMThreadJNISlotIterator.fromJ9VMThread(j9VMThreadPointer);
            GCVMThreadJNISlotIterator gCVMThreadJNISlotIterator2 = GCVMThreadJNISlotIterator.fromJ9VMThread(j9VMThreadPointer);
            while (gCVMThreadJNISlotIterator.hasNext()) {
                this.doVMThreadJNISlot(gCVMThreadJNISlotIterator.next(), gCVMThreadJNISlotIterator2.nextAddress());
            }
            if (J9BuildFlags.J9VM_INTERP_HOT_CODE_REPLACEMENT) {
                GCVMThreadMonitorRecordSlotIterator gCVMThreadMonitorRecordSlotIterator = GCVMThreadMonitorRecordSlotIterator.fromJ9VMThread(j9VMThreadPointer);
                GCVMThreadMonitorRecordSlotIterator gCVMThreadMonitorRecordSlotIterator2 = GCVMThreadMonitorRecordSlotIterator.fromJ9VMThread(j9VMThreadPointer);
                while (gCVMThreadMonitorRecordSlotIterator.hasNext()) {
                    this.doVMThreadMonitorRecordSlot(gCVMThreadMonitorRecordSlotIterator.next(), gCVMThreadMonitorRecordSlotIterator2.nextAddress());
                }
            }
            if (!this._scanStackSlots) continue;
            GCVMThreadStackSlotIterator.scanSlots(j9VMThreadPointer, this._stackWalkerCallbacks, this._includeStackFrameClassReferences, this._trackVisibleStackFrameDepth);
        }
    }

    protected void scanClassLoaders() throws CorruptDataException {
        J9ClassLoaderPointer j9ClassLoaderPointer = this._vm.systemClassLoader();
        J9ClassLoaderPointer j9ClassLoaderPointer2 = J9ClassLoaderPointer.cast(this._vm.applicationClassLoader());
        GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
        while (gCClassLoaderIterator.hasNext()) {
            long l;
            J9ClassLoaderPointer j9ClassLoaderPointer3 = gCClassLoaderIterator.next();
            Reachability reachability = J9BuildFlags.J9VM_GC_DYNAMIC_CLASS_UNLOADING ? (MM_GCExtensions.DynamicClassUnloading.DYNAMIC_CLASS_UNLOADING_NEVER == (l = this._extensions.dynamicClassUnloading()) ? Reachability.STRONG : (j9ClassLoaderPointer3.eq(j9ClassLoaderPointer) || j9ClassLoaderPointer3.eq(j9ClassLoaderPointer2) ? Reachability.STRONG : Reachability.WEAK)) : Reachability.STRONG;
            this.setReachability(reachability);
            this.doClassLoader(j9ClassLoaderPointer3);
        }
    }

    protected void scanVMClassSlots() throws CorruptDataException {
        GCVMClassSlotIterator gCVMClassSlotIterator = GCVMClassSlotIterator.from();
        GCVMClassSlotIterator gCVMClassSlotIterator2 = GCVMClassSlotIterator.from();
        this.setReachability(Reachability.STRONG);
        while (gCVMClassSlotIterator.hasNext()) {
            this.doVMClassSlot(gCVMClassSlotIterator.next(), gCVMClassSlotIterator2.nextAddress());
        }
    }

    protected void scanClasses() throws CorruptDataException {
        J9ClassLoaderPointer j9ClassLoaderPointer = this._vm.systemClassLoader();
        J9ClassLoaderPointer j9ClassLoaderPointer2 = J9ClassLoaderPointer.cast(this._vm.applicationClassLoader());
        GCSegmentIterator gCSegmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(this._vm.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        while (gCSegmentIterator.hasNext()) {
            J9MemorySegmentPointer j9MemorySegmentPointer = gCSegmentIterator.next();
            GCClassHeapIterator gCClassHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(j9MemorySegmentPointer);
            while (gCClassHeapIterator.hasNext()) {
                long l;
                J9ClassPointer j9ClassPointer = gCClassHeapIterator.next();
                Reachability reachability = J9BuildFlags.J9VM_GC_DYNAMIC_CLASS_UNLOADING ? (MM_GCExtensions.DynamicClassUnloading.DYNAMIC_CLASS_UNLOADING_NEVER == (l = this._extensions.dynamicClassUnloading()) ? Reachability.STRONG : (j9ClassPointer.classLoader().eq(j9ClassLoaderPointer) || j9ClassPointer.classLoader().eq(j9ClassLoaderPointer2) ? Reachability.STRONG : Reachability.WEAK)) : Reachability.STRONG;
                this.setReachability(reachability);
                this.doClass(j9ClassPointer);
            }
        }
    }

    private void setReachability(Reachability reachability) {
        this._reachability = reachability;
    }

    protected Reachability getReachability() {
        return this._reachability;
    }

    private class RootScannerStackWalkerCallbacks
    implements IStackWalkerCallbacks {
        private RootScannerStackWalkerCallbacks() {
        }

        @Override
        public FrameCallbackResult frameWalkFunction(WalkState walkState) {
            return FrameCallbackResult.KEEP_ITERATING;
        }

        @Override
        public void objectSlotWalkFunction(WalkState walkState, PointerPointer pointerPointer, VoidPointer voidPointer) {
            try {
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(pointerPointer.at(0L));
                if (j9ObjectPointer.notNull()) {
                    RootScanner.this.doStackSlot(j9ObjectPointer, walkState, voidPointer);
                }
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Corrupt stack object slot detected", corruptDataException, false);
            }
        }

        @Override
        public void fieldSlotWalkFunction(WalkState walkState, ObjectReferencePointer objectReferencePointer, VoidPointer voidPointer) {
            try {
                J9ObjectPointer j9ObjectPointer = objectReferencePointer.at(0L);
                if (j9ObjectPointer.notNull()) {
                    RootScanner.this.doStackSlot(j9ObjectPointer, walkState, voidPointer);
                }
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Corrupt stack object slot detected", corruptDataException, false);
            }
        }
    }

    public static enum Reachability {
        STRONG,
        WEAK;

    }
}

