/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ITablePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import java.util.NoSuchElementException;

public class GCClassLocalInterfaceIterator
extends GCIterator {
    protected J9ITablePointer iTable;
    protected J9ITablePointer superclassITable;

    protected GCClassLocalInterfaceIterator(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        this.iTable = J9ITablePointer.cast(j9ClassPointer.iTable());
        J9ClassPointer j9ClassPointer2 = J9ClassHelper.superclass(j9ClassPointer);
        this.superclassITable = j9ClassPointer2.isNull() ? J9ITablePointer.NULL : J9ITablePointer.cast(j9ClassPointer2.iTable());
    }

    public static GCClassLocalInterfaceIterator fromJ9Class(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return new GCClassLocalInterfaceIterator(j9ClassPointer);
    }

    @Override
    public boolean hasNext() {
        return !this.iTable.eq(this.superclassITable);
    }

    @Override
    public J9ClassPointer next() {
        if (this.hasNext()) {
            try {
                J9ClassPointer j9ClassPointer = this.iTable.interfaceClass();
                this.iTable = this.iTable.next();
                return j9ClassPointer;
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            try {
                VoidPointer voidPointer = VoidPointer.cast(this.iTable.interfaceClassEA());
                this.iTable = this.iTable.next();
                return voidPointer;
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

