/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.GC_FinalizeListManagerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import java.util.NoSuchElementException;

public class GCFinalizableObjectIterator
extends GCIterator {
    public static final int state_start = 0;
    public static final int state_system = 1;
    public static final int state_default = 2;
    public static final int state_reference = 3;
    public static final int state_end = 4;
    protected int _state = 0;
    protected J9ObjectPointer _currentSystemObject;
    protected J9ObjectPointer _currentDefaultObject;
    protected J9ObjectPointer _currentReferenceObject;
    GC_FinalizeListManagerPointer _manager = null;

    protected GCFinalizableObjectIterator(GC_FinalizeListManagerPointer gC_FinalizeListManagerPointer) throws CorruptDataException {
        this._manager = gC_FinalizeListManagerPointer;
        this._currentSystemObject = this.getFirstSystemFinalizableObject();
        this._currentDefaultObject = this.getFirstDefaultFinalizableObject();
        this._currentReferenceObject = gC_FinalizeListManagerPointer._referenceObjects();
    }

    public static GCFinalizableObjectIterator from() throws CorruptDataException {
        return new GCFinalizableObjectIterator(GCFinalizableObjectIterator.getExtensions().finalizeListManager());
    }

    @Override
    public boolean hasNext() {
        if (this._state == 4) {
            return false;
        }
        switch (this._state) {
            case 0: {
                ++this._state;
            }
            case 1: {
                if (this._currentSystemObject.notNull()) {
                    return true;
                }
                ++this._state;
            }
            case 2: {
                if (this._currentDefaultObject.notNull()) {
                    return true;
                }
                ++this._state;
            }
            case 3: {
                if (this._currentReferenceObject.notNull()) {
                    return true;
                }
                ++this._state;
            }
        }
        return false;
    }

    @Override
    public J9ObjectPointer next() {
        try {
            if (this.hasNext()) {
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.NULL;
                switch (this._state) {
                    case 1: {
                        j9ObjectPointer = this._currentSystemObject;
                        this.advanceToNextSystemFinalizableObject();
                        break;
                    }
                    case 2: {
                        j9ObjectPointer = this._currentDefaultObject;
                        this.advanceToNextDefaultFinalizableObject();
                        break;
                    }
                    case 3: {
                        j9ObjectPointer = this._currentReferenceObject;
                        this._currentReferenceObject = ObjectAccessBarrier.getReferenceLink(this._currentReferenceObject);
                    }
                }
                return j9ObjectPointer;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
            if (this._state < 4) {
                ++this._state;
            }
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }

    public int getState() {
        return this._state;
    }

    private J9ObjectPointer getFirstSystemFinalizableObject() throws CorruptDataException {
        J9ObjectPointer j9ObjectPointer = this._manager._systemFinalizableObjects();
        return j9ObjectPointer;
    }

    private J9ObjectPointer getFirstDefaultFinalizableObject() throws CorruptDataException {
        J9ObjectPointer j9ObjectPointer = this._manager._defaultFinalizableObjects();
        return j9ObjectPointer;
    }

    private void advanceToNextSystemFinalizableObject() throws CorruptDataException {
        this._currentSystemObject = ObjectAccessBarrier.getFinalizeLink(this._currentSystemObject);
    }

    private void advanceToNextDefaultFinalizableObject() throws CorruptDataException {
        this._currentDefaultObject = ObjectAccessBarrier.getFinalizeLink(this._currentDefaultObject);
    }
}

