/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.CorruptFreeEntryException;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolAddressOrderedList;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolAggregatedCellList;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolSplitAddressOrderedList;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapLinkedFreeHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolPointer;
import com.ibm.j9ddr.vm29.types.UDATA;

public abstract class GCMemoryPool {
    protected String _poolName = null;
    protected MemoryPoolType _memoryPoolType = MemoryPoolType.NULL;
    protected GCHeapRegionDescriptor _region = null;
    protected MM_MemoryPoolPointer _memoryPool = null;

    public GCMemoryPool(GCHeapRegionDescriptor gCHeapRegionDescriptor, MM_MemoryPoolPointer mM_MemoryPoolPointer) throws CorruptDataException {
        this._poolName = mM_MemoryPoolPointer._poolName().getCStringAtOffset(0L);
        this._memoryPool = mM_MemoryPoolPointer;
        this._region = gCHeapRegionDescriptor;
    }

    public static GCMemoryPool fromMemoryPoolPointerInRegion(GCHeapRegionDescriptor gCHeapRegionDescriptor, MM_MemoryPoolPointer mM_MemoryPoolPointer) throws CorruptDataException {
        MM_GCExtensionsPointer mM_GCExtensionsPointer = GCBase.getExtensions();
        boolean bl = mM_GCExtensionsPointer.splitFreeListSplitAmount().gt(1);
        boolean bl2 = mM_GCExtensionsPointer.concurrentSweep();
        if (GCExtensions.isSegregatedHeap()) {
            return new GCMemoryPoolAggregatedCellList(gCHeapRegionDescriptor, mM_MemoryPoolPointer);
        }
        if (GCExtensions.isStandardGC()) {
            String string = mM_MemoryPoolPointer._poolName().getCStringAtOffset(0L);
            if (string.equals("Allocate/Survivor1") || string.equals("Allocate/Survivor2")) {
                return new GCMemoryPoolAddressOrderedList(gCHeapRegionDescriptor, mM_MemoryPoolPointer);
            }
            if (string.equals("Unknown") || string.equals("LOA") || string.equals("Tenure")) {
                if (bl) {
                    if (bl2) {
                        return new GCMemoryPoolAddressOrderedList(gCHeapRegionDescriptor, mM_MemoryPoolPointer);
                    }
                    return new GCMemoryPoolSplitAddressOrderedList(gCHeapRegionDescriptor, mM_MemoryPoolPointer);
                }
                return new GCMemoryPoolAddressOrderedList(gCHeapRegionDescriptor, mM_MemoryPoolPointer);
            }
            throw new CorruptDataException("Unreachable");
        }
        if (GCExtensions.isVLHGC()) {
            throw new UnsupportedOperationException("Balanced GC not supported");
        }
        throw new CorruptDataException("Unreachable");
    }

    public MemoryPoolType getType() {
        return this._memoryPoolType;
    }

    public String getPoolName() {
        return this._poolName;
    }

    public GCHeapRegionDescriptor getRegion() {
        return this._region;
    }

    public MM_MemoryPoolPointer getMemoryPoolPointer() {
        return this._memoryPool;
    }

    protected void freeEntryCheckGeneric(GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader) throws CorruptDataException, CorruptFreeEntryException {
        MM_HeapLinkedFreeHeaderPointer mM_HeapLinkedFreeHeaderPointer = gCHeapLinkedFreeHeader.getHeader();
        UDATA uDATA = gCHeapLinkedFreeHeader.getSize();
        GCHeapRegionDescriptor gCHeapRegionDescriptor = this.getRegion();
        U8Pointer u8Pointer = U8Pointer.cast(gCHeapLinkedFreeHeader.getHeader()).add(uDATA.sub(1L));
        if (gCHeapLinkedFreeHeader.getHeader().isNull()) {
            throw new CorruptFreeEntryException("freeEntryCorrupt", mM_HeapLinkedFreeHeaderPointer);
        }
        if (!ObjectModel.isHoleObject(gCHeapLinkedFreeHeader.getObject()) || ObjectModel.isSingleSlotHoleObject(gCHeapLinkedFreeHeader.getObject())) {
            throw new CorruptFreeEntryException("freeEntryCorrupt", mM_HeapLinkedFreeHeaderPointer);
        }
        if (!gCHeapRegionDescriptor.isAddressInRegion(VoidPointer.cast(mM_HeapLinkedFreeHeaderPointer))) {
            throw new CorruptFreeEntryException("freeEntryCorrupt", mM_HeapLinkedFreeHeaderPointer);
        }
        if (!gCHeapRegionDescriptor.isAddressInRegion(VoidPointer.cast(u8Pointer))) {
            throw new CorruptFreeEntryException("sizeFieldInvalid", mM_HeapLinkedFreeHeaderPointer);
        }
    }

    public void checkFreeLists(IEventListener iEventListener) {
        EventManager.register(iEventListener);
        this.checkFreeListsImpl();
        EventManager.unregister(iEventListener);
    }

    void checkFreeListsImpl() {
    }

    public String toString() {
        return String.format("Pool name: %s Pool Address: %s Region: %s", this.getPoolName(), this._memoryPool.getHexAddress(), this._region.getHeapRegionDescriptorPointer().getHexAddress());
    }

    public static enum MemoryPoolType {
        AOL,
        BUMP,
        SAOL,
        SEGREGATED,
        NULL;

    }
}

