/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolAddressOrderedList;
import com.ibm.j9ddr.vm29.j9.gc.GCModronAllocateHintIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModronAllocateHintPointer;
import java.util.NoSuchElementException;

public class GCModronAllocateHintIteratorAOL
extends GCModronAllocateHintIterator {
    protected J9ModronAllocateHintPointer _currentHint = null;
    protected GCMemoryPoolAddressOrderedList _memoryPool = null;

    public GCModronAllocateHintIteratorAOL(GCMemoryPoolAddressOrderedList gCMemoryPoolAddressOrderedList) throws CorruptDataException {
        this._memoryPool = gCMemoryPoolAddressOrderedList;
        this._currentHint = gCMemoryPoolAddressOrderedList.getFirstHint();
        if (this._currentHint.isNull()) {
            this._currentHint = null;
        }
    }

    private void advanceHint() {
        try {
            this._currentHint = this._currentHint.next();
            if (this._currentHint.isNull()) {
                this._currentHint = null;
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Freelist corruption detected", corruptDataException, false);
            this._currentHint = null;
        }
    }

    @Override
    public boolean hasNext() {
        return null != this._currentHint;
    }

    @Override
    public J9ModronAllocateHintPointer next() {
        if (this.hasNext()) {
            J9ModronAllocateHintPointer j9ModronAllocateHintPointer = this._currentHint;
            this.advanceHint();
            return j9ModronAllocateHintPointer;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public int getFreeListNumber() {
        return 0;
    }

    @Override
    public String toString() {
        GCModronAllocateHintIteratorAOL gCModronAllocateHintIteratorAOL = null;
        try {
            gCModronAllocateHintIteratorAOL = new GCModronAllocateHintIteratorAOL(this._memoryPool);
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Corruption detected", corruptDataException, false);
            return corruptDataException.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        while (gCModronAllocateHintIteratorAOL.hasNext()) {
            stringBuilder.append(gCModronAllocateHintIteratorAOL.next().getHexAddress() + string);
        }
        return stringBuilder.toString();
    }
}

